/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.primitives;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.primitives.FloatsMethodsForWeb;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public final class Floats
extends FloatsMethodsForWeb {
    public static int hashCode(float f2) {
        return Float.valueOf(f2).hashCode();
    }

    private static int indexOf(float[] fArray, float f2, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (fArray[i2] != f2) continue;
            return i2;
        }
        return -1;
    }

    private static int lastIndexOf(float[] fArray, float f2, int n2, int n3) {
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            if (fArray[i2] != f2) continue;
            return i2;
        }
        return -1;
    }

    public static List<Float> asList(float ... fArray) {
        if (fArray.length == 0) {
            return Collections.emptyList();
        }
        return new FloatArrayAsList(fArray);
    }

    private static class FloatArrayAsList
    extends AbstractList<Float>
    implements Serializable,
    RandomAccess {
        final float[] array;
        final int start;
        final int end;

        FloatArrayAsList(float[] fArray) {
            this(fArray, 0, fArray.length);
        }

        FloatArrayAsList(float[] fArray, int n2, int n3) {
            this.array = fArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Float get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return Float.valueOf(this.array[this.start + n2]);
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Float && Floats.indexOf(this.array, ((Float)object).floatValue(), this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Float && (n2 = Floats.indexOf(this.array, ((Float)object).floatValue(), this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Float && (n2 = Floats.lastIndexOf(this.array, ((Float)object).floatValue(), this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Float set(int n2, Float f2) {
            Preconditions.checkElementIndex(n2, this.size());
            float f3 = this.array[this.start + n2];
            this.array[this.start + n2] = Preconditions.checkNotNull(f2).floatValue();
            return Float.valueOf(f3);
        }

        @Override
        public List<Float> subList(int n2, int n3) {
            int n4 = this.size();
            Preconditions.checkPositionIndexes(n2, n3, n4);
            if (n2 == n3) {
                return Collections.emptyList();
            }
            return new FloatArrayAsList(this.array, this.start + n2, this.start + n3);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof FloatArrayAsList) {
                FloatArrayAsList floatArrayAsList = (FloatArrayAsList)object;
                int n2 = this.size();
                if (floatArrayAsList.size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == floatArrayAsList.array[floatArrayAsList.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = 31 * n2 + Floats.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 12);
            stringBuilder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                stringBuilder.append(", ").append(this.array[i2]);
            }
            return stringBuilder.append(']').toString();
        }
    }
}

