/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.Expression;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.common.ExpressionUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CompiledExpression;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelCompilerMode;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelParserConfiguration;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard.SpelCompiler;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import java.util.concurrent.atomic.AtomicInteger;

public class SpelExpression
implements Expression {
    private final String expression;
    private final SpelNodeImpl ast;
    private final SpelParserConfiguration configuration;
    private volatile CompiledExpression compiledAst;
    private final AtomicInteger interpretedCount = new AtomicInteger();
    private final AtomicInteger failedAttempts = new AtomicInteger();

    public SpelExpression(String string, SpelNodeImpl spelNodeImpl, SpelParserConfiguration spelParserConfiguration) {
        this.expression = string;
        this.ast = spelNodeImpl;
        this.configuration = spelParserConfiguration;
    }

    @Override
    public Object getValue(EvaluationContext evaluationContext, Object object) throws EvaluationException {
        Assert.notNull((Object)evaluationContext, "EvaluationContext is required");
        CompiledExpression compiledExpression = this.compiledAst;
        if (compiledExpression != null) {
            try {
                return compiledExpression.getValue(object, evaluationContext);
            }
            catch (Throwable throwable) {
                if (this.configuration.getCompilerMode() == SpelCompilerMode.MIXED) {
                    this.compiledAst = null;
                    this.interpretedCount.set(0);
                }
                throw new SpelEvaluationException(throwable, SpelMessage.EXCEPTION_RUNNING_COMPILED_EXPRESSION, new Object[0]);
            }
        }
        ExpressionState expressionState = new ExpressionState(evaluationContext, this.toTypedValue(object), this.configuration);
        Object object2 = this.ast.getValue(expressionState);
        this.checkCompile(expressionState);
        return object2;
    }

    @Override
    public <T> T getValue(EvaluationContext evaluationContext, Object object, Class<T> clazz) throws EvaluationException {
        Assert.notNull((Object)evaluationContext, "EvaluationContext is required");
        CompiledExpression compiledExpression = this.compiledAst;
        if (compiledExpression != null) {
            try {
                Object object2 = compiledExpression.getValue(object, evaluationContext);
                if (clazz != null) {
                    return ExpressionUtils.convertTypedValue(evaluationContext, new TypedValue(object2), clazz);
                }
                return (T)object2;
            }
            catch (Throwable throwable) {
                if (this.configuration.getCompilerMode() == SpelCompilerMode.MIXED) {
                    this.compiledAst = null;
                    this.interpretedCount.set(0);
                }
                throw new SpelEvaluationException(throwable, SpelMessage.EXCEPTION_RUNNING_COMPILED_EXPRESSION, new Object[0]);
            }
        }
        ExpressionState expressionState = new ExpressionState(evaluationContext, this.toTypedValue(object), this.configuration);
        TypedValue typedValue = this.ast.getTypedValue(expressionState);
        this.checkCompile(expressionState);
        return ExpressionUtils.convertTypedValue(evaluationContext, typedValue, clazz);
    }

    private void checkCompile(ExpressionState expressionState) {
        this.interpretedCount.incrementAndGet();
        SpelCompilerMode spelCompilerMode = expressionState.getConfiguration().getCompilerMode();
        if (spelCompilerMode != SpelCompilerMode.OFF) {
            if (spelCompilerMode == SpelCompilerMode.IMMEDIATE) {
                if (this.interpretedCount.get() > 1) {
                    this.compileExpression();
                }
            } else if (this.interpretedCount.get() > 100) {
                this.compileExpression();
            }
        }
    }

    public boolean compileExpression() {
        CompiledExpression compiledExpression = this.compiledAst;
        if (compiledExpression != null) {
            return true;
        }
        if (this.failedAttempts.get() > 100) {
            return false;
        }
        SpelExpression spelExpression = this;
        synchronized (spelExpression) {
            if (this.compiledAst != null) {
                return true;
            }
            try {
                SpelCompiler spelCompiler = SpelCompiler.getCompiler(this.configuration.getCompilerClassLoader());
                compiledExpression = spelCompiler.compile(this.ast);
                if (compiledExpression != null) {
                    this.compiledAst = compiledExpression;
                    return true;
                }
                this.failedAttempts.incrementAndGet();
                return false;
            }
            catch (Exception exception) {
                this.failedAttempts.incrementAndGet();
                if (this.configuration.getCompilerMode() == SpelCompilerMode.MIXED) {
                    this.compiledAst = null;
                    this.interpretedCount.set(0);
                    return false;
                }
                throw new SpelEvaluationException(exception, SpelMessage.EXCEPTION_COMPILING_EXPRESSION, new Object[0]);
            }
        }
    }

    private TypedValue toTypedValue(Object object) {
        return object != null ? new TypedValue(object) : TypedValue.NULL;
    }
}

