/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.DatatypeException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.ValidationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.Comparator;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.DataTypeWithFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.EnumerationFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.ErrorType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.FinalComponent;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.FractionDigitsFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.LengthFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.MaxExclusiveFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.MaxInclusiveFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.MaxLengthFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.MinExclusiveFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.MinInclusiveFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.MinLengthFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.PatternFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.RangeFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.TotalDigitsFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.WhiteSpaceFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatypeImpl;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class TypeIncubator {
    private final Map impl = new HashMap();
    private final XSDatatypeImpl baseType;
    private static final String[][] exclusiveFacetPairs = new String[][]{{"length", "minLength"}, {"length", "maxLength"}, {"maxInclusive", "maxExclusive"}, {"minInclusive", "minExclusive"}};

    public TypeIncubator(XSDatatype xSDatatype) {
        this.baseType = (XSDatatypeImpl)xSDatatype;
        if (xSDatatype == null) {
            throw new IllegalArgumentException();
        }
    }

    public void add(String string, String string2, boolean bl2, ValidationContext validationContext) throws DatatypeException {
        this.addFacet(string, string2, bl2, validationContext);
    }

    public void addFacet(String string, String string2, boolean bl2, ValidationContext validationContext) throws DatatypeException {
        Object object;
        if (this.baseType instanceof ErrorType) {
            return;
        }
        switch (this.baseType.isFacetApplicable(string)) {
            case 0: {
                break;
            }
            case -1: {
                return;
            }
            case -2: {
                throw new DatatypeException(XSDatatypeImpl.localize("BadTypeException.NotApplicableFacet", string));
            }
            default: {
                throw new Error();
            }
        }
        if (TypeIncubator.isValueFacet(string)) {
            object = this.baseType.createValue(string2, validationContext);
            if (object == null) {
                throw new DatatypeException(XSDatatypeImpl.localize("EnumerationFacet.InvalidValueForThisType", string2, this.baseType.displayName()));
            }
        } else {
            object = string2;
        }
        if (TypeIncubator.isRepeatable(string)) {
            FacetInfo facetInfo;
            if (this.impl.containsKey(string)) {
                facetInfo = (FacetInfo)this.impl.get(string);
            } else {
                facetInfo = new FacetInfo(new Vector(), bl2);
                this.impl.put(string, facetInfo);
            }
            ((Vector)facetInfo.value).add(object);
            facetInfo.fixed |= bl2;
        } else {
            if (this.impl.containsKey(string)) {
                throw new DatatypeException(XSDatatypeImpl.localize("BadTypeException.DuplicateFacet", string));
            }
            this.impl.put(string, new FacetInfo(object, bl2));
        }
    }

    public XSDatatypeImpl derive(String string) throws DatatypeException {
        return this.derive("", string);
    }

    public XSDatatypeImpl derive(String string, String string2) throws DatatypeException {
        if (this.baseType instanceof ErrorType) {
            return this.baseType;
        }
        if (this.baseType.isFinal(1)) {
            throw new DatatypeException(XSDatatypeImpl.localize("BadTypeException.InvalidBaseType", this.baseType.displayName()));
        }
        if (this.isEmpty()) {
            if (string == null && string2 == null) {
                return this.baseType;
            }
            return new FinalComponent(string, string2, this.baseType, 0);
        }
        XSDatatypeImpl xSDatatypeImpl = this.baseType;
        for (int i2 = 0; i2 < exclusiveFacetPairs.length; ++i2) {
            if (!this.contains(exclusiveFacetPairs[i2][0]) || !this.contains(exclusiveFacetPairs[i2][1])) continue;
            throw new DatatypeException(XSDatatypeImpl.localize("XAndYAreExclusive", exclusiveFacetPairs[i2][0], exclusiveFacetPairs[i2][1]));
        }
        if (this.contains("totalDigits")) {
            xSDatatypeImpl = new TotalDigitsFacet(string, string2, xSDatatypeImpl, this.getPositiveInteger("totalDigits"), this.isFixed("totalDigits"));
        }
        if (this.contains("fractionDigits")) {
            xSDatatypeImpl = new FractionDigitsFacet(string, string2, xSDatatypeImpl, this.getNonNegativeInteger("fractionDigits"), this.isFixed("fractionDigits"));
        }
        if (this.contains("minInclusive")) {
            xSDatatypeImpl = new MinInclusiveFacet(string, string2, xSDatatypeImpl, this.getFacet("minInclusive"), this.isFixed("minInclusive"));
        }
        if (this.contains("maxInclusive")) {
            xSDatatypeImpl = new MaxInclusiveFacet(string, string2, xSDatatypeImpl, this.getFacet("maxInclusive"), this.isFixed("maxInclusive"));
        }
        if (this.contains("minExclusive")) {
            xSDatatypeImpl = new MinExclusiveFacet(string, string2, xSDatatypeImpl, this.getFacet("minExclusive"), this.isFixed("minExclusive"));
        }
        if (this.contains("maxExclusive")) {
            xSDatatypeImpl = new MaxExclusiveFacet(string, string2, xSDatatypeImpl, this.getFacet("maxExclusive"), this.isFixed("maxExclusive"));
        }
        if (this.contains("length")) {
            xSDatatypeImpl = new LengthFacet(string, string2, xSDatatypeImpl, this);
        }
        if (this.contains("minLength")) {
            xSDatatypeImpl = new MinLengthFacet(string, string2, xSDatatypeImpl, this);
        }
        if (this.contains("maxLength")) {
            xSDatatypeImpl = new MaxLengthFacet(string, string2, xSDatatypeImpl, this);
        }
        if (this.contains("whiteSpace")) {
            xSDatatypeImpl = new WhiteSpaceFacet(string, string2, xSDatatypeImpl, this);
        }
        if (this.contains("pattern")) {
            xSDatatypeImpl = new PatternFacet(string, string2, xSDatatypeImpl, this);
        }
        if (this.contains("enumeration")) {
            xSDatatypeImpl = new EnumerationFacet(string, string2, xSDatatypeImpl, this.getVector("enumeration"), this.isFixed("enumeration"));
        }
        DataTypeWithFacet dataTypeWithFacet = xSDatatypeImpl.getFacetObject("maxLength");
        DataTypeWithFacet dataTypeWithFacet2 = xSDatatypeImpl.getFacetObject("minLength");
        if (dataTypeWithFacet != null && dataTypeWithFacet2 != null && ((MaxLengthFacet)dataTypeWithFacet).maxLength < ((MinLengthFacet)dataTypeWithFacet2).minLength) {
            throw TypeIncubator.reportFacetInconsistency(string2, dataTypeWithFacet, "maxLength", dataTypeWithFacet2, "minLength");
        }
        dataTypeWithFacet = xSDatatypeImpl.getFacetObject("fractionDigits");
        dataTypeWithFacet2 = xSDatatypeImpl.getFacetObject("totalDigits");
        if (dataTypeWithFacet != null && dataTypeWithFacet2 != null && ((FractionDigitsFacet)dataTypeWithFacet).scale > ((TotalDigitsFacet)dataTypeWithFacet2).precision) {
            throw TypeIncubator.reportFacetInconsistency(string2, dataTypeWithFacet, "fractionDigits", dataTypeWithFacet2, "totalDigits");
        }
        TypeIncubator.checkRangeConsistency(xSDatatypeImpl, "minInclusive", "maxInclusive");
        TypeIncubator.checkRangeConsistency(xSDatatypeImpl, "minExclusive", "maxExclusive");
        TypeIncubator.checkRangeConsistency(xSDatatypeImpl, "minInclusive", "maxExclusive");
        TypeIncubator.checkRangeConsistency(xSDatatypeImpl, "minExclusive", "maxInclusive");
        return xSDatatypeImpl;
    }

    private static void checkRangeConsistency(XSDatatypeImpl xSDatatypeImpl, String string, String string2) throws DatatypeException {
        int n2;
        DataTypeWithFacet dataTypeWithFacet = xSDatatypeImpl.getFacetObject(string);
        DataTypeWithFacet dataTypeWithFacet2 = xSDatatypeImpl.getFacetObject(string2);
        if (dataTypeWithFacet != null && dataTypeWithFacet2 != null && (n2 = ((Comparator)((Object)dataTypeWithFacet.getConcreteType())).compare(((RangeFacet)dataTypeWithFacet).limitValue, ((RangeFacet)dataTypeWithFacet2).limitValue)) == 1) {
            throw TypeIncubator.reportFacetInconsistency(xSDatatypeImpl.displayName(), dataTypeWithFacet, string, dataTypeWithFacet2, string2);
        }
    }

    private static DatatypeException reportFacetInconsistency(String string, DataTypeWithFacet dataTypeWithFacet, String string2, DataTypeWithFacet dataTypeWithFacet2, String string3) {
        String string4;
        String string5 = dataTypeWithFacet.getName();
        if (string5.equals(string4 = dataTypeWithFacet2.getName())) {
            return new DatatypeException(XSDatatypeImpl.localize("InconsistentFacets.1", string2, string3));
        }
        if (string5.equals(string)) {
            return new DatatypeException(XSDatatypeImpl.localize("InconsistentFacets.2", string2, dataTypeWithFacet2.displayName(), string3));
        }
        if (string4.equals(string)) {
            return new DatatypeException(XSDatatypeImpl.localize("InconsistentFacets.2", string3, dataTypeWithFacet.displayName(), string2));
        }
        throw new IllegalStateException();
    }

    private static boolean isValueFacet(String string) {
        return string.equals("enumeration") || string.equals("maxExclusive") || string.equals("minExclusive") || string.equals("maxInclusive") || string.equals("minInclusive");
    }

    private static boolean isRepeatable(String string) {
        return string.equals("enumeration") || string.equals("pattern");
    }

    public boolean isFixed(String string) {
        return ((FacetInfo)this.impl.get((Object)string)).fixed;
    }

    public Object getFacet(String string) {
        return ((FacetInfo)this.impl.get((Object)string)).value;
    }

    public Vector getVector(String string) {
        return (Vector)((FacetInfo)this.impl.get((Object)string)).value;
    }

    public int getPositiveInteger(String string) throws DatatypeException {
        try {
            int n2 = Integer.parseInt((String)this.getFacet(string));
            if (n2 > 0) {
                return n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            try {
                if (new BigInteger((String)this.getFacet(string)).signum() > 0) {
                    return Integer.MAX_VALUE;
                }
            }
            catch (NumberFormatException numberFormatException2) {
                // empty catch block
            }
        }
        throw new DatatypeException(XSDatatypeImpl.localize("BadTypeException.FacetMustBePositiveInteger", string));
    }

    public int getNonNegativeInteger(String string) throws DatatypeException {
        try {
            int n2 = Integer.parseInt((String)this.getFacet(string));
            if (n2 >= 0) {
                return n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new DatatypeException(XSDatatypeImpl.localize("BadTypeException.FacetMustBeNonNegativeInteger", string));
    }

    private boolean contains(String string) {
        return this.impl.containsKey(string);
    }

    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    public void dump(PrintStream printStream) {
        for (String string : this.impl.keySet()) {
            FacetInfo facetInfo = (FacetInfo)this.impl.get(string);
            if (facetInfo.value instanceof Vector) {
                printStream.println(string + " :");
                Vector vector = (Vector)facetInfo.value;
                for (int i2 = 0; i2 < vector.size(); ++i2) {
                    printStream.println("  " + vector.elementAt(i2));
                }
                continue;
            }
            printStream.println(string + " : " + facetInfo.value);
        }
    }

    public String getFacetNames() {
        String string = "";
        Iterator iterator = this.impl.keySet().iterator();
        while (iterator.hasNext()) {
            if (string.length() != 0) {
                string = string + ", ";
            }
            string = string + (String)iterator.next();
        }
        return string;
    }

    private static class FacetInfo {
        public Object value;
        public boolean fixed;

        public FacetInfo(Object object, boolean bl2) {
            this.value = object;
            this.fixed = bl2;
        }
    }
}

