/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.identity;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.Datatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.xmlschema.XPath;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.identity.IDConstraintChecker;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.identity.Matcher;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.identity.MatcherBundle;
import org.xml.sax.SAXException;

public abstract class PathMatcher
extends MatcherBundle {
    private boolean matchFound = false;

    protected PathMatcher(IDConstraintChecker iDConstraintChecker, XPath[] xPathArray) {
        super(iDConstraintChecker);
        this.children = new Matcher[xPathArray.length];
        for (int i2 = 0; i2 < xPathArray.length; ++i2) {
            this.children[i2] = new SinglePathMatcher(xPathArray[i2]);
        }
    }

    protected void start(String string, String string2) throws SAXException {
        if (this.matchFound) {
            this.onElementMatched(string, string2);
        }
        this.matchFound = false;
    }

    protected abstract void onElementMatched(String var1, String var2) throws SAXException;

    protected abstract void onAttributeMatched(String var1, String var2, String var3, Datatype var4) throws SAXException;

    protected void startElement(String string, String string2) throws SAXException {
        super.startElement(string, string2);
        if (this.matchFound) {
            this.onElementMatched(string, string2);
        }
        this.matchFound = false;
    }

    protected void onAttribute(String string, String string2, String string3, Datatype datatype) throws SAXException {
        super.onAttribute(string, string2, string3, datatype);
        if (this.matchFound) {
            this.onAttributeMatched(string, string2, string3, datatype);
        }
        this.matchFound = false;
    }

    private class SinglePathMatcher
    extends Matcher {
        private boolean[][] activeSteps;
        protected final XPath path;
        private boolean elementMatched;

        protected SinglePathMatcher(XPath xPath) {
            super(PathMatcher.this.owner);
            this.elementMatched = false;
            this.path = xPath;
            this.activeSteps = new boolean[4][];
            this.activeSteps[0] = new boolean[xPath.steps.length + 1];
            this.activeSteps[0][0] = true;
            if (xPath.steps.length == 0) {
                if (xPath.attributeStep == null) {
                    PathMatcher.this.matchFound = true;
                } else {
                    this.elementMatched = true;
                }
            }
        }

        protected void startElement(String string, String string2) throws SAXException {
            this.elementMatched = false;
            int n2 = PathMatcher.this.getDepth();
            if (n2 == this.activeSteps.length - 1) {
                boolean[][] blArrayArray = new boolean[n2 * 2][];
                System.arraycopy(this.activeSteps, 0, blArrayArray, 0, this.activeSteps.length);
                this.activeSteps = blArrayArray;
            }
            int n3 = this.path.steps.length;
            boolean[] blArray = this.activeSteps[n2 - 1];
            boolean[] blArray2 = this.activeSteps[n2];
            if (blArray2 == null) {
                blArray2 = new boolean[n3 + 1];
                this.activeSteps[n2] = blArray2;
            }
            if (n3 != 0) {
                System.arraycopy(blArray, 0, blArray2, 1, n3);
                blArray2[0] = this.path.isAnyDescendant;
            }
            for (int i2 = 1; i2 <= n3; ++i2) {
                if (!blArray2[i2] || this.path.steps[i2 - 1].accepts(string, string2)) continue;
                blArray2[i2] = false;
            }
            if (blArray2[n3]) {
                if (this.path.attributeStep == null) {
                    PathMatcher.this.matchFound = true;
                } else {
                    this.elementMatched = true;
                }
            }
        }

        protected void onAttribute(String string, String string2, String string3, Datatype datatype) throws SAXException {
            if (!this.elementMatched) {
                return;
            }
            if (this.path.attributeStep.accepts(string, string2)) {
                PathMatcher.this.matchFound = true;
            }
        }

        protected void endElement(Datatype datatype) {
            this.elementMatched = false;
        }
    }
}

