/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.google.j2objc.annotations.Weak;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Equivalence;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.AbstractMapEntry;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectPreconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterators;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.MapMaker;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.MapMakerInternalMap$StrongValueEntry;
import com.gradle.maven.extension.internal.dep.com.google.common.primitives.Ints;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;

class MapMakerInternalMap<K, V, E extends InternalEntry<K, V, E>, S extends Segment<K, V, E, S>>
extends AbstractMap<K, V>
implements Serializable,
ConcurrentMap<K, V> {
    final transient int segmentMask;
    final transient int segmentShift;
    final transient Segment<K, V, E, S>[] segments;
    final int concurrencyLevel;
    final Equivalence<Object> keyEquivalence;
    final transient InternalEntryHelper<K, V, E, S> entryHelper;
    static final WeakValueReference<Object, Object, DummyInternalEntry> UNSET_WEAK_VALUE_REFERENCE = new WeakValueReference<Object, Object, DummyInternalEntry>(){

        @Override
        public DummyInternalEntry getEntry() {
            return null;
        }

        @Override
        public void clear() {
        }

        @Override
        public Object get() {
            return null;
        }

        @Override
        public WeakValueReference<Object, Object, DummyInternalEntry> copyFor(ReferenceQueue<Object> referenceQueue, DummyInternalEntry dummyInternalEntry) {
            return this;
        }
    };
    transient Set<K> keySet;
    transient Collection<V> values;
    transient Set<Map.Entry<K, V>> entrySet;

    private MapMakerInternalMap(MapMaker mapMaker, InternalEntryHelper<K, V, E, S> internalEntryHelper) {
        int n2;
        int n3;
        this.concurrencyLevel = Math.min(mapMaker.getConcurrencyLevel(), 65536);
        this.keyEquivalence = mapMaker.getKeyEquivalence();
        this.entryHelper = internalEntryHelper;
        int n4 = Math.min(mapMaker.getInitialCapacity(), 0x40000000);
        int n5 = 0;
        for (n3 = 1; n3 < this.concurrencyLevel; n3 <<= 1) {
            ++n5;
        }
        this.segmentShift = 32 - n5;
        this.segmentMask = n3 - 1;
        this.segments = this.newSegmentArray(n3);
        int n6 = n4 / n3;
        if (n6 * n3 < n4) {
            ++n6;
        }
        for (n2 = 1; n2 < n6; n2 <<= 1) {
        }
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2] = this.createSegment(n2);
        }
    }

    static <K, V> MapMakerInternalMap<K, V, ? extends InternalEntry<K, V, ?>, ?> create(MapMaker mapMaker) {
        if (mapMaker.getKeyStrength() == Strength.STRONG && mapMaker.getValueStrength() == Strength.STRONG) {
            return new MapMakerInternalMap(mapMaker, StrongKeyStrongValueEntry.Helper.instance());
        }
        if (mapMaker.getKeyStrength() == Strength.STRONG && mapMaker.getValueStrength() == Strength.WEAK) {
            return new MapMakerInternalMap(mapMaker, StrongKeyWeakValueEntry.Helper.instance());
        }
        if (mapMaker.getKeyStrength() == Strength.WEAK && mapMaker.getValueStrength() == Strength.STRONG) {
            return new MapMakerInternalMap(mapMaker, WeakKeyStrongValueEntry.Helper.instance());
        }
        if (mapMaker.getKeyStrength() == Strength.WEAK && mapMaker.getValueStrength() == Strength.WEAK) {
            return new MapMakerInternalMap(mapMaker, WeakKeyWeakValueEntry.Helper.instance());
        }
        throw new AssertionError();
    }

    static <K> MapMakerInternalMap<K, MapMaker.Dummy, ? extends InternalEntry<K, MapMaker.Dummy, ?>, ?> createWithDummyValues(MapMaker mapMaker) {
        if (mapMaker.getKeyStrength() == Strength.STRONG && mapMaker.getValueStrength() == Strength.STRONG) {
            return new MapMakerInternalMap(mapMaker, StrongKeyDummyValueEntry.Helper.instance());
        }
        if (mapMaker.getKeyStrength() == Strength.WEAK && mapMaker.getValueStrength() == Strength.STRONG) {
            return new MapMakerInternalMap(mapMaker, WeakKeyDummyValueEntry.Helper.instance());
        }
        if (mapMaker.getValueStrength() == Strength.WEAK) {
            throw new IllegalArgumentException("Map cannot have both weak and dummy values");
        }
        throw new AssertionError();
    }

    static <K, V, E extends InternalEntry<K, V, E>> WeakValueReference<K, V, E> unsetWeakValueReference() {
        return UNSET_WEAK_VALUE_REFERENCE;
    }

    static int rehash(int n2) {
        n2 += n2 << 15 ^ 0xFFFFCD7D;
        n2 ^= n2 >>> 10;
        n2 += n2 << 3;
        n2 ^= n2 >>> 6;
        n2 += (n2 << 2) + (n2 << 14);
        return n2 ^ n2 >>> 16;
    }

    int hash(Object object) {
        int n2 = this.keyEquivalence.hash(object);
        return MapMakerInternalMap.rehash(n2);
    }

    void reclaimValue(WeakValueReference<K, V, E> weakValueReference) {
        E e2 = weakValueReference.getEntry();
        int n2 = e2.getHash();
        this.segmentFor(n2).reclaimValue(e2.getKey(), n2, weakValueReference);
    }

    void reclaimKey(E e2) {
        int n2 = e2.getHash();
        this.segmentFor(n2).reclaimKey(e2, n2);
    }

    Segment<K, V, E, S> segmentFor(int n2) {
        return this.segments[n2 >>> this.segmentShift & this.segmentMask];
    }

    Segment<K, V, E, S> createSegment(int n2) {
        return this.entryHelper.newSegment(this, n2);
    }

    V getLiveValue(E e2) {
        if (e2.getKey() == null) {
            return null;
        }
        return e2.getValue();
    }

    final Segment<K, V, E, S>[] newSegmentArray(int n2) {
        return new Segment[n2];
    }

    Equivalence<Object> valueEquivalence() {
        return this.entryHelper.valueStrength().defaultEquivalence();
    }

    @Override
    public boolean isEmpty() {
        int n2;
        long l2 = 0L;
        Segment<K, V, E, S>[] segmentArray = this.segments;
        for (n2 = 0; n2 < segmentArray.length; ++n2) {
            if (segmentArray[n2].count != 0) {
                return false;
            }
            l2 += (long)segmentArray[n2].modCount;
        }
        if (l2 != 0L) {
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                if (segmentArray[n2].count != 0) {
                    return false;
                }
                l2 -= (long)segmentArray[n2].modCount;
            }
            return l2 == 0L;
        }
        return true;
    }

    @Override
    public int size() {
        Segment<K, V, E, S>[] segmentArray = this.segments;
        long l2 = 0L;
        for (int i2 = 0; i2 < segmentArray.length; ++i2) {
            l2 += (long)segmentArray[i2].count;
        }
        return Ints.saturatedCast(l2);
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            return null;
        }
        int n2 = this.hash(object);
        return this.segmentFor(n2).get(object, n2);
    }

    E getEntry(Object object) {
        if (object == null) {
            return null;
        }
        int n2 = this.hash(object);
        return this.segmentFor(n2).getEntry(object, n2);
    }

    @Override
    public boolean containsKey(Object object) {
        if (object == null) {
            return false;
        }
        int n2 = this.hash(object);
        return this.segmentFor(n2).containsKey(object, n2);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return false;
        }
        Segment<K, V, E, S>[] segmentArray = this.segments;
        long l2 = -1L;
        for (int i2 = 0; i2 < 3; ++i2) {
            long l3 = 0L;
            for (Segment<K, V, InternalEntry, S> segment : segmentArray) {
                int n2 = segment.count;
                AtomicReferenceArray atomicReferenceArray = segment.table;
                for (int i3 = 0; i3 < atomicReferenceArray.length(); ++i3) {
                    for (InternalEntry internalEntry = (InternalEntry)atomicReferenceArray.get(i3); internalEntry != null; internalEntry = internalEntry.getNext()) {
                        V v2 = segment.getLiveValue(internalEntry);
                        if (v2 == null || !this.valueEquivalence().equivalent(object, v2)) continue;
                        return true;
                    }
                }
                l3 += (long)segment.modCount;
            }
            if (l3 == l2) break;
            l2 = l3;
        }
        return false;
    }

    @Override
    public V put(K k2, V v2) {
        Preconditions.checkNotNull(k2);
        Preconditions.checkNotNull(v2);
        int n2 = this.hash(k2);
        return this.segmentFor(n2).put(k2, n2, v2, false);
    }

    @Override
    public V putIfAbsent(K k2, V v2) {
        Preconditions.checkNotNull(k2);
        Preconditions.checkNotNull(v2);
        int n2 = this.hash(k2);
        return this.segmentFor(n2).put(k2, n2, v2, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            return null;
        }
        int n2 = this.hash(object);
        return this.segmentFor(n2).remove(object, n2);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        if (object == null || object2 == null) {
            return false;
        }
        int n2 = this.hash(object);
        return this.segmentFor(n2).remove(object, n2, object2);
    }

    @Override
    public boolean replace(K k2, V v2, V v3) {
        Preconditions.checkNotNull(k2);
        Preconditions.checkNotNull(v3);
        if (v2 == null) {
            return false;
        }
        int n2 = this.hash(k2);
        return this.segmentFor(n2).replace(k2, n2, v2, v3);
    }

    @Override
    public V replace(K k2, V v2) {
        Preconditions.checkNotNull(k2);
        Preconditions.checkNotNull(v2);
        int n2 = this.hash(k2);
        return this.segmentFor(n2).replace(k2, n2, v2);
    }

    @Override
    public void clear() {
        for (Segment<K, V, E, S> segment : this.segments) {
            segment.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values != null ? values : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    private static <E> ArrayList<E> toArrayList(Collection<E> collection) {
        ArrayList arrayList = new ArrayList(collection.size());
        Iterators.addAll(arrayList, collection.iterator());
        return arrayList;
    }

    private static abstract class SafeToArraySet<E>
    extends AbstractSet<E> {
        private SafeToArraySet() {
        }

        @Override
        public Object[] toArray() {
            return MapMakerInternalMap.toArrayList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return MapMakerInternalMap.toArrayList(this).toArray(TArray);
        }
    }

    final class EntrySet
    extends SafeToArraySet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(MapMakerInternalMap.this);
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k2 = entry.getKey();
            if (k2 == null) {
                return false;
            }
            Object v2 = MapMakerInternalMap.this.get(k2);
            return v2 != null && MapMakerInternalMap.this.valueEquivalence().equivalent(entry.getValue(), v2);
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k2 = entry.getKey();
            return k2 != null && MapMakerInternalMap.this.remove(k2, entry.getValue());
        }

        @Override
        public int size() {
            return MapMakerInternalMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return MapMakerInternalMap.this.isEmpty();
        }

        @Override
        public void clear() {
            MapMakerInternalMap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator(MapMakerInternalMap.this);
        }

        @Override
        public int size() {
            return MapMakerInternalMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return MapMakerInternalMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return MapMakerInternalMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            MapMakerInternalMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return MapMakerInternalMap.toArrayList(this).toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return MapMakerInternalMap.toArrayList(this).toArray(TArray);
        }
    }

    final class KeySet
    extends SafeToArraySet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(MapMakerInternalMap.this);
        }

        @Override
        public int size() {
            return MapMakerInternalMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return MapMakerInternalMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return MapMakerInternalMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return MapMakerInternalMap.this.remove(object) != null;
        }

        @Override
        public void clear() {
            MapMakerInternalMap.this.clear();
        }
    }

    final class EntryIterator
    extends HashIterator {
        EntryIterator(MapMakerInternalMap mapMakerInternalMap) {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    final class WriteThroughEntry
    extends AbstractMapEntry<K, V> {
        final K key;
        V value;

        WriteThroughEntry(K k2, V v2) {
            this.key = k2;
            this.value = v2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this.key.equals(entry.getKey()) && this.value.equals(entry.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        @Override
        public V setValue(V v2) {
            Object v3 = MapMakerInternalMap.this.put(this.key, v2);
            this.value = v2;
            return v3;
        }
    }

    final class ValueIterator
    extends HashIterator {
        ValueIterator(MapMakerInternalMap mapMakerInternalMap) {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    final class KeyIterator
    extends HashIterator {
        KeyIterator(MapMakerInternalMap mapMakerInternalMap) {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    abstract class HashIterator<T>
    implements Iterator<T> {
        int nextSegmentIndex;
        int nextTableIndex;
        Segment<K, V, E, S> currentSegment;
        AtomicReferenceArray<E> currentTable;
        E nextEntry;
        WriteThroughEntry nextExternal;
        WriteThroughEntry lastReturned;

        HashIterator() {
            this.nextSegmentIndex = MapMakerInternalMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        final void advance() {
            this.nextExternal = null;
            if (this.nextInChain()) {
                return;
            }
            if (this.nextInTable()) {
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                this.currentSegment = MapMakerInternalMap.this.segments[this.nextSegmentIndex--];
                if (this.currentSegment.count == 0) continue;
                this.currentTable = this.currentSegment.table;
                this.nextTableIndex = this.currentTable.length() - 1;
                if (!this.nextInTable()) continue;
                return;
            }
        }

        boolean nextInChain() {
            if (this.nextEntry != null) {
                this.nextEntry = this.nextEntry.getNext();
                while (this.nextEntry != null) {
                    if (this.advanceTo(this.nextEntry)) {
                        return true;
                    }
                    this.nextEntry = this.nextEntry.getNext();
                }
            }
            return false;
        }

        boolean nextInTable() {
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = (InternalEntry)this.currentTable.get(this.nextTableIndex--)) == null || !this.advanceTo(this.nextEntry) && !this.nextInChain()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean advanceTo(E e2) {
            try {
                Object k2 = e2.getKey();
                Object v2 = MapMakerInternalMap.this.getLiveValue(e2);
                if (v2 != null) {
                    this.nextExternal = new WriteThroughEntry(k2, v2);
                    boolean bl2 = true;
                    return bl2;
                }
                boolean bl3 = false;
                return bl3;
            }
            finally {
                this.currentSegment.postReadCleanup();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextExternal != null;
        }

        WriteThroughEntry nextEntry() {
            if (this.nextExternal == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextExternal;
            this.advance();
            return this.lastReturned;
        }

        @Override
        public void remove() {
            CollectPreconditions.checkRemove(this.lastReturned != null);
            MapMakerInternalMap.this.remove(this.lastReturned.getKey());
            this.lastReturned = null;
        }
    }

    static final class WeakKeyDummyValueSegment<K>
    extends Segment<K, MapMaker.Dummy, WeakKeyDummyValueEntry<K>, WeakKeyDummyValueSegment<K>> {
        private final ReferenceQueue<K> queueForKeys = new ReferenceQueue();

        WeakKeyDummyValueSegment(MapMakerInternalMap<K, MapMaker.Dummy, WeakKeyDummyValueEntry<K>, WeakKeyDummyValueSegment<K>> mapMakerInternalMap, int n2) {
            super(mapMakerInternalMap, n2);
        }

        @Override
        WeakKeyDummyValueSegment<K> self() {
            return this;
        }

        @Override
        void maybeDrainReferenceQueues() {
            this.drainKeyReferenceQueue(this.queueForKeys);
        }

        @Override
        void maybeClearReferenceQueues() {
            this.clearReferenceQueue(this.queueForKeys);
        }
    }

    static final class WeakKeyWeakValueSegment<K, V>
    extends Segment<K, V, WeakKeyWeakValueEntry<K, V>, WeakKeyWeakValueSegment<K, V>> {
        private final ReferenceQueue<K> queueForKeys = new ReferenceQueue();
        private final ReferenceQueue<V> queueForValues = new ReferenceQueue();

        WeakKeyWeakValueSegment(MapMakerInternalMap<K, V, WeakKeyWeakValueEntry<K, V>, WeakKeyWeakValueSegment<K, V>> mapMakerInternalMap, int n2) {
            super(mapMakerInternalMap, n2);
        }

        @Override
        WeakKeyWeakValueSegment<K, V> self() {
            return this;
        }

        @Override
        void maybeDrainReferenceQueues() {
            this.drainKeyReferenceQueue(this.queueForKeys);
            this.drainValueReferenceQueue(this.queueForValues);
        }

        @Override
        void maybeClearReferenceQueues() {
            this.clearReferenceQueue(this.queueForKeys);
        }
    }

    static final class WeakKeyStrongValueSegment<K, V>
    extends Segment<K, V, WeakKeyStrongValueEntry<K, V>, WeakKeyStrongValueSegment<K, V>> {
        private final ReferenceQueue<K> queueForKeys = new ReferenceQueue();

        WeakKeyStrongValueSegment(MapMakerInternalMap<K, V, WeakKeyStrongValueEntry<K, V>, WeakKeyStrongValueSegment<K, V>> mapMakerInternalMap, int n2) {
            super(mapMakerInternalMap, n2);
        }

        @Override
        WeakKeyStrongValueSegment<K, V> self() {
            return this;
        }

        @Override
        void maybeDrainReferenceQueues() {
            this.drainKeyReferenceQueue(this.queueForKeys);
        }

        @Override
        void maybeClearReferenceQueues() {
            this.clearReferenceQueue(this.queueForKeys);
        }
    }

    static final class StrongKeyDummyValueSegment<K>
    extends Segment<K, MapMaker.Dummy, StrongKeyDummyValueEntry<K>, StrongKeyDummyValueSegment<K>> {
        StrongKeyDummyValueSegment(MapMakerInternalMap<K, MapMaker.Dummy, StrongKeyDummyValueEntry<K>, StrongKeyDummyValueSegment<K>> mapMakerInternalMap, int n2) {
            super(mapMakerInternalMap, n2);
        }

        @Override
        StrongKeyDummyValueSegment<K> self() {
            return this;
        }
    }

    static final class StrongKeyWeakValueSegment<K, V>
    extends Segment<K, V, StrongKeyWeakValueEntry<K, V>, StrongKeyWeakValueSegment<K, V>> {
        private final ReferenceQueue<V> queueForValues = new ReferenceQueue();

        StrongKeyWeakValueSegment(MapMakerInternalMap<K, V, StrongKeyWeakValueEntry<K, V>, StrongKeyWeakValueSegment<K, V>> mapMakerInternalMap, int n2) {
            super(mapMakerInternalMap, n2);
        }

        @Override
        StrongKeyWeakValueSegment<K, V> self() {
            return this;
        }

        @Override
        void maybeDrainReferenceQueues() {
            this.drainValueReferenceQueue(this.queueForValues);
        }

        @Override
        void maybeClearReferenceQueues() {
            this.clearReferenceQueue(this.queueForValues);
        }
    }

    static final class StrongKeyStrongValueSegment<K, V>
    extends Segment<K, V, StrongKeyStrongValueEntry<K, V>, StrongKeyStrongValueSegment<K, V>> {
        StrongKeyStrongValueSegment(MapMakerInternalMap<K, V, StrongKeyStrongValueEntry<K, V>, StrongKeyStrongValueSegment<K, V>> mapMakerInternalMap, int n2) {
            super(mapMakerInternalMap, n2);
        }

        @Override
        StrongKeyStrongValueSegment<K, V> self() {
            return this;
        }
    }

    static abstract class Segment<K, V, E extends InternalEntry<K, V, E>, S extends Segment<K, V, E, S>>
    extends ReentrantLock {
        @Weak
        final MapMakerInternalMap<K, V, E, S> map;
        volatile int count;
        int modCount;
        int threshold;
        volatile AtomicReferenceArray<E> table;
        final AtomicInteger readCount = new AtomicInteger();

        Segment(MapMakerInternalMap<K, V, E, S> mapMakerInternalMap, int n2) {
            this.map = mapMakerInternalMap;
            this.initTable(this.newEntryArray(n2));
        }

        abstract S self();

        void maybeDrainReferenceQueues() {
        }

        void maybeClearReferenceQueues() {
        }

        void setValue(E e2, V v2) {
            this.map.entryHelper.setValue(this.self(), e2, v2);
        }

        E copyEntry(E e2, E e3) {
            return this.map.entryHelper.copy(this.self(), e2, e3);
        }

        AtomicReferenceArray<E> newEntryArray(int n2) {
            return new AtomicReferenceArray(n2);
        }

        void initTable(AtomicReferenceArray<E> atomicReferenceArray) {
            this.threshold = atomicReferenceArray.length() * 3 / 4;
            this.table = atomicReferenceArray;
        }

        void tryDrainReferenceQueues() {
            if (this.tryLock()) {
                try {
                    this.maybeDrainReferenceQueues();
                }
                finally {
                    this.unlock();
                }
            }
        }

        void drainKeyReferenceQueue(ReferenceQueue<K> referenceQueue) {
            Reference<K> reference;
            int n2 = 0;
            while ((reference = referenceQueue.poll()) != null) {
                InternalEntry internalEntry = (InternalEntry)((Object)reference);
                this.map.reclaimKey(internalEntry);
                if (++n2 != 16) continue;
                break;
            }
        }

        void drainValueReferenceQueue(ReferenceQueue<V> referenceQueue) {
            Reference<V> reference;
            int n2 = 0;
            while ((reference = referenceQueue.poll()) != null) {
                WeakValueReference weakValueReference = (WeakValueReference)((Object)reference);
                this.map.reclaimValue(weakValueReference);
                if (++n2 != 16) continue;
                break;
            }
        }

        <T> void clearReferenceQueue(ReferenceQueue<T> referenceQueue) {
            while (referenceQueue.poll() != null) {
            }
        }

        E getFirst(int n2) {
            AtomicReferenceArray<E> atomicReferenceArray = this.table;
            return (E)((InternalEntry)atomicReferenceArray.get(n2 & atomicReferenceArray.length() - 1));
        }

        E getEntry(Object object, int n2) {
            if (this.count != 0) {
                for (E e2 = this.getFirst(n2); e2 != null; e2 = e2.getNext()) {
                    if (e2.getHash() != n2) continue;
                    Object k2 = e2.getKey();
                    if (k2 == null) {
                        this.tryDrainReferenceQueues();
                        continue;
                    }
                    if (!this.map.keyEquivalence.equivalent(object, k2)) continue;
                    return e2;
                }
            }
            return null;
        }

        E getLiveEntry(Object object, int n2) {
            return this.getEntry(object, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V get(Object object, int n2) {
            try {
                E e2 = this.getLiveEntry(object, n2);
                if (e2 == null) {
                    V v2 = null;
                    return v2;
                }
                Object v3 = e2.getValue();
                if (v3 == null) {
                    this.tryDrainReferenceQueues();
                }
                Object v4 = v3;
                return v4;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean containsKey(Object object, int n2) {
            try {
                if (this.count != 0) {
                    E e2 = this.getLiveEntry(object, n2);
                    boolean bl2 = e2 != null && e2.getValue() != null;
                    return bl2;
                }
                boolean bl3 = false;
                return bl3;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K k2, int n2, V v2, boolean bl2) {
            this.lock();
            try {
                Object k3;
                InternalEntry internalEntry;
                this.preWriteCleanup();
                int n3 = this.count + 1;
                if (n3 > this.threshold) {
                    this.expand();
                    n3 = this.count + 1;
                }
                AtomicReferenceArray atomicReferenceArray = this.table;
                int n4 = n2 & atomicReferenceArray.length() - 1;
                InternalEntry internalEntry2 = (InternalEntry)atomicReferenceArray.get(n4);
                for (internalEntry = internalEntry2; internalEntry != null; internalEntry = internalEntry.getNext()) {
                    k3 = internalEntry.getKey();
                    if (internalEntry.getHash() != n2 || k3 == null || !this.map.keyEquivalence.equivalent(k2, k3)) continue;
                    Object v3 = internalEntry.getValue();
                    if (v3 == null) {
                        ++this.modCount;
                        this.setValue(internalEntry, v2);
                        this.count = n3 = this.count;
                        V v4 = null;
                        return v4;
                    }
                    if (bl2) {
                        Object v5 = v3;
                        return v5;
                    }
                    ++this.modCount;
                    this.setValue(internalEntry, v2);
                    Object v6 = v3;
                    return v6;
                }
                ++this.modCount;
                internalEntry = this.map.entryHelper.newEntry(this.self(), k2, n2, internalEntry2);
                this.setValue(internalEntry, v2);
                atomicReferenceArray.set(n4, internalEntry);
                this.count = n3;
                k3 = null;
                return (V)k3;
            }
            finally {
                this.unlock();
            }
        }

        void expand() {
            AtomicReferenceArray<E> atomicReferenceArray = this.table;
            int n2 = atomicReferenceArray.length();
            if (n2 >= 0x40000000) {
                return;
            }
            int n3 = this.count;
            AtomicReferenceArray<InternalEntry> atomicReferenceArray2 = this.newEntryArray(n2 << 1);
            this.threshold = atomicReferenceArray2.length() * 3 / 4;
            int n4 = atomicReferenceArray2.length() - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n5;
                Object object;
                InternalEntry internalEntry = (InternalEntry)atomicReferenceArray.get(i2);
                if (internalEntry == null) continue;
                Object e2 = internalEntry.getNext();
                int n6 = internalEntry.getHash() & n4;
                if (e2 == null) {
                    atomicReferenceArray2.set(n6, internalEntry);
                    continue;
                }
                Object object2 = internalEntry;
                int n7 = n6;
                for (object = e2; object != null; object = object.getNext()) {
                    n5 = object.getHash() & n4;
                    if (n5 == n7) continue;
                    n7 = n5;
                    object2 = object;
                }
                atomicReferenceArray2.set(n7, (InternalEntry)object2);
                for (object = internalEntry; object != object2; object = object.getNext()) {
                    n5 = object.getHash() & n4;
                    InternalEntry internalEntry2 = (InternalEntry)atomicReferenceArray2.get(n5);
                    InternalEntry internalEntry3 = this.copyEntry(object, internalEntry2);
                    if (internalEntry3 != null) {
                        atomicReferenceArray2.set(n5, internalEntry3);
                        continue;
                    }
                    --n3;
                }
            }
            this.table = atomicReferenceArray2;
            this.count = n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K k2, int n2, V v2, V v3) {
            this.lock();
            try {
                this.preWriteCleanup();
                AtomicReferenceArray atomicReferenceArray = this.table;
                int n3 = n2 & atomicReferenceArray.length() - 1;
                InternalEntry internalEntry = (InternalEntry)atomicReferenceArray.get(n3);
                for (InternalEntry internalEntry2 = internalEntry; internalEntry2 != null; internalEntry2 = internalEntry2.getNext()) {
                    Object k3 = internalEntry2.getKey();
                    if (internalEntry2.getHash() != n2 || k3 == null || !this.map.keyEquivalence.equivalent(k2, k3)) continue;
                    Object v4 = internalEntry2.getValue();
                    if (v4 == null) {
                        int n4;
                        if (Segment.isCollected(internalEntry2)) {
                            n4 = this.count - 1;
                            ++this.modCount;
                            InternalEntry internalEntry3 = this.removeFromChain(internalEntry, internalEntry2);
                            n4 = this.count - 1;
                            atomicReferenceArray.set(n3, internalEntry3);
                            this.count = n4;
                        }
                        n4 = 0;
                        return n4 != 0;
                    }
                    if (this.map.valueEquivalence().equivalent(v2, v4)) {
                        ++this.modCount;
                        this.setValue(internalEntry2, v3);
                        boolean bl2 = true;
                        return bl2;
                    }
                    boolean bl3 = false;
                    return bl3;
                }
                boolean bl4 = false;
                return bl4;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(K k2, int n2, V v2) {
            this.lock();
            try {
                InternalEntry internalEntry;
                this.preWriteCleanup();
                AtomicReferenceArray atomicReferenceArray = this.table;
                int n3 = n2 & atomicReferenceArray.length() - 1;
                InternalEntry internalEntry2 = (InternalEntry)atomicReferenceArray.get(n3);
                for (internalEntry = internalEntry2; internalEntry != null; internalEntry = internalEntry.getNext()) {
                    Object k3 = internalEntry.getKey();
                    if (internalEntry.getHash() != n2 || k3 == null || !this.map.keyEquivalence.equivalent(k2, k3)) continue;
                    Object v3 = internalEntry.getValue();
                    if (v3 == null) {
                        if (Segment.isCollected(internalEntry)) {
                            int n4 = this.count - 1;
                            ++this.modCount;
                            InternalEntry internalEntry3 = this.removeFromChain(internalEntry2, internalEntry);
                            n4 = this.count - 1;
                            atomicReferenceArray.set(n3, internalEntry3);
                            this.count = n4;
                        }
                        V v4 = null;
                        return v4;
                    }
                    ++this.modCount;
                    this.setValue(internalEntry, v2);
                    Object v5 = v3;
                    return v5;
                }
                internalEntry = null;
                return (V)internalEntry;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object object, int n2) {
            this.lock();
            try {
                InternalEntry internalEntry;
                this.preWriteCleanup();
                int n3 = this.count - 1;
                AtomicReferenceArray atomicReferenceArray = this.table;
                int n4 = n2 & atomicReferenceArray.length() - 1;
                InternalEntry internalEntry2 = (InternalEntry)atomicReferenceArray.get(n4);
                for (internalEntry = internalEntry2; internalEntry != null; internalEntry = internalEntry.getNext()) {
                    Object k2 = internalEntry.getKey();
                    if (internalEntry.getHash() != n2 || k2 == null || !this.map.keyEquivalence.equivalent(object, k2)) continue;
                    Object v2 = internalEntry.getValue();
                    if (v2 == null && !Segment.isCollected(internalEntry)) {
                        V v3 = null;
                        return v3;
                    }
                    ++this.modCount;
                    InternalEntry internalEntry3 = this.removeFromChain(internalEntry2, internalEntry);
                    n3 = this.count - 1;
                    atomicReferenceArray.set(n4, internalEntry3);
                    this.count = n3;
                    Object v4 = v2;
                    return v4;
                }
                internalEntry = null;
                return (V)internalEntry;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean remove(Object object, int n2, Object object2) {
            this.lock();
            try {
                this.preWriteCleanup();
                int n3 = this.count - 1;
                AtomicReferenceArray atomicReferenceArray = this.table;
                int n4 = n2 & atomicReferenceArray.length() - 1;
                InternalEntry internalEntry = (InternalEntry)atomicReferenceArray.get(n4);
                for (InternalEntry internalEntry2 = internalEntry; internalEntry2 != null; internalEntry2 = internalEntry2.getNext()) {
                    Object k2 = internalEntry2.getKey();
                    if (internalEntry2.getHash() != n2 || k2 == null || !this.map.keyEquivalence.equivalent(object, k2)) continue;
                    Object v2 = internalEntry2.getValue();
                    boolean bl2 = false;
                    if (this.map.valueEquivalence().equivalent(object2, v2)) {
                        bl2 = true;
                    } else if (!Segment.isCollected(internalEntry2)) {
                        boolean bl3 = false;
                        return bl3;
                    }
                    ++this.modCount;
                    InternalEntry internalEntry3 = this.removeFromChain(internalEntry, internalEntry2);
                    n3 = this.count - 1;
                    atomicReferenceArray.set(n4, internalEntry3);
                    this.count = n3;
                    boolean bl4 = bl2;
                    return bl4;
                }
                boolean bl5 = false;
                return bl5;
            }
            finally {
                this.unlock();
            }
        }

        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    AtomicReferenceArray<E> atomicReferenceArray = this.table;
                    for (int i2 = 0; i2 < atomicReferenceArray.length(); ++i2) {
                        atomicReferenceArray.set(i2, null);
                    }
                    this.maybeClearReferenceQueues();
                    this.readCount.set(0);
                    ++this.modCount;
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }

        E removeFromChain(E e2, E e3) {
            int n2 = this.count;
            Object e4 = e3.getNext();
            for (E e5 = e2; e5 != e3; e5 = e5.getNext()) {
                E e6 = this.copyEntry(e5, e4);
                if (e6 != null) {
                    e4 = e6;
                    continue;
                }
                --n2;
            }
            this.count = n2;
            return e4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean reclaimKey(E e2, int n2) {
            this.lock();
            try {
                InternalEntry internalEntry;
                int n3 = this.count - 1;
                AtomicReferenceArray<InternalEntry> atomicReferenceArray = this.table;
                int n4 = n2 & atomicReferenceArray.length() - 1;
                for (InternalEntry internalEntry2 = internalEntry = (InternalEntry)atomicReferenceArray.get(n4); internalEntry2 != null; internalEntry2 = internalEntry2.getNext()) {
                    if (internalEntry2 != e2) continue;
                    ++this.modCount;
                    InternalEntry internalEntry3 = this.removeFromChain(internalEntry, internalEntry2);
                    n3 = this.count - 1;
                    atomicReferenceArray.set(n4, internalEntry3);
                    this.count = n3;
                    boolean bl2 = true;
                    return bl2;
                }
                boolean bl3 = false;
                return bl3;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean reclaimValue(K k2, int n2, WeakValueReference<K, V, E> weakValueReference) {
            this.lock();
            try {
                InternalEntry internalEntry;
                int n3 = this.count - 1;
                AtomicReferenceArray<InternalEntry> atomicReferenceArray = this.table;
                int n4 = n2 & atomicReferenceArray.length() - 1;
                for (InternalEntry internalEntry2 = internalEntry = (InternalEntry)atomicReferenceArray.get(n4); internalEntry2 != null; internalEntry2 = internalEntry2.getNext()) {
                    Object k3 = internalEntry2.getKey();
                    if (internalEntry2.getHash() != n2 || k3 == null || !this.map.keyEquivalence.equivalent(k2, k3)) continue;
                    WeakValueReference weakValueReference2 = ((WeakValueEntry)internalEntry2).getValueReference();
                    if (weakValueReference2 == weakValueReference) {
                        ++this.modCount;
                        InternalEntry internalEntry3 = this.removeFromChain(internalEntry, internalEntry2);
                        n3 = this.count - 1;
                        atomicReferenceArray.set(n4, internalEntry3);
                        this.count = n3;
                        boolean bl2 = true;
                        return bl2;
                    }
                    boolean bl3 = false;
                    return bl3;
                }
                boolean bl4 = false;
                return bl4;
            }
            finally {
                this.unlock();
            }
        }

        static <K, V, E extends InternalEntry<K, V, E>> boolean isCollected(E e2) {
            return e2.getValue() == null;
        }

        V getLiveValue(E e2) {
            if (e2.getKey() == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            Object v2 = e2.getValue();
            if (v2 == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            return v2;
        }

        void postReadCleanup() {
            if ((this.readCount.incrementAndGet() & 0x3F) == 0) {
                this.runCleanup();
            }
        }

        void preWriteCleanup() {
            this.runLockedCleanup();
        }

        void runCleanup() {
            this.runLockedCleanup();
        }

        void runLockedCleanup() {
            if (this.tryLock()) {
                try {
                    this.maybeDrainReferenceQueues();
                    this.readCount.set(0);
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    static final class WeakValueReferenceImpl<K, V, E extends InternalEntry<K, V, E>>
    extends WeakReference<V>
    implements WeakValueReference<K, V, E> {
        @Weak
        final E entry;

        WeakValueReferenceImpl(ReferenceQueue<V> referenceQueue, V v2, E e2) {
            super(v2, referenceQueue);
            this.entry = e2;
        }

        @Override
        public E getEntry() {
            return this.entry;
        }

        @Override
        public WeakValueReference<K, V, E> copyFor(ReferenceQueue<V> referenceQueue, E e2) {
            return new WeakValueReferenceImpl<K, V, E>(referenceQueue, this.get(), e2);
        }
    }

    static final class DummyInternalEntry
    implements InternalEntry<Object, Object, DummyInternalEntry> {
        private DummyInternalEntry() {
            throw new AssertionError();
        }

        @Override
        public DummyInternalEntry getNext() {
            throw new AssertionError();
        }

        @Override
        public int getHash() {
            throw new AssertionError();
        }

        @Override
        public Object getKey() {
            throw new AssertionError();
        }

        @Override
        public Object getValue() {
            throw new AssertionError();
        }
    }

    static interface WeakValueReference<K, V, E extends InternalEntry<K, V, E>> {
        public V get();

        public E getEntry();

        public void clear();

        public WeakValueReference<K, V, E> copyFor(ReferenceQueue<V> var1, E var2);
    }

    static class WeakKeyWeakValueEntry<K, V>
    extends AbstractWeakKeyEntry<K, V, WeakKeyWeakValueEntry<K, V>>
    implements WeakValueEntry<K, V, WeakKeyWeakValueEntry<K, V>> {
        private volatile WeakValueReference<K, V, WeakKeyWeakValueEntry<K, V>> valueReference = MapMakerInternalMap.unsetWeakValueReference();

        WeakKeyWeakValueEntry(ReferenceQueue<K> referenceQueue, K k2, int n2) {
            super(referenceQueue, k2, n2);
        }

        @Override
        public final V getValue() {
            return this.valueReference.get();
        }

        @Override
        public final WeakValueReference<K, V, WeakKeyWeakValueEntry<K, V>> getValueReference() {
            return this.valueReference;
        }

        static final class Helper<K, V>
        implements InternalEntryHelper<K, V, WeakKeyWeakValueEntry<K, V>, WeakKeyWeakValueSegment<K, V>> {
            private static final Helper<?, ?> INSTANCE = new Helper();

            Helper() {
            }

            static <K, V> Helper<K, V> instance() {
                return INSTANCE;
            }

            @Override
            public Strength valueStrength() {
                return Strength.WEAK;
            }

            @Override
            public WeakKeyWeakValueSegment<K, V> newSegment(MapMakerInternalMap<K, V, WeakKeyWeakValueEntry<K, V>, WeakKeyWeakValueSegment<K, V>> mapMakerInternalMap, int n2) {
                return new WeakKeyWeakValueSegment<K, V>(mapMakerInternalMap, n2);
            }

            @Override
            public WeakKeyWeakValueEntry<K, V> copy(WeakKeyWeakValueSegment<K, V> weakKeyWeakValueSegment, WeakKeyWeakValueEntry<K, V> weakKeyWeakValueEntry, WeakKeyWeakValueEntry<K, V> weakKeyWeakValueEntry2) {
                Object k2 = weakKeyWeakValueEntry.getKey();
                if (k2 == null) {
                    return null;
                }
                if (Segment.isCollected(weakKeyWeakValueEntry)) {
                    return null;
                }
                WeakKeyWeakValueEntry<K, V> weakKeyWeakValueEntry3 = this.newEntry(weakKeyWeakValueSegment, k2, weakKeyWeakValueEntry.hash, weakKeyWeakValueEntry2);
                ((WeakKeyWeakValueEntry)weakKeyWeakValueEntry3).valueReference = ((WeakKeyWeakValueEntry)weakKeyWeakValueEntry).valueReference.copyFor(((WeakKeyWeakValueSegment)weakKeyWeakValueSegment).queueForValues, weakKeyWeakValueEntry3);
                return weakKeyWeakValueEntry3;
            }

            @Override
            public void setValue(WeakKeyWeakValueSegment<K, V> weakKeyWeakValueSegment, WeakKeyWeakValueEntry<K, V> weakKeyWeakValueEntry, V v2) {
                WeakValueReference weakValueReference = ((WeakKeyWeakValueEntry)weakKeyWeakValueEntry).valueReference;
                ((WeakKeyWeakValueEntry)weakKeyWeakValueEntry).valueReference = new WeakValueReferenceImpl(((WeakKeyWeakValueSegment)weakKeyWeakValueSegment).queueForValues, v2, weakKeyWeakValueEntry);
                weakValueReference.clear();
            }

            @Override
            public WeakKeyWeakValueEntry<K, V> newEntry(WeakKeyWeakValueSegment<K, V> weakKeyWeakValueSegment, K k2, int n2, WeakKeyWeakValueEntry<K, V> weakKeyWeakValueEntry) {
                return weakKeyWeakValueEntry == null ? new WeakKeyWeakValueEntry(((WeakKeyWeakValueSegment)weakKeyWeakValueSegment).queueForKeys, k2, n2) : new LinkedWeakKeyWeakValueEntry<K, V>(((WeakKeyWeakValueSegment)weakKeyWeakValueSegment).queueForKeys, k2, n2, weakKeyWeakValueEntry);
            }
        }

        private static final class LinkedWeakKeyWeakValueEntry<K, V>
        extends WeakKeyWeakValueEntry<K, V> {
            private final WeakKeyWeakValueEntry<K, V> next;

            LinkedWeakKeyWeakValueEntry(ReferenceQueue<K> referenceQueue, K k2, int n2, WeakKeyWeakValueEntry<K, V> weakKeyWeakValueEntry) {
                super(referenceQueue, k2, n2);
                this.next = weakKeyWeakValueEntry;
            }

            @Override
            public WeakKeyWeakValueEntry<K, V> getNext() {
                return this.next;
            }
        }
    }

    static class WeakKeyStrongValueEntry<K, V>
    extends AbstractWeakKeyEntry<K, V, WeakKeyStrongValueEntry<K, V>>
    implements MapMakerInternalMap$StrongValueEntry<K, V, WeakKeyStrongValueEntry<K, V>> {
        private volatile V value = null;

        private WeakKeyStrongValueEntry(ReferenceQueue<K> referenceQueue, K k2, int n2) {
            super(referenceQueue, k2, n2);
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        static final class Helper<K, V>
        implements InternalEntryHelper<K, V, WeakKeyStrongValueEntry<K, V>, WeakKeyStrongValueSegment<K, V>> {
            private static final Helper<?, ?> INSTANCE = new Helper();

            Helper() {
            }

            static <K, V> Helper<K, V> instance() {
                return INSTANCE;
            }

            @Override
            public Strength valueStrength() {
                return Strength.STRONG;
            }

            @Override
            public WeakKeyStrongValueSegment<K, V> newSegment(MapMakerInternalMap<K, V, WeakKeyStrongValueEntry<K, V>, WeakKeyStrongValueSegment<K, V>> mapMakerInternalMap, int n2) {
                return new WeakKeyStrongValueSegment<K, V>(mapMakerInternalMap, n2);
            }

            @Override
            public WeakKeyStrongValueEntry<K, V> copy(WeakKeyStrongValueSegment<K, V> weakKeyStrongValueSegment, WeakKeyStrongValueEntry<K, V> weakKeyStrongValueEntry, WeakKeyStrongValueEntry<K, V> weakKeyStrongValueEntry2) {
                Object k2 = weakKeyStrongValueEntry.getKey();
                if (k2 == null) {
                    return null;
                }
                WeakKeyStrongValueEntry<K, V> weakKeyStrongValueEntry3 = this.newEntry(weakKeyStrongValueSegment, k2, weakKeyStrongValueEntry.hash, weakKeyStrongValueEntry2);
                ((WeakKeyStrongValueEntry)weakKeyStrongValueEntry3).value = ((WeakKeyStrongValueEntry)weakKeyStrongValueEntry).value;
                return weakKeyStrongValueEntry3;
            }

            @Override
            public void setValue(WeakKeyStrongValueSegment<K, V> weakKeyStrongValueSegment, WeakKeyStrongValueEntry<K, V> weakKeyStrongValueEntry, V v2) {
                ((WeakKeyStrongValueEntry)weakKeyStrongValueEntry).value = v2;
            }

            @Override
            public WeakKeyStrongValueEntry<K, V> newEntry(WeakKeyStrongValueSegment<K, V> weakKeyStrongValueSegment, K k2, int n2, WeakKeyStrongValueEntry<K, V> weakKeyStrongValueEntry) {
                return weakKeyStrongValueEntry == null ? new WeakKeyStrongValueEntry(((WeakKeyStrongValueSegment)weakKeyStrongValueSegment).queueForKeys, k2, n2) : new LinkedWeakKeyStrongValueEntry(((WeakKeyStrongValueSegment)weakKeyStrongValueSegment).queueForKeys, k2, n2, weakKeyStrongValueEntry);
            }
        }

        private static final class LinkedWeakKeyStrongValueEntry<K, V>
        extends WeakKeyStrongValueEntry<K, V> {
            private final WeakKeyStrongValueEntry<K, V> next;

            private LinkedWeakKeyStrongValueEntry(ReferenceQueue<K> referenceQueue, K k2, int n2, WeakKeyStrongValueEntry<K, V> weakKeyStrongValueEntry) {
                super(referenceQueue, k2, n2);
                this.next = weakKeyStrongValueEntry;
            }

            @Override
            public WeakKeyStrongValueEntry<K, V> getNext() {
                return this.next;
            }
        }
    }

    static class WeakKeyDummyValueEntry<K>
    extends AbstractWeakKeyEntry<K, MapMaker.Dummy, WeakKeyDummyValueEntry<K>>
    implements MapMakerInternalMap$StrongValueEntry<K, MapMaker.Dummy, WeakKeyDummyValueEntry<K>> {
        private WeakKeyDummyValueEntry(ReferenceQueue<K> referenceQueue, K k2, int n2) {
            super(referenceQueue, k2, n2);
        }

        public final MapMaker.Dummy getValue() {
            return MapMaker.Dummy.VALUE;
        }

        static final class Helper<K>
        implements InternalEntryHelper<K, MapMaker.Dummy, WeakKeyDummyValueEntry<K>, WeakKeyDummyValueSegment<K>> {
            private static final Helper<?> INSTANCE = new Helper();

            Helper() {
            }

            static <K> Helper<K> instance() {
                return INSTANCE;
            }

            @Override
            public Strength valueStrength() {
                return Strength.STRONG;
            }

            @Override
            public WeakKeyDummyValueSegment<K> newSegment(MapMakerInternalMap<K, MapMaker.Dummy, WeakKeyDummyValueEntry<K>, WeakKeyDummyValueSegment<K>> mapMakerInternalMap, int n2) {
                return new WeakKeyDummyValueSegment<K>(mapMakerInternalMap, n2);
            }

            @Override
            public WeakKeyDummyValueEntry<K> copy(WeakKeyDummyValueSegment<K> weakKeyDummyValueSegment, WeakKeyDummyValueEntry<K> weakKeyDummyValueEntry, WeakKeyDummyValueEntry<K> weakKeyDummyValueEntry2) {
                Object k2 = weakKeyDummyValueEntry.getKey();
                if (k2 == null) {
                    return null;
                }
                return this.newEntry(weakKeyDummyValueSegment, k2, weakKeyDummyValueEntry.hash, weakKeyDummyValueEntry2);
            }

            @Override
            public void setValue(WeakKeyDummyValueSegment<K> weakKeyDummyValueSegment, WeakKeyDummyValueEntry<K> weakKeyDummyValueEntry, MapMaker.Dummy dummy) {
            }

            @Override
            public WeakKeyDummyValueEntry<K> newEntry(WeakKeyDummyValueSegment<K> weakKeyDummyValueSegment, K k2, int n2, WeakKeyDummyValueEntry<K> weakKeyDummyValueEntry) {
                return weakKeyDummyValueEntry == null ? new WeakKeyDummyValueEntry(((WeakKeyDummyValueSegment)weakKeyDummyValueSegment).queueForKeys, k2, n2) : new LinkedWeakKeyDummyValueEntry(((WeakKeyDummyValueSegment)weakKeyDummyValueSegment).queueForKeys, k2, n2, weakKeyDummyValueEntry);
            }
        }

        private static final class LinkedWeakKeyDummyValueEntry<K>
        extends WeakKeyDummyValueEntry<K> {
            private final WeakKeyDummyValueEntry<K> next;

            private LinkedWeakKeyDummyValueEntry(ReferenceQueue<K> referenceQueue, K k2, int n2, WeakKeyDummyValueEntry<K> weakKeyDummyValueEntry) {
                super(referenceQueue, k2, n2);
                this.next = weakKeyDummyValueEntry;
            }

            @Override
            public WeakKeyDummyValueEntry<K> getNext() {
                return this.next;
            }
        }
    }

    static abstract class AbstractWeakKeyEntry<K, V, E extends InternalEntry<K, V, E>>
    extends WeakReference<K>
    implements InternalEntry<K, V, E> {
        final int hash;

        AbstractWeakKeyEntry(ReferenceQueue<K> referenceQueue, K k2, int n2) {
            super(k2, referenceQueue);
            this.hash = n2;
        }

        @Override
        public final K getKey() {
            return (K)this.get();
        }

        @Override
        public final int getHash() {
            return this.hash;
        }

        @Override
        public E getNext() {
            return null;
        }
    }

    static class StrongKeyDummyValueEntry<K>
    extends AbstractStrongKeyEntry<K, MapMaker.Dummy, StrongKeyDummyValueEntry<K>>
    implements MapMakerInternalMap$StrongValueEntry<K, MapMaker.Dummy, StrongKeyDummyValueEntry<K>> {
        private StrongKeyDummyValueEntry(K k2, int n2) {
            super(k2, n2);
        }

        public final MapMaker.Dummy getValue() {
            return MapMaker.Dummy.VALUE;
        }

        static final class Helper<K>
        implements InternalEntryHelper<K, MapMaker.Dummy, StrongKeyDummyValueEntry<K>, StrongKeyDummyValueSegment<K>> {
            private static final Helper<?> INSTANCE = new Helper();

            Helper() {
            }

            static <K> Helper<K> instance() {
                return INSTANCE;
            }

            @Override
            public Strength valueStrength() {
                return Strength.STRONG;
            }

            @Override
            public StrongKeyDummyValueSegment<K> newSegment(MapMakerInternalMap<K, MapMaker.Dummy, StrongKeyDummyValueEntry<K>, StrongKeyDummyValueSegment<K>> mapMakerInternalMap, int n2) {
                return new StrongKeyDummyValueSegment<K>(mapMakerInternalMap, n2);
            }

            @Override
            public StrongKeyDummyValueEntry<K> copy(StrongKeyDummyValueSegment<K> strongKeyDummyValueSegment, StrongKeyDummyValueEntry<K> strongKeyDummyValueEntry, StrongKeyDummyValueEntry<K> strongKeyDummyValueEntry2) {
                return this.newEntry(strongKeyDummyValueSegment, strongKeyDummyValueEntry.key, strongKeyDummyValueEntry.hash, strongKeyDummyValueEntry2);
            }

            @Override
            public void setValue(StrongKeyDummyValueSegment<K> strongKeyDummyValueSegment, StrongKeyDummyValueEntry<K> strongKeyDummyValueEntry, MapMaker.Dummy dummy) {
            }

            @Override
            public StrongKeyDummyValueEntry<K> newEntry(StrongKeyDummyValueSegment<K> strongKeyDummyValueSegment, K k2, int n2, StrongKeyDummyValueEntry<K> strongKeyDummyValueEntry) {
                return strongKeyDummyValueEntry == null ? new StrongKeyDummyValueEntry(k2, n2) : new LinkedStrongKeyDummyValueEntry<K>(k2, n2, strongKeyDummyValueEntry);
            }
        }

        private static final class LinkedStrongKeyDummyValueEntry<K>
        extends StrongKeyDummyValueEntry<K> {
            private final StrongKeyDummyValueEntry<K> next;

            LinkedStrongKeyDummyValueEntry(K k2, int n2, StrongKeyDummyValueEntry<K> strongKeyDummyValueEntry) {
                super(k2, n2);
                this.next = strongKeyDummyValueEntry;
            }

            @Override
            public StrongKeyDummyValueEntry<K> getNext() {
                return this.next;
            }
        }
    }

    static class StrongKeyWeakValueEntry<K, V>
    extends AbstractStrongKeyEntry<K, V, StrongKeyWeakValueEntry<K, V>>
    implements WeakValueEntry<K, V, StrongKeyWeakValueEntry<K, V>> {
        private volatile WeakValueReference<K, V, StrongKeyWeakValueEntry<K, V>> valueReference = MapMakerInternalMap.unsetWeakValueReference();

        private StrongKeyWeakValueEntry(K k2, int n2) {
            super(k2, n2);
        }

        @Override
        public final V getValue() {
            return this.valueReference.get();
        }

        @Override
        public final WeakValueReference<K, V, StrongKeyWeakValueEntry<K, V>> getValueReference() {
            return this.valueReference;
        }

        static final class Helper<K, V>
        implements InternalEntryHelper<K, V, StrongKeyWeakValueEntry<K, V>, StrongKeyWeakValueSegment<K, V>> {
            private static final Helper<?, ?> INSTANCE = new Helper();

            Helper() {
            }

            static <K, V> Helper<K, V> instance() {
                return INSTANCE;
            }

            @Override
            public Strength valueStrength() {
                return Strength.WEAK;
            }

            @Override
            public StrongKeyWeakValueSegment<K, V> newSegment(MapMakerInternalMap<K, V, StrongKeyWeakValueEntry<K, V>, StrongKeyWeakValueSegment<K, V>> mapMakerInternalMap, int n2) {
                return new StrongKeyWeakValueSegment<K, V>(mapMakerInternalMap, n2);
            }

            @Override
            public StrongKeyWeakValueEntry<K, V> copy(StrongKeyWeakValueSegment<K, V> strongKeyWeakValueSegment, StrongKeyWeakValueEntry<K, V> strongKeyWeakValueEntry, StrongKeyWeakValueEntry<K, V> strongKeyWeakValueEntry2) {
                if (Segment.isCollected(strongKeyWeakValueEntry)) {
                    return null;
                }
                StrongKeyWeakValueEntry<Object, V> strongKeyWeakValueEntry3 = this.newEntry(strongKeyWeakValueSegment, strongKeyWeakValueEntry.key, strongKeyWeakValueEntry.hash, strongKeyWeakValueEntry2);
                ((StrongKeyWeakValueEntry)strongKeyWeakValueEntry3).valueReference = ((StrongKeyWeakValueEntry)strongKeyWeakValueEntry).valueReference.copyFor(((StrongKeyWeakValueSegment)strongKeyWeakValueSegment).queueForValues, strongKeyWeakValueEntry3);
                return strongKeyWeakValueEntry3;
            }

            @Override
            public void setValue(StrongKeyWeakValueSegment<K, V> strongKeyWeakValueSegment, StrongKeyWeakValueEntry<K, V> strongKeyWeakValueEntry, V v2) {
                WeakValueReference weakValueReference = ((StrongKeyWeakValueEntry)strongKeyWeakValueEntry).valueReference;
                ((StrongKeyWeakValueEntry)strongKeyWeakValueEntry).valueReference = new WeakValueReferenceImpl(((StrongKeyWeakValueSegment)strongKeyWeakValueSegment).queueForValues, v2, strongKeyWeakValueEntry);
                weakValueReference.clear();
            }

            @Override
            public StrongKeyWeakValueEntry<K, V> newEntry(StrongKeyWeakValueSegment<K, V> strongKeyWeakValueSegment, K k2, int n2, StrongKeyWeakValueEntry<K, V> strongKeyWeakValueEntry) {
                return strongKeyWeakValueEntry == null ? new StrongKeyWeakValueEntry(k2, n2) : new LinkedStrongKeyWeakValueEntry<K, V>(k2, n2, strongKeyWeakValueEntry);
            }
        }

        private static final class LinkedStrongKeyWeakValueEntry<K, V>
        extends StrongKeyWeakValueEntry<K, V> {
            private final StrongKeyWeakValueEntry<K, V> next;

            LinkedStrongKeyWeakValueEntry(K k2, int n2, StrongKeyWeakValueEntry<K, V> strongKeyWeakValueEntry) {
                super(k2, n2);
                this.next = strongKeyWeakValueEntry;
            }

            @Override
            public StrongKeyWeakValueEntry<K, V> getNext() {
                return this.next;
            }
        }
    }

    static class StrongKeyStrongValueEntry<K, V>
    extends AbstractStrongKeyEntry<K, V, StrongKeyStrongValueEntry<K, V>>
    implements MapMakerInternalMap$StrongValueEntry<K, V, StrongKeyStrongValueEntry<K, V>> {
        private volatile V value = null;

        private StrongKeyStrongValueEntry(K k2, int n2) {
            super(k2, n2);
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        static final class Helper<K, V>
        implements InternalEntryHelper<K, V, StrongKeyStrongValueEntry<K, V>, StrongKeyStrongValueSegment<K, V>> {
            private static final Helper<?, ?> INSTANCE = new Helper();

            Helper() {
            }

            static <K, V> Helper<K, V> instance() {
                return INSTANCE;
            }

            @Override
            public Strength valueStrength() {
                return Strength.STRONG;
            }

            @Override
            public StrongKeyStrongValueSegment<K, V> newSegment(MapMakerInternalMap<K, V, StrongKeyStrongValueEntry<K, V>, StrongKeyStrongValueSegment<K, V>> mapMakerInternalMap, int n2) {
                return new StrongKeyStrongValueSegment<K, V>(mapMakerInternalMap, n2);
            }

            @Override
            public StrongKeyStrongValueEntry<K, V> copy(StrongKeyStrongValueSegment<K, V> strongKeyStrongValueSegment, StrongKeyStrongValueEntry<K, V> strongKeyStrongValueEntry, StrongKeyStrongValueEntry<K, V> strongKeyStrongValueEntry2) {
                StrongKeyStrongValueEntry<Object, V> strongKeyStrongValueEntry3 = this.newEntry(strongKeyStrongValueSegment, strongKeyStrongValueEntry.key, strongKeyStrongValueEntry.hash, strongKeyStrongValueEntry2);
                ((StrongKeyStrongValueEntry)strongKeyStrongValueEntry3).value = ((StrongKeyStrongValueEntry)strongKeyStrongValueEntry).value;
                return strongKeyStrongValueEntry3;
            }

            @Override
            public void setValue(StrongKeyStrongValueSegment<K, V> strongKeyStrongValueSegment, StrongKeyStrongValueEntry<K, V> strongKeyStrongValueEntry, V v2) {
                ((StrongKeyStrongValueEntry)strongKeyStrongValueEntry).value = v2;
            }

            @Override
            public StrongKeyStrongValueEntry<K, V> newEntry(StrongKeyStrongValueSegment<K, V> strongKeyStrongValueSegment, K k2, int n2, StrongKeyStrongValueEntry<K, V> strongKeyStrongValueEntry) {
                return strongKeyStrongValueEntry == null ? new StrongKeyStrongValueEntry(k2, n2) : new LinkedStrongKeyStrongValueEntry<K, V>(k2, n2, strongKeyStrongValueEntry);
            }
        }

        private static final class LinkedStrongKeyStrongValueEntry<K, V>
        extends StrongKeyStrongValueEntry<K, V> {
            private final StrongKeyStrongValueEntry<K, V> next;

            LinkedStrongKeyStrongValueEntry(K k2, int n2, StrongKeyStrongValueEntry<K, V> strongKeyStrongValueEntry) {
                super(k2, n2);
                this.next = strongKeyStrongValueEntry;
            }

            @Override
            public StrongKeyStrongValueEntry<K, V> getNext() {
                return this.next;
            }
        }
    }

    static interface WeakValueEntry<K, V, E extends InternalEntry<K, V, E>>
    extends InternalEntry<K, V, E> {
        public WeakValueReference<K, V, E> getValueReference();
    }

    static abstract class AbstractStrongKeyEntry<K, V, E extends InternalEntry<K, V, E>>
    implements InternalEntry<K, V, E> {
        final K key;
        final int hash;

        AbstractStrongKeyEntry(K k2, int n2) {
            this.key = k2;
            this.hash = n2;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final int getHash() {
            return this.hash;
        }

        @Override
        public E getNext() {
            return null;
        }
    }

    static interface InternalEntry<K, V, E extends InternalEntry<K, V, E>> {
        public E getNext();

        public int getHash();

        public K getKey();

        public V getValue();
    }

    static interface InternalEntryHelper<K, V, E extends InternalEntry<K, V, E>, S extends Segment<K, V, E, S>> {
        public Strength valueStrength();

        public S newSegment(MapMakerInternalMap<K, V, E, S> var1, int var2);

        public E newEntry(S var1, K var2, int var3, E var4);

        public E copy(S var1, E var2, E var3);

        public void setValue(S var1, E var2, V var3);
    }

    static enum Strength {
        STRONG{

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalence.equals();
            }
        }
        ,
        WEAK{

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalence.identity();
            }
        };


        abstract Equivalence<Object> defaultEquivalence();
    }
}

