/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter;

import com.gradle.maven.extension.internal.dep.org.apache.commons.io.IOCase;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.filefilter.AbstractFileFilter;
import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import java.util.stream.Stream;

public class SuffixFileFilter
extends AbstractFileFilter
implements Serializable {
    private final String[] suffixes;
    private final IOCase ioCase;

    public SuffixFileFilter(String string) {
        this(string, IOCase.SENSITIVE);
    }

    public SuffixFileFilter(String string, IOCase iOCase) {
        Objects.requireNonNull(string, "suffix");
        this.suffixes = new String[]{string};
        this.ioCase = IOCase.value(iOCase, IOCase.SENSITIVE);
    }

    @Override
    public boolean accept(File file) {
        return this.accept(file.getName());
    }

    @Override
    public boolean accept(File file, String string) {
        return this.accept(string);
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        return this.toFileVisitResult(this.accept(Objects.toString(path.getFileName(), null)));
    }

    private boolean accept(String string) {
        return Stream.of(this.suffixes).anyMatch(string2 -> this.ioCase.checkEndsWith(string, (String)string2));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        this.append(this.suffixes, stringBuilder);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

