/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.asm;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.ByteVector;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.ClassReader;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.ClassWriter;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.ConstantDynamic;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.Handle;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.Symbol;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.Type;

final class SymbolTable {
    final ClassWriter classWriter;
    private final ClassReader sourceClassReader;
    private int majorVersion;
    private String className;
    private int entryCount;
    private Entry[] entries;
    private int constantPoolCount;
    private ByteVector constantPool;
    private int bootstrapMethodCount;
    private ByteVector bootstrapMethods;
    private int typeCount;
    private Entry[] typeTable;

    SymbolTable(ClassWriter classWriter) {
        this.classWriter = classWriter;
        this.sourceClassReader = null;
        this.entries = new Entry[256];
        this.constantPoolCount = 1;
        this.constantPool = new ByteVector();
    }

    SymbolTable(ClassWriter classWriter, ClassReader classReader) {
        byte by2;
        this.classWriter = classWriter;
        this.sourceClassReader = classReader;
        byte[] byArray = classReader.classFileBuffer;
        int n2 = classReader.getItem(1) - 1;
        int n3 = classReader.header - n2;
        this.constantPoolCount = classReader.getItemCount();
        this.constantPool = new ByteVector(n3);
        this.constantPool.putByteArray(byArray, n2, n3);
        this.entries = new Entry[this.constantPoolCount * 2];
        char[] cArray = new char[classReader.getMaxStringLength()];
        boolean bl2 = false;
        block10: for (int i2 = 1; i2 < this.constantPoolCount; i2 += by2 == 5 || by2 == 6 ? 2 : 1) {
            int n4 = classReader.getItem(i2);
            by2 = byArray[n4 - 1];
            switch (by2) {
                case 9: 
                case 10: 
                case 11: {
                    int n5 = classReader.getItem(classReader.readUnsignedShort(n4 + 2));
                    this.addConstantMemberReference(i2, by2, classReader.readClass(n4, cArray), classReader.readUTF8(n5, cArray), classReader.readUTF8(n5 + 2, cArray));
                    continue block10;
                }
                case 3: 
                case 4: {
                    this.addConstantIntegerOrFloat(i2, by2, classReader.readInt(n4));
                    continue block10;
                }
                case 12: {
                    this.addConstantNameAndType(i2, classReader.readUTF8(n4, cArray), classReader.readUTF8(n4 + 2, cArray));
                    continue block10;
                }
                case 5: 
                case 6: {
                    this.addConstantLongOrDouble(i2, by2, classReader.readLong(n4));
                    continue block10;
                }
                case 1: {
                    this.addConstantUtf8(i2, classReader.readUtf(i2, cArray));
                    continue block10;
                }
                case 15: {
                    int n6 = classReader.getItem(classReader.readUnsignedShort(n4 + 1));
                    int n5 = classReader.getItem(classReader.readUnsignedShort(n6 + 2));
                    this.addConstantMethodHandle(i2, classReader.readByte(n4), classReader.readClass(n6, cArray), classReader.readUTF8(n5, cArray), classReader.readUTF8(n5 + 2, cArray));
                    continue block10;
                }
                case 17: 
                case 18: {
                    bl2 = true;
                    int n5 = classReader.getItem(classReader.readUnsignedShort(n4 + 2));
                    this.addConstantDynamicOrInvokeDynamicReference(by2, i2, classReader.readUTF8(n5, cArray), classReader.readUTF8(n5 + 2, cArray), classReader.readUnsignedShort(n4));
                    continue block10;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    this.addConstantUtf8Reference(i2, by2, classReader.readUTF8(n4, cArray));
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        if (bl2) {
            this.copyBootstrapMethods(classReader, cArray);
        }
    }

    private void copyBootstrapMethods(ClassReader classReader, char[] cArray) {
        int n2;
        byte[] byArray = classReader.classFileBuffer;
        int n3 = classReader.getFirstAttributeOffset();
        for (n2 = classReader.readUnsignedShort(n3 - 2); n2 > 0; --n2) {
            String string = classReader.readUTF8(n3, cArray);
            if ("BootstrapMethods".equals(string)) {
                this.bootstrapMethodCount = classReader.readUnsignedShort(n3 + 6);
                break;
            }
            n3 += 6 + classReader.readInt(n3 + 2);
        }
        if (this.bootstrapMethodCount > 0) {
            n2 = n3 + 8;
            int n4 = classReader.readInt(n3 + 2) - 2;
            this.bootstrapMethods = new ByteVector(n4);
            this.bootstrapMethods.putByteArray(byArray, n2, n4);
            int n5 = n2;
            for (int i2 = 0; i2 < this.bootstrapMethodCount; ++i2) {
                int n6 = n5 - n2;
                int n7 = classReader.readUnsignedShort(n5);
                int n8 = classReader.readUnsignedShort(n5 += 2);
                n5 += 2;
                int n9 = classReader.readConst(n7, cArray).hashCode();
                while (n8-- > 0) {
                    int n10 = classReader.readUnsignedShort(n5);
                    n5 += 2;
                    n9 ^= classReader.readConst(n10, cArray).hashCode();
                }
                this.add(new Entry(i2, 64, n6, n9 & Integer.MAX_VALUE));
            }
        }
    }

    ClassReader getSource() {
        return this.sourceClassReader;
    }

    int getMajorVersion() {
        return this.majorVersion;
    }

    String getClassName() {
        return this.className;
    }

    int setMajorVersionAndClassName(int n2, String string) {
        this.majorVersion = n2;
        this.className = string;
        return this.addConstantClass((String)string).index;
    }

    int getConstantPoolCount() {
        return this.constantPoolCount;
    }

    int getConstantPoolLength() {
        return this.constantPool.length;
    }

    void putConstantPool(ByteVector byteVector) {
        byteVector.putShort(this.constantPoolCount).putByteArray(this.constantPool.data, 0, this.constantPool.length);
    }

    int computeBootstrapMethodsSize() {
        if (this.bootstrapMethods != null) {
            this.addConstantUtf8("BootstrapMethods");
            return 8 + this.bootstrapMethods.length;
        }
        return 0;
    }

    void putBootstrapMethods(ByteVector byteVector) {
        if (this.bootstrapMethods != null) {
            byteVector.putShort(this.addConstantUtf8("BootstrapMethods")).putInt(this.bootstrapMethods.length + 2).putShort(this.bootstrapMethodCount).putByteArray(this.bootstrapMethods.data, 0, this.bootstrapMethods.length);
        }
    }

    private Entry get(int n2) {
        return this.entries[n2 % this.entries.length];
    }

    private Entry put(Entry entry) {
        int n2;
        if (this.entryCount > this.entries.length * 3 / 4) {
            n2 = this.entries.length;
            int n3 = n2 * 2 + 1;
            Entry[] entryArray = new Entry[n3];
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                Entry entry2 = this.entries[i2];
                while (entry2 != null) {
                    int n4 = entry2.hashCode % n3;
                    Entry entry3 = entry2.next;
                    entry2.next = entryArray[n4];
                    entryArray[n4] = entry2;
                    entry2 = entry3;
                }
            }
            this.entries = entryArray;
        }
        ++this.entryCount;
        n2 = entry.hashCode % this.entries.length;
        entry.next = this.entries[n2];
        this.entries[n2] = entry;
        return this.entries[n2];
    }

    private void add(Entry entry) {
        ++this.entryCount;
        int n2 = entry.hashCode % this.entries.length;
        entry.next = this.entries[n2];
        this.entries[n2] = entry;
    }

    Symbol addConstant(Object object) {
        if (object instanceof Integer) {
            return this.addConstantInteger((Integer)object);
        }
        if (object instanceof Byte) {
            return this.addConstantInteger(((Byte)object).intValue());
        }
        if (object instanceof Character) {
            return this.addConstantInteger(((Character)object).charValue());
        }
        if (object instanceof Short) {
            return this.addConstantInteger(((Short)object).intValue());
        }
        if (object instanceof Boolean) {
            return this.addConstantInteger((Boolean)object != false ? 1 : 0);
        }
        if (object instanceof Float) {
            return this.addConstantFloat(((Float)object).floatValue());
        }
        if (object instanceof Long) {
            return this.addConstantLong((Long)object);
        }
        if (object instanceof Double) {
            return this.addConstantDouble((Double)object);
        }
        if (object instanceof String) {
            return this.addConstantString((String)object);
        }
        if (object instanceof Type) {
            Type type = (Type)object;
            int n2 = type.getSort();
            if (n2 == 10) {
                return this.addConstantClass(type.getInternalName());
            }
            if (n2 == 11) {
                return this.addConstantMethodType(type.getDescriptor());
            }
            return this.addConstantClass(type.getDescriptor());
        }
        if (object instanceof Handle) {
            Handle handle = (Handle)object;
            return this.addConstantMethodHandle(handle.getTag(), handle.getOwner(), handle.getName(), handle.getDesc(), handle.isInterface());
        }
        if (object instanceof ConstantDynamic) {
            ConstantDynamic constantDynamic = (ConstantDynamic)object;
            return this.addConstantDynamic(constantDynamic.getName(), constantDynamic.getDescriptor(), constantDynamic.getBootstrapMethod(), constantDynamic.getBootstrapMethodArgumentsUnsafe());
        }
        throw new IllegalArgumentException("value " + object);
    }

    Symbol addConstantClass(String string) {
        return this.addConstantUtf8Reference(7, string);
    }

    Symbol addConstantFieldref(String string, String string2, String string3) {
        return this.addConstantMemberReference(9, string, string2, string3);
    }

    Symbol addConstantMethodref(String string, String string2, String string3, boolean bl2) {
        int n2 = bl2 ? 11 : 10;
        return this.addConstantMemberReference(n2, string, string2, string3);
    }

    private Entry addConstantMemberReference(int n2, String string, String string2, String string3) {
        int n3 = SymbolTable.hash(n2, string, string2, string3);
        Entry entry = this.get(n3);
        while (entry != null) {
            if (entry.tag == n2 && entry.hashCode == n3 && entry.owner.equals(string) && entry.name.equals(string2) && entry.value.equals(string3)) {
                return entry;
            }
            entry = entry.next;
        }
        this.constantPool.put122(n2, this.addConstantClass((String)string).index, this.addConstantNameAndType(string2, string3));
        return this.put(new Entry(this.constantPoolCount++, n2, string, string2, string3, 0L, n3));
    }

    private void addConstantMemberReference(int n2, int n3, String string, String string2, String string3) {
        this.add(new Entry(n2, n3, string, string2, string3, 0L, SymbolTable.hash(n3, string, string2, string3)));
    }

    Symbol addConstantString(String string) {
        return this.addConstantUtf8Reference(8, string);
    }

    Symbol addConstantInteger(int n2) {
        return this.addConstantIntegerOrFloat(3, n2);
    }

    Symbol addConstantFloat(float f2) {
        return this.addConstantIntegerOrFloat(4, Float.floatToRawIntBits(f2));
    }

    private Symbol addConstantIntegerOrFloat(int n2, int n3) {
        int n4 = SymbolTable.hash(n2, n3);
        Entry entry = this.get(n4);
        while (entry != null) {
            if (entry.tag == n2 && entry.hashCode == n4 && entry.data == (long)n3) {
                return entry;
            }
            entry = entry.next;
        }
        this.constantPool.putByte(n2).putInt(n3);
        return this.put(new Entry(this.constantPoolCount++, n2, n3, n4));
    }

    private void addConstantIntegerOrFloat(int n2, int n3, int n4) {
        this.add(new Entry(n2, n3, n4, SymbolTable.hash(n3, n4)));
    }

    Symbol addConstantLong(long l2) {
        return this.addConstantLongOrDouble(5, l2);
    }

    Symbol addConstantDouble(double d2) {
        return this.addConstantLongOrDouble(6, Double.doubleToRawLongBits(d2));
    }

    private Symbol addConstantLongOrDouble(int n2, long l2) {
        int n3 = SymbolTable.hash(n2, l2);
        Entry entry = this.get(n3);
        while (entry != null) {
            if (entry.tag == n2 && entry.hashCode == n3 && entry.data == l2) {
                return entry;
            }
            entry = entry.next;
        }
        int n4 = this.constantPoolCount;
        this.constantPool.putByte(n2).putLong(l2);
        this.constantPoolCount += 2;
        return this.put(new Entry(n4, n2, l2, n3));
    }

    private void addConstantLongOrDouble(int n2, int n3, long l2) {
        this.add(new Entry(n2, n3, l2, SymbolTable.hash(n3, l2)));
    }

    int addConstantNameAndType(String string, String string2) {
        int n2 = 12;
        int n3 = SymbolTable.hash(12, string, string2);
        Entry entry = this.get(n3);
        while (entry != null) {
            if (entry.tag == 12 && entry.hashCode == n3 && entry.name.equals(string) && entry.value.equals(string2)) {
                return entry.index;
            }
            entry = entry.next;
        }
        this.constantPool.put122(12, this.addConstantUtf8(string), this.addConstantUtf8(string2));
        return this.put((Entry)new Entry((int)this.constantPoolCount++, (int)12, (String)string, (String)string2, (int)n3)).index;
    }

    private void addConstantNameAndType(int n2, String string, String string2) {
        int n3 = 12;
        this.add(new Entry(n2, 12, string, string2, SymbolTable.hash(12, string, string2)));
    }

    int addConstantUtf8(String string) {
        int n2 = SymbolTable.hash(1, string);
        Entry entry = this.get(n2);
        while (entry != null) {
            if (entry.tag == 1 && entry.hashCode == n2 && entry.value.equals(string)) {
                return entry.index;
            }
            entry = entry.next;
        }
        this.constantPool.putByte(1).putUTF8(string);
        return this.put((Entry)new Entry((int)this.constantPoolCount++, (int)1, (String)string, (int)n2)).index;
    }

    private void addConstantUtf8(int n2, String string) {
        this.add(new Entry(n2, 1, string, SymbolTable.hash(1, string)));
    }

    Symbol addConstantMethodHandle(int n2, String string, String string2, String string3, boolean bl2) {
        int n3 = 15;
        int n4 = SymbolTable.hash(15, string, string2, string3, n2);
        Entry entry = this.get(n4);
        while (entry != null) {
            if (entry.tag == 15 && entry.hashCode == n4 && entry.data == (long)n2 && entry.owner.equals(string) && entry.name.equals(string2) && entry.value.equals(string3)) {
                return entry;
            }
            entry = entry.next;
        }
        if (n2 <= 4) {
            this.constantPool.put112(15, n2, this.addConstantFieldref((String)string, (String)string2, (String)string3).index);
        } else {
            this.constantPool.put112(15, n2, this.addConstantMethodref((String)string, (String)string2, (String)string3, (boolean)bl2).index);
        }
        return this.put(new Entry(this.constantPoolCount++, 15, string, string2, string3, n2, n4));
    }

    private void addConstantMethodHandle(int n2, int n3, String string, String string2, String string3) {
        int n4 = 15;
        int n5 = SymbolTable.hash(15, string, string2, string3, n3);
        this.add(new Entry(n2, 15, string, string2, string3, n3, n5));
    }

    Symbol addConstantMethodType(String string) {
        return this.addConstantUtf8Reference(16, string);
    }

    Symbol addConstantDynamic(String string, String string2, Handle handle, Object ... objectArray) {
        Symbol symbol = this.addBootstrapMethod(handle, objectArray);
        return this.addConstantDynamicOrInvokeDynamicReference(17, string, string2, symbol.index);
    }

    Symbol addConstantInvokeDynamic(String string, String string2, Handle handle, Object ... objectArray) {
        Symbol symbol = this.addBootstrapMethod(handle, objectArray);
        return this.addConstantDynamicOrInvokeDynamicReference(18, string, string2, symbol.index);
    }

    private Symbol addConstantDynamicOrInvokeDynamicReference(int n2, String string, String string2, int n3) {
        int n4 = SymbolTable.hash(n2, string, string2, n3);
        Entry entry = this.get(n4);
        while (entry != null) {
            if (entry.tag == n2 && entry.hashCode == n4 && entry.data == (long)n3 && entry.name.equals(string) && entry.value.equals(string2)) {
                return entry;
            }
            entry = entry.next;
        }
        this.constantPool.put122(n2, n3, this.addConstantNameAndType(string, string2));
        return this.put(new Entry(this.constantPoolCount++, n2, null, string, string2, n3, n4));
    }

    private void addConstantDynamicOrInvokeDynamicReference(int n2, int n3, String string, String string2, int n4) {
        int n5 = SymbolTable.hash(n2, string, string2, n4);
        this.add(new Entry(n3, n2, null, string, string2, n4, n5));
    }

    Symbol addConstantModule(String string) {
        return this.addConstantUtf8Reference(19, string);
    }

    Symbol addConstantPackage(String string) {
        return this.addConstantUtf8Reference(20, string);
    }

    private Symbol addConstantUtf8Reference(int n2, String string) {
        int n3 = SymbolTable.hash(n2, string);
        Entry entry = this.get(n3);
        while (entry != null) {
            if (entry.tag == n2 && entry.hashCode == n3 && entry.value.equals(string)) {
                return entry;
            }
            entry = entry.next;
        }
        this.constantPool.put12(n2, this.addConstantUtf8(string));
        return this.put(new Entry(this.constantPoolCount++, n2, string, n3));
    }

    private void addConstantUtf8Reference(int n2, int n3, String string) {
        this.add(new Entry(n2, n3, string, SymbolTable.hash(n3, string)));
    }

    Symbol addBootstrapMethod(Handle handle, Object ... objectArray) {
        int n2;
        int n3;
        ByteVector byteVector = this.bootstrapMethods;
        if (byteVector == null) {
            byteVector = this.bootstrapMethods = new ByteVector();
        }
        int n4 = objectArray.length;
        int[] nArray = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = this.addConstant((Object)objectArray[n3]).index;
        }
        n3 = byteVector.length;
        byteVector.putShort(this.addConstantMethodHandle((int)handle.getTag(), (String)handle.getOwner(), (String)handle.getName(), (String)handle.getDesc(), (boolean)handle.isInterface()).index);
        byteVector.putShort(n4);
        for (n2 = 0; n2 < n4; ++n2) {
            byteVector.putShort(nArray[n2]);
        }
        n2 = byteVector.length - n3;
        int n5 = handle.hashCode();
        for (Object object : objectArray) {
            n5 ^= object.hashCode();
        }
        return this.addBootstrapMethod(n3, n2, n5 &= Integer.MAX_VALUE);
    }

    private Symbol addBootstrapMethod(int n2, int n3, int n4) {
        byte[] byArray = this.bootstrapMethods.data;
        Entry entry = this.get(n4);
        while (entry != null) {
            if (entry.tag == 64 && entry.hashCode == n4) {
                int n5 = (int)entry.data;
                boolean bl2 = true;
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (byArray[n2 + i2] == byArray[n5 + i2]) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    this.bootstrapMethods.length = n2;
                    return entry;
                }
            }
            entry = entry.next;
        }
        return this.put(new Entry(this.bootstrapMethodCount++, 64, n2, n4));
    }

    Symbol getType(int n2) {
        return this.typeTable[n2];
    }

    int addType(String string) {
        int n2 = SymbolTable.hash(128, string);
        Entry entry = this.get(n2);
        while (entry != null) {
            if (entry.tag == 128 && entry.hashCode == n2 && entry.value.equals(string)) {
                return entry.index;
            }
            entry = entry.next;
        }
        return this.addTypeInternal(new Entry(this.typeCount, 128, string, n2));
    }

    int addUninitializedType(String string, int n2) {
        int n3 = SymbolTable.hash(129, string, n2);
        Entry entry = this.get(n3);
        while (entry != null) {
            if (entry.tag == 129 && entry.hashCode == n3 && entry.data == (long)n2 && entry.value.equals(string)) {
                return entry.index;
            }
            entry = entry.next;
        }
        return this.addTypeInternal(new Entry(this.typeCount, 129, string, n2, n3));
    }

    int addMergedType(int n2, int n3) {
        int n4;
        long l2 = n2 < n3 ? (long)n2 | (long)n3 << 32 : (long)n3 | (long)n2 << 32;
        int n5 = SymbolTable.hash(130, n2 + n3);
        Entry entry = this.get(n5);
        while (entry != null) {
            if (entry.tag == 130 && entry.hashCode == n5 && entry.data == l2) {
                return entry.info;
            }
            entry = entry.next;
        }
        String string = this.typeTable[n2].value;
        String string2 = this.typeTable[n3].value;
        this.put((Entry)new Entry((int)this.typeCount, (int)130, (long)l2, (int)n5)).info = n4 = this.addType(this.classWriter.getCommonSuperClass(string, string2));
        return n4;
    }

    private int addTypeInternal(Entry entry) {
        if (this.typeTable == null) {
            this.typeTable = new Entry[16];
        }
        if (this.typeCount == this.typeTable.length) {
            Entry[] entryArray = new Entry[2 * this.typeTable.length];
            System.arraycopy(this.typeTable, 0, entryArray, 0, this.typeTable.length);
            this.typeTable = entryArray;
        }
        this.typeTable[this.typeCount++] = entry;
        return this.put((Entry)entry).index;
    }

    private static int hash(int n2, int n3) {
        return Integer.MAX_VALUE & n2 + n3;
    }

    private static int hash(int n2, long l2) {
        return Integer.MAX_VALUE & n2 + (int)l2 + (int)(l2 >>> 32);
    }

    private static int hash(int n2, String string) {
        return Integer.MAX_VALUE & n2 + string.hashCode();
    }

    private static int hash(int n2, String string, int n3) {
        return Integer.MAX_VALUE & n2 + string.hashCode() + n3;
    }

    private static int hash(int n2, String string, String string2) {
        return Integer.MAX_VALUE & n2 + string.hashCode() * string2.hashCode();
    }

    private static int hash(int n2, String string, String string2, int n3) {
        return Integer.MAX_VALUE & n2 + string.hashCode() * string2.hashCode() * (n3 + 1);
    }

    private static int hash(int n2, String string, String string2, String string3) {
        return Integer.MAX_VALUE & n2 + string.hashCode() * string2.hashCode() * string3.hashCode();
    }

    private static int hash(int n2, String string, String string2, String string3, int n3) {
        return Integer.MAX_VALUE & n2 + string.hashCode() * string2.hashCode() * string3.hashCode() * n3;
    }

    private static class Entry
    extends Symbol {
        final int hashCode;
        Entry next;

        Entry(int n2, int n3, String string, String string2, String string3, long l2, int n4) {
            super(n2, n3, string, string2, string3, l2);
            this.hashCode = n4;
        }

        Entry(int n2, int n3, String string, int n4) {
            super(n2, n3, null, null, string, 0L);
            this.hashCode = n4;
        }

        Entry(int n2, int n3, String string, long l2, int n4) {
            super(n2, n3, null, null, string, l2);
            this.hashCode = n4;
        }

        Entry(int n2, int n3, String string, String string2, int n4) {
            super(n2, n3, null, string, string2, 0L);
            this.hashCode = n4;
        }

        Entry(int n2, int n3, long l2, int n4) {
            super(n2, n3, null, null, null, l2);
            this.hashCode = n4;
        }
    }
}

