/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert;

import com.gradle.maven.extension.internal.dep.org.springframework.core.MethodParameter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.ResolvableType;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.Property;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ObjectUtils;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class TypeDescriptor
implements Serializable {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private static final Map<Class<?>, TypeDescriptor> commonTypesCache = new HashMap(32);
    private static final Class<?>[] CACHED_COMMON_TYPES;
    private final Class<?> type;
    private final ResolvableType resolvableType;
    private final AnnotatedElementAdapter annotatedElement;

    public TypeDescriptor(MethodParameter methodParameter) {
        this.resolvableType = ResolvableType.forMethodParameter(methodParameter);
        this.type = this.resolvableType.resolve(methodParameter.getNestedParameterType());
        this.annotatedElement = new AnnotatedElementAdapter(methodParameter.getParameterIndex() == -1 ? methodParameter.getMethodAnnotations() : methodParameter.getParameterAnnotations());
    }

    public TypeDescriptor(Field field) {
        this.resolvableType = ResolvableType.forField(field);
        this.type = this.resolvableType.resolve(field.getType());
        this.annotatedElement = new AnnotatedElementAdapter(field.getAnnotations());
    }

    public TypeDescriptor(Property property) {
        Assert.notNull((Object)property, "Property must not be null");
        this.resolvableType = ResolvableType.forMethodParameter(property.getMethodParameter());
        this.type = this.resolvableType.resolve(property.getType());
        this.annotatedElement = new AnnotatedElementAdapter(property.getAnnotations());
    }

    public TypeDescriptor(ResolvableType resolvableType, Class<?> clazz, Annotation[] annotationArray) {
        this.resolvableType = resolvableType;
        this.type = clazz != null ? clazz : resolvableType.toClass();
        this.annotatedElement = new AnnotatedElementAdapter(annotationArray);
    }

    public Class<?> getObjectType() {
        return ClassUtils.resolvePrimitiveIfNecessary(this.getType());
    }

    public Class<?> getType() {
        return this.type;
    }

    public ResolvableType getResolvableType() {
        return this.resolvableType;
    }

    public TypeDescriptor narrow(Object object) {
        if (object == null) {
            return this;
        }
        ResolvableType resolvableType = ResolvableType.forType(object.getClass(), this.getResolvableType());
        return new TypeDescriptor(resolvableType, object.getClass(), this.getAnnotations());
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public Annotation[] getAnnotations() {
        return this.annotatedElement.getAnnotations();
    }

    public boolean isAssignableTo(TypeDescriptor typeDescriptor) {
        boolean bl2 = typeDescriptor.getObjectType().isAssignableFrom(this.getObjectType());
        if (!bl2) {
            return false;
        }
        if (this.isArray() && typeDescriptor.isArray()) {
            return this.isNestedAssignable(this.getElementTypeDescriptor(), typeDescriptor.getElementTypeDescriptor());
        }
        if (this.isCollection() && typeDescriptor.isCollection()) {
            return this.isNestedAssignable(this.getElementTypeDescriptor(), typeDescriptor.getElementTypeDescriptor());
        }
        if (this.isMap() && typeDescriptor.isMap()) {
            return this.isNestedAssignable(this.getMapKeyTypeDescriptor(), typeDescriptor.getMapKeyTypeDescriptor()) && this.isNestedAssignable(this.getMapValueTypeDescriptor(), typeDescriptor.getMapValueTypeDescriptor());
        }
        return true;
    }

    private boolean isNestedAssignable(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return typeDescriptor == null || typeDescriptor2 == null || typeDescriptor.isAssignableTo(typeDescriptor2);
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.getType());
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public TypeDescriptor getElementTypeDescriptor() {
        if (this.getResolvableType().isArray()) {
            return new TypeDescriptor(this.getResolvableType().getComponentType(), null, this.getAnnotations());
        }
        if (Stream.class.isAssignableFrom(this.getType())) {
            return TypeDescriptor.getRelatedIfResolvable(this, this.getResolvableType().as(Stream.class).getGeneric(0));
        }
        return TypeDescriptor.getRelatedIfResolvable(this, this.getResolvableType().asCollection().getGeneric(0));
    }

    public TypeDescriptor elementTypeDescriptor(Object object) {
        return this.narrow(object, this.getElementTypeDescriptor());
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    public TypeDescriptor getMapKeyTypeDescriptor() {
        Assert.state(this.isMap(), "Not a [java.util.Map]");
        return TypeDescriptor.getRelatedIfResolvable(this, this.getResolvableType().asMap().getGeneric(0));
    }

    public TypeDescriptor getMapKeyTypeDescriptor(Object object) {
        return this.narrow(object, this.getMapKeyTypeDescriptor());
    }

    public TypeDescriptor getMapValueTypeDescriptor() {
        Assert.state(this.isMap(), "Not a [java.util.Map]");
        return TypeDescriptor.getRelatedIfResolvable(this, this.getResolvableType().asMap().getGeneric(1));
    }

    public TypeDescriptor getMapValueTypeDescriptor(Object object) {
        return this.narrow(object, this.getMapValueTypeDescriptor());
    }

    private TypeDescriptor narrow(Object object, TypeDescriptor typeDescriptor) {
        if (typeDescriptor != null) {
            return typeDescriptor.narrow(object);
        }
        if (object != null) {
            return this.narrow(object);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TypeDescriptor)) {
            return false;
        }
        TypeDescriptor typeDescriptor = (TypeDescriptor)object;
        if (this.getType() != typeDescriptor.getType()) {
            return false;
        }
        if (!this.annotationsMatch(typeDescriptor)) {
            return false;
        }
        if (this.isCollection() || this.isArray()) {
            return ObjectUtils.nullSafeEquals(this.getElementTypeDescriptor(), typeDescriptor.getElementTypeDescriptor());
        }
        if (this.isMap()) {
            return ObjectUtils.nullSafeEquals(this.getMapKeyTypeDescriptor(), typeDescriptor.getMapKeyTypeDescriptor()) && ObjectUtils.nullSafeEquals(this.getMapValueTypeDescriptor(), typeDescriptor.getMapValueTypeDescriptor());
        }
        return true;
    }

    private boolean annotationsMatch(TypeDescriptor typeDescriptor) {
        Annotation[] annotationArray;
        Annotation[] annotationArray2 = this.getAnnotations();
        if (annotationArray2 == (annotationArray = typeDescriptor.getAnnotations())) {
            return true;
        }
        if (annotationArray2.length != annotationArray.length) {
            return false;
        }
        if (annotationArray2.length > 0) {
            for (int i2 = 0; i2 < annotationArray2.length; ++i2) {
                if (this.annotationEquals(annotationArray2[i2], annotationArray[i2])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean annotationEquals(Annotation annotation, Annotation annotation2) {
        return annotation == annotation2 || annotation.getClass() == annotation2.getClass() && annotation.equals(annotation2);
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Annotation annotation : this.getAnnotations()) {
            stringBuilder.append('@').append(annotation.annotationType().getName()).append(' ');
        }
        stringBuilder.append(this.getResolvableType());
        return stringBuilder.toString();
    }

    public static TypeDescriptor forObject(Object object) {
        return object != null ? TypeDescriptor.valueOf(object.getClass()) : null;
    }

    public static TypeDescriptor valueOf(Class<?> clazz) {
        TypeDescriptor typeDescriptor;
        if (clazz == null) {
            clazz = Object.class;
        }
        return (typeDescriptor = commonTypesCache.get(clazz)) != null ? typeDescriptor : new TypeDescriptor(ResolvableType.forClass(clazz), null, null);
    }

    public static TypeDescriptor collection(Class<?> clazz, TypeDescriptor typeDescriptor) {
        Assert.notNull(clazz, "Collection type must not be null");
        if (!Collection.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Collection type must be a [java.util.Collection]");
        }
        ResolvableType resolvableType = typeDescriptor != null ? typeDescriptor.resolvableType : null;
        return new TypeDescriptor(ResolvableType.forClassWithGenerics(clazz, resolvableType), null, null);
    }

    private static TypeDescriptor getRelatedIfResolvable(TypeDescriptor typeDescriptor, ResolvableType resolvableType) {
        if (resolvableType.resolve() == null) {
            return null;
        }
        return new TypeDescriptor(resolvableType, null, typeDescriptor.getAnnotations());
    }

    static {
        for (Class<?> clazz : CACHED_COMMON_TYPES = new Class[]{Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class, String.class, Object.class}) {
            commonTypesCache.put(clazz, TypeDescriptor.valueOf(clazz));
        }
    }

    private class AnnotatedElementAdapter
    implements Serializable,
    AnnotatedElement {
        private final Annotation[] annotations;

        public AnnotatedElementAdapter(Annotation[] annotationArray) {
            this.annotations = annotationArray;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
            for (Annotation annotation : this.getAnnotations()) {
                if (annotation.annotationType() != clazz) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            for (Annotation annotation : this.getAnnotations()) {
                if (annotation.annotationType() != clazz) continue;
                return (T)annotation;
            }
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.annotations != null ? (Annotation[])this.annotations.clone() : EMPTY_ANNOTATION_ARRAY;
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.getAnnotations();
        }

        public boolean equals(Object object) {
            return this == object || object instanceof AnnotatedElementAdapter && Arrays.equals(this.annotations, ((AnnotatedElementAdapter)object).annotations);
        }

        public int hashCode() {
            return Arrays.hashCode(this.annotations);
        }

        public String toString() {
            return TypeDescriptor.this.toString();
        }
    }
}

