/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.type.ResolvedType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.TypeBindings;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.TypeFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;

public abstract class JavaType
extends ResolvedType
implements Serializable,
Type {
    protected final Class<?> _class;
    protected final int _hash;
    protected final Object _valueHandler;
    protected final Object _typeHandler;
    protected final boolean _asStatic;

    protected JavaType(Class<?> clazz, int n2, Object object, Object object2, boolean bl2) {
        this._class = clazz;
        this._hash = 31 * n2 + clazz.hashCode();
        this._valueHandler = object;
        this._typeHandler = object2;
        this._asStatic = bl2;
    }

    protected JavaType(JavaType javaType) {
        this._class = javaType._class;
        this._hash = javaType._hash;
        this._valueHandler = javaType._valueHandler;
        this._typeHandler = javaType._typeHandler;
        this._asStatic = javaType._asStatic;
    }

    public abstract JavaType withContentType(JavaType var1);

    public abstract JavaType withStaticTyping();

    public abstract JavaType withTypeHandler(Object var1);

    public abstract JavaType withContentTypeHandler(Object var1);

    public abstract JavaType withValueHandler(Object var1);

    public abstract JavaType withContentValueHandler(Object var1);

    public JavaType withHandlersFrom(JavaType javaType) {
        JavaType javaType2 = this;
        Object t2 = javaType.getTypeHandler();
        if (t2 != this._typeHandler) {
            javaType2 = javaType2.withTypeHandler(t2);
        }
        if ((t2 = javaType.getValueHandler()) != this._valueHandler) {
            javaType2 = javaType2.withValueHandler(t2);
        }
        return javaType2;
    }

    public abstract JavaType refine(Class<?> var1, TypeBindings var2, JavaType var3, JavaType[] var4);

    public final Class<?> getRawClass() {
        return this._class;
    }

    public final boolean hasRawClass(Class<?> clazz) {
        return this._class == clazz;
    }

    public boolean hasContentType() {
        return true;
    }

    public final boolean isTypeOrSubTypeOf(Class<?> clazz) {
        return this._class == clazz || clazz.isAssignableFrom(this._class);
    }

    public final boolean isTypeOrSuperTypeOf(Class<?> clazz) {
        return this._class == clazz || this._class.isAssignableFrom(clazz);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this._class.getModifiers());
    }

    public boolean isConcrete() {
        int n2 = this._class.getModifiers();
        if ((n2 & 0x600) == 0) {
            return true;
        }
        return this._class.isPrimitive();
    }

    public boolean isThrowable() {
        return Throwable.class.isAssignableFrom(this._class);
    }

    public boolean isArrayType() {
        return false;
    }

    public final boolean isEnumType() {
        return ClassUtil.isEnumType(this._class);
    }

    public final boolean isEnumImplType() {
        return ClassUtil.isEnumType(this._class) && this._class != Enum.class;
    }

    public final boolean isRecordType() {
        return ClassUtil.isRecordType(this._class);
    }

    public final boolean isInterface() {
        return this._class.isInterface();
    }

    public final boolean isPrimitive() {
        return this._class.isPrimitive();
    }

    public final boolean isFinal() {
        return Modifier.isFinal(this._class.getModifiers());
    }

    public abstract boolean isContainerType();

    public boolean isCollectionLikeType() {
        return false;
    }

    public boolean isMapLikeType() {
        return false;
    }

    public final boolean isJavaLangObject() {
        return this._class == Object.class;
    }

    public final boolean useStaticType() {
        return this._asStatic;
    }

    public boolean hasGenericTypes() {
        return this.containedTypeCount() > 0;
    }

    public JavaType getKeyType() {
        return null;
    }

    public JavaType getContentType() {
        return null;
    }

    @Override
    public JavaType getReferencedType() {
        return null;
    }

    public abstract int containedTypeCount();

    public abstract JavaType containedType(int var1);

    public JavaType containedTypeOrUnknown(int n2) {
        JavaType javaType = this.containedType(n2);
        return javaType == null ? TypeFactory.unknownType() : javaType;
    }

    public abstract TypeBindings getBindings();

    public abstract JavaType findSuperType(Class<?> var1);

    public abstract JavaType getSuperClass();

    public abstract List<JavaType> getInterfaces();

    public <T> T getValueHandler() {
        return (T)this._valueHandler;
    }

    public <T> T getTypeHandler() {
        return (T)this._typeHandler;
    }

    public boolean hasHandlers() {
        return this._typeHandler != null || this._valueHandler != null;
    }

    public String getGenericSignature() {
        StringBuilder stringBuilder = new StringBuilder(40);
        this.getGenericSignature(stringBuilder);
        return stringBuilder.toString();
    }

    public abstract StringBuilder getGenericSignature(StringBuilder var1);

    public abstract StringBuilder getErasedSignature(StringBuilder var1);

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public int hashCode() {
        return this._hash;
    }
}

