/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonInclude;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class BeanUtil {
    public static Object getDefaultValue(JavaType javaType) {
        Class<?> clazz = javaType.getRawClass();
        Class<?> clazz2 = ClassUtil.primitiveType(clazz);
        if (clazz2 != null) {
            return ClassUtil.defaultValue(clazz2);
        }
        if (javaType.isContainerType() || javaType.isReferenceType()) {
            return JsonInclude.Include.NON_EMPTY;
        }
        if (clazz == String.class) {
            return "";
        }
        if (javaType.isTypeOrSubTypeOf(Date.class)) {
            return new Date(0L);
        }
        if (javaType.isTypeOrSubTypeOf(Calendar.class)) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(0L);
            return gregorianCalendar;
        }
        return null;
    }

    public static String checkUnsupportedType(JavaType javaType) {
        String string;
        String string2;
        String string3 = javaType.getRawClass().getName();
        if (BeanUtil.isJava8TimeClass(string3)) {
            if (string3.indexOf(46, 10) >= 0) {
                return null;
            }
            string2 = "Java 8 date/time";
            string = "com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype:jackson-datatype-jsr310";
        } else if (BeanUtil.isJodaTimeClass(string3)) {
            string2 = "Joda date/time";
            string = "com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype:jackson-datatype-joda";
        } else {
            return null;
        }
        return String.format("%s type %s not supported by default: add Module \"%s\" to enable handling", string2, ClassUtil.getTypeDescription(javaType), string);
    }

    private static boolean isJava8TimeClass(String string) {
        return string.startsWith("java.time.");
    }

    private static boolean isJodaTimeClass(String string) {
        return string.startsWith("org.joda.time.");
    }
}

