/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.EnumNamingStrategy;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.CompactStringObjectMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class EnumResolver
implements Serializable {
    protected final Class<Enum<?>> _enumClass;
    protected final Enum<?>[] _enums;
    protected final HashMap<String, Enum<?>> _enumsById;
    protected final Enum<?> _defaultValue;
    protected final boolean _isIgnoreCase;
    protected final boolean _isFromIntValue;

    protected EnumResolver(Class<Enum<?>> clazz, Enum<?>[] enumArray, HashMap<String, Enum<?>> hashMap, Enum<?> enum_, boolean bl2, boolean bl3) {
        this._enumClass = clazz;
        this._enums = enumArray;
        this._enumsById = hashMap;
        this._defaultValue = enum_;
        this._isIgnoreCase = bl2;
        this._isFromIntValue = bl3;
    }

    public static EnumResolver constructFor(DeserializationConfig deserializationConfig, Class<?> clazz) {
        return EnumResolver._constructFor(deserializationConfig, clazz);
    }

    protected static EnumResolver _constructFor(DeserializationConfig deserializationConfig, Class<?> clazz) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<Enum<?>> clazz2 = EnumResolver._enumClass(clazz);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz);
        String[] stringArray = annotationIntrospector.findEnumValues(clazz2, enumArray, new String[enumArray.length]);
        String[][] stringArray2 = new String[stringArray.length][];
        annotationIntrospector.findEnumAliases(clazz2, enumArray, stringArray2);
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum<?> enum_ = enumArray[i2];
            String string = stringArray[i2];
            if (string == null) {
                string = enum_.name();
            }
            hashMap.put(string, enum_);
            String[] stringArray3 = stringArray2[i2];
            if (stringArray3 == null) continue;
            for (String string2 : stringArray3) {
                hashMap.putIfAbsent(string2, enum_);
            }
        }
        return new EnumResolver(clazz2, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, clazz2), bl2, false);
    }

    public static EnumResolver constructUsingToString(DeserializationConfig deserializationConfig, Class<?> clazz) {
        return EnumResolver._constructUsingToString(deserializationConfig, clazz);
    }

    public static EnumResolver constructUsingIndex(DeserializationConfig deserializationConfig, Class<Enum<?>> clazz) {
        return EnumResolver._constructUsingIndex(deserializationConfig, clazz);
    }

    private static EnumResolver _constructUsingIndex(DeserializationConfig deserializationConfig, Class<Enum<?>> clazz) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<Enum<?>> clazz2 = EnumResolver._enumClass(clazz);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz);
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            hashMap.put(String.valueOf(n2), enum_);
        }
        return new EnumResolver(clazz2, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, clazz2), bl2, false);
    }

    public static EnumResolver constructUsingEnumNamingStrategy(DeserializationConfig deserializationConfig, Class<?> clazz, EnumNamingStrategy enumNamingStrategy) {
        return EnumResolver._constructUsingEnumNamingStrategy(deserializationConfig, clazz, enumNamingStrategy);
    }

    private static EnumResolver _constructUsingEnumNamingStrategy(DeserializationConfig deserializationConfig, Class<?> clazz, EnumNamingStrategy enumNamingStrategy) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<Enum<?>> clazz2 = EnumResolver._enumClass(clazz);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz);
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            String string = enumNamingStrategy.convertEnumToExternalName(enum_.name());
            hashMap.put(string, enum_);
        }
        return new EnumResolver(clazz2, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, clazz2), bl2, false);
    }

    protected static EnumResolver _constructUsingToString(DeserializationConfig deserializationConfig, Class<?> clazz) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<Enum<?>> clazz2 = EnumResolver._enumClass(clazz);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz);
        HashMap hashMap = new HashMap();
        String[][] stringArray = new String[enumArray.length][];
        if (annotationIntrospector != null) {
            annotationIntrospector.findEnumAliases(clazz2, enumArray, stringArray);
        }
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            hashMap.put(enum_.toString(), enum_);
            String[] stringArray2 = stringArray[n2];
            if (stringArray2 == null) continue;
            for (String string : stringArray2) {
                hashMap.putIfAbsent(string, enum_);
            }
        }
        return new EnumResolver(clazz2, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, clazz2), bl2, false);
    }

    public static EnumResolver constructUsingMethod(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedMember annotatedMember) {
        return EnumResolver._constructUsingMethod(deserializationConfig, clazz, annotatedMember);
    }

    protected static EnumResolver _constructUsingMethod(DeserializationConfig deserializationConfig, Class<?> clazz, AnnotatedMember annotatedMember) {
        AnnotationIntrospector annotationIntrospector = deserializationConfig.getAnnotationIntrospector();
        boolean bl2 = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS);
        Class<Enum<?>> clazz2 = EnumResolver._enumClass(clazz);
        Enum<?>[] enumArray = EnumResolver._enumConstants(clazz);
        HashMap hashMap = new HashMap();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum<?> enum_ = enumArray[n2];
            try {
                Object object = annotatedMember.getValue(enum_);
                if (object == null) continue;
                hashMap.put(object.toString(), enum_);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to access @JsonValue of Enum value " + enum_ + ": " + exception.getMessage());
            }
        }
        return new EnumResolver(clazz2, enumArray, hashMap, EnumResolver._enumDefault(annotationIntrospector, clazz2), bl2, EnumResolver._isIntType(annotatedMember.getRawType()));
    }

    public CompactStringObjectMap constructLookup() {
        return CompactStringObjectMap.construct(this._enumsById);
    }

    protected static Class<Enum<?>> _enumClass(Class<?> clazz) {
        return clazz;
    }

    protected static Enum<?>[] _enumConstants(Class<?> clazz) {
        Enum<?>[] enumArray = EnumResolver._enumClass(clazz).getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("No enum constants for class " + clazz.getName());
        }
        return enumArray;
    }

    protected static Enum<?> _enumDefault(AnnotationIntrospector annotationIntrospector, Class<?> clazz) {
        return annotationIntrospector != null ? annotationIntrospector.findDefaultEnumValue(EnumResolver._enumClass(clazz)) : null;
    }

    protected static boolean _isIntType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            clazz = ClassUtil.wrapperType(clazz);
        }
        return clazz == Long.class || clazz == Integer.class || clazz == Short.class || clazz == Byte.class;
    }

    public Enum<?> findEnum(String string) {
        Enum<?> enum_ = this._enumsById.get(string);
        if (enum_ == null && this._isIgnoreCase) {
            return this._findEnumCaseInsensitive(string);
        }
        return enum_;
    }

    protected Enum<?> _findEnumCaseInsensitive(String string) {
        for (Map.Entry<String, Enum<?>> entry : this._enumsById.entrySet()) {
            if (!string.equalsIgnoreCase(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public Enum<?> getDefaultValue() {
        return this._defaultValue;
    }

    public Enum<?>[] getRawEnums() {
        return this._enums;
    }

    public Collection<String> getEnumIds() {
        return this._enumsById.keySet();
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }

    public boolean isFromIntValue() {
        return this._isFromIntValue;
    }
}

