/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.dev.failsafe;

import com.gradle.maven.extension.internal.dep.dev.failsafe.FailurePolicyConfig;
import com.gradle.maven.extension.internal.dep.dev.failsafe.PolicyBuilder;
import com.gradle.maven.extension.internal.dep.dev.failsafe.function.CheckedBiPredicate;
import com.gradle.maven.extension.internal.dep.dev.failsafe.function.CheckedPredicate;
import com.gradle.maven.extension.internal.dep.dev.failsafe.internal.util.Assert;
import java.util.Arrays;
import java.util.List;

public abstract class FailurePolicyBuilder<S, C extends FailurePolicyConfig<R>, R>
extends PolicyBuilder<S, C, R> {
    protected FailurePolicyBuilder(C c2) {
        super(c2);
    }

    public S handle(Class<? extends Throwable> clazz) {
        Assert.notNull(clazz, "exception");
        return this.handle(Arrays.asList(clazz));
    }

    public S handle(List<Class<? extends Throwable>> list) {
        Assert.notNull(list, "exceptions");
        Assert.isTrue(!list.isEmpty(), "exceptions cannot be empty", new Object[0]);
        ((FailurePolicyConfig)this.config).exceptionsChecked = true;
        ((FailurePolicyConfig)this.config).failureConditions.add(FailurePolicyBuilder.failurePredicateFor(list));
        return (S)this;
    }

    public S handleIf(CheckedPredicate<? extends Throwable> checkedPredicate) {
        Assert.notNull(checkedPredicate, "failurePredicate");
        ((FailurePolicyConfig)this.config).exceptionsChecked = true;
        ((FailurePolicyConfig)this.config).failureConditions.add(FailurePolicyBuilder.failurePredicateFor(checkedPredicate));
        return (S)this;
    }

    public S handleResultIf(CheckedPredicate<R> checkedPredicate) {
        Assert.notNull(checkedPredicate, "resultPredicate");
        ((FailurePolicyConfig)this.config).failureConditions.add(FailurePolicyBuilder.resultPredicateFor(checkedPredicate));
        return (S)this;
    }

    static <R> CheckedBiPredicate<R, Throwable> failurePredicateFor(CheckedPredicate<? extends Throwable> checkedPredicate) {
        return (object, throwable) -> throwable != null && checkedPredicate.test((Throwable)throwable);
    }

    static <R> CheckedBiPredicate<R, Throwable> resultPredicateFor(CheckedPredicate<R> checkedPredicate) {
        return (object, throwable) -> {
            if (throwable == null) {
                return checkedPredicate.test(object);
            }
            return false;
        };
    }

    static <R> CheckedBiPredicate<R, Throwable> failurePredicateFor(List<Class<? extends Throwable>> list) {
        return (object, throwable) -> {
            if (throwable == null) {
                return false;
            }
            for (Class clazz : list) {
                if (!clazz.isAssignableFrom(throwable.getClass())) continue;
                return true;
            }
            return false;
        };
    }
}

