/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.Connection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.EndPoint;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ManagedSelector;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ProcessorUtils;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.Scheduler;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.ThreadPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.ThreadPoolBudget;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;

public abstract class SelectorManager
extends ContainerLifeCycle {
    protected static final Logger LOG = Log.getLogger(SelectorManager.class);
    private final Executor executor;
    private final Scheduler scheduler;
    private final ManagedSelector[] _selectors;
    private final AtomicInteger _selectorIndex = new AtomicInteger();
    private final IntUnaryOperator _selectorIndexUpdate;
    private final List<AcceptListener> _acceptListeners = new ArrayList<AcceptListener>();
    private long _connectTimeout = 15000L;
    private ThreadPoolBudget.Lease _lease;

    private static int defaultSelectors(Executor executor) {
        if (executor instanceof ThreadPool.SizedThreadPool) {
            int n2 = ((ThreadPool.SizedThreadPool)executor).getMaxThreads();
            int n3 = ProcessorUtils.availableProcessors();
            return Math.max(1, Math.min(n3 / 2, n2 / 16));
        }
        return Math.max(1, ProcessorUtils.availableProcessors() / 2);
    }

    protected SelectorManager(Executor executor, Scheduler scheduler, int n3) {
        if (n3 <= 0) {
            n3 = SelectorManager.defaultSelectors(executor);
        }
        this.executor = executor;
        this.scheduler = scheduler;
        this._selectors = new ManagedSelector[n3];
        this._selectorIndexUpdate = n2 -> (n2 + 1) % this._selectors.length;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public long getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(long l2) {
        this._connectTimeout = l2;
    }

    protected void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    private ManagedSelector chooseSelector() {
        return this._selectors[this._selectorIndex.updateAndGet(this._selectorIndexUpdate)];
    }

    public void connect(SelectableChannel selectableChannel, Object object) {
        ManagedSelector managedSelector;
        ManagedSelector managedSelector2 = managedSelector = this.chooseSelector();
        Objects.requireNonNull(managedSelector2);
        managedSelector.submit(managedSelector2.new ManagedSelector.Connect(selectableChannel, object));
    }

    public void accept(SelectableChannel selectableChannel, Object object) {
        ManagedSelector managedSelector;
        ManagedSelector managedSelector2 = managedSelector = this.chooseSelector();
        Objects.requireNonNull(managedSelector2);
        managedSelector.submit(managedSelector2.new ManagedSelector.Accept(selectableChannel, object));
    }

    @Override
    protected void doStart() throws Exception {
        this._lease = ThreadPoolBudget.leaseFrom(this.getExecutor(), this, this._selectors.length);
        for (int i2 = 0; i2 < this._selectors.length; ++i2) {
            ManagedSelector managedSelector;
            this._selectors[i2] = managedSelector = this.newSelector(i2);
            this.addBean(managedSelector);
        }
        super.doStart();
    }

    protected ManagedSelector newSelector(int n2) {
        return new ManagedSelector(this, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        try {
            super.doStop();
        }
        finally {
            for (ManagedSelector managedSelector : this._selectors) {
                if (managedSelector == null) continue;
                this.removeBean(managedSelector);
            }
            Arrays.fill(this._selectors, null);
            if (this._lease != null) {
                this._lease.close();
            }
        }
    }

    protected void endPointOpened(EndPoint endPoint) {
    }

    protected void endPointClosed(EndPoint endPoint) {
    }

    public void connectionOpened(Connection connection) {
        try {
            connection.onOpen();
        }
        catch (Throwable throwable) {
            if (this.isRunning()) {
                LOG.warn("Exception while notifying connection " + connection, throwable);
            } else {
                LOG.debug("Exception while notifying connection " + connection, throwable);
            }
            throw throwable;
        }
    }

    public void connectionClosed(Connection connection) {
        try {
            connection.onClose();
        }
        catch (Throwable throwable) {
            LOG.debug("Exception while notifying connection " + connection, throwable);
        }
    }

    protected boolean doFinishConnect(SelectableChannel selectableChannel) throws IOException {
        return ((SocketChannel)selectableChannel).finishConnect();
    }

    protected boolean isConnectionPending(SelectableChannel selectableChannel) {
        return ((SocketChannel)selectableChannel).isConnectionPending();
    }

    protected void connectionFailed(SelectableChannel selectableChannel, Throwable throwable, Object object) {
        LOG.warn(String.format("%s - %s", selectableChannel, object), throwable);
    }

    protected Selector newSelector() throws IOException {
        return Selector.open();
    }

    protected abstract EndPoint newEndPoint(SelectableChannel var1, ManagedSelector var2, SelectionKey var3) throws IOException;

    public abstract Connection newConnection(SelectableChannel var1, EndPoint var2, Object var3) throws IOException;

    protected void onAccepting(SelectableChannel selectableChannel) {
        for (AcceptListener acceptListener : this._acceptListeners) {
            try {
                acceptListener.onAccepting(selectableChannel);
            }
            catch (Throwable throwable) {
                LOG.warn(throwable);
            }
        }
    }

    protected void onAcceptFailed(SelectableChannel selectableChannel, Throwable throwable) {
        for (AcceptListener acceptListener : this._acceptListeners) {
            try {
                acceptListener.onAcceptFailed(selectableChannel, throwable);
            }
            catch (Throwable throwable2) {
                LOG.warn(throwable2);
            }
        }
    }

    protected void onAccepted(SelectableChannel selectableChannel) {
        for (AcceptListener acceptListener : this._acceptListeners) {
            try {
                acceptListener.onAccepted(selectableChannel);
            }
            catch (Throwable throwable) {
                LOG.warn(throwable);
            }
        }
    }

    public static interface AcceptListener
    extends EventListener {
        default public void onAccepting(SelectableChannel selectableChannel) {
        }

        default public void onAcceptFailed(SelectableChannel selectableChannel, Throwable throwable) {
        }

        default public void onAccepted(SelectableChannel selectableChannel) {
        }
    }
}

