/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.Label;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.NumberUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ObjectUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class Operator
extends SpelNodeImpl {
    private final String operatorName;
    protected String leftActualDescriptor;
    protected String rightActualDescriptor;

    public Operator(String string, int n2, int n3, SpelNodeImpl ... spelNodeImplArray) {
        super(n2, n3, spelNodeImplArray);
        this.operatorName = string;
    }

    public SpelNodeImpl getLeftOperand() {
        return this.children[0];
    }

    public SpelNodeImpl getRightOperand() {
        return this.children[1];
    }

    public final String getOperatorName() {
        return this.operatorName;
    }

    @Override
    public String toStringAST() {
        StringBuilder stringBuilder = new StringBuilder("(");
        stringBuilder.append(this.getChild(0).toStringAST());
        for (int i2 = 1; i2 < this.getChildCount(); ++i2) {
            stringBuilder.append(' ').append(this.getOperatorName()).append(' ');
            stringBuilder.append(this.getChild(i2).toStringAST());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    protected boolean isCompilableOperatorUsingNumerics() {
        SpelNodeImpl spelNodeImpl = this.getLeftOperand();
        SpelNodeImpl spelNodeImpl2 = this.getRightOperand();
        if (!spelNodeImpl.isCompilable() || !spelNodeImpl2.isCompilable()) {
            return false;
        }
        String string = spelNodeImpl.exitTypeDescriptor;
        String string2 = spelNodeImpl2.exitTypeDescriptor;
        DescriptorComparison descriptorComparison = DescriptorComparison.checkNumericCompatibility(string, string2, this.leftActualDescriptor, this.rightActualDescriptor);
        return descriptorComparison.areNumbers && descriptorComparison.areCompatible;
    }

    protected void generateComparisonCode(MethodVisitor methodVisitor, CodeFlow codeFlow, int n2, int n3) {
        SpelNodeImpl spelNodeImpl = this.getLeftOperand();
        SpelNodeImpl spelNodeImpl2 = this.getRightOperand();
        String string = spelNodeImpl.exitTypeDescriptor;
        String string2 = spelNodeImpl2.exitTypeDescriptor;
        Label label = new Label();
        Label label2 = new Label();
        boolean bl2 = !CodeFlow.isPrimitive(string);
        boolean bl3 = !CodeFlow.isPrimitive(string2);
        DescriptorComparison descriptorComparison = DescriptorComparison.checkNumericCompatibility(string, string2, this.leftActualDescriptor, this.rightActualDescriptor);
        char c2 = descriptorComparison.compatibleType;
        codeFlow.enterCompilationScope();
        spelNodeImpl.generateCode(methodVisitor, codeFlow);
        codeFlow.exitCompilationScope();
        if (CodeFlow.isPrimitive(string)) {
            CodeFlow.insertBoxIfNecessary(methodVisitor, string);
            bl2 = true;
        }
        codeFlow.enterCompilationScope();
        spelNodeImpl2.generateCode(methodVisitor, codeFlow);
        codeFlow.exitCompilationScope();
        if (CodeFlow.isPrimitive(string2)) {
            CodeFlow.insertBoxIfNecessary(methodVisitor, string2);
            bl3 = true;
        }
        Label label3 = new Label();
        methodVisitor.visitInsn(89);
        methodVisitor.visitJumpInsn(199, label3);
        methodVisitor.visitInsn(95);
        Label label4 = new Label();
        methodVisitor.visitJumpInsn(199, label4);
        methodVisitor.visitInsn(87);
        switch (n2) {
            case 156: 
            case 158: {
                methodVisitor.visitInsn(3);
                break;
            }
            case 155: 
            case 157: {
                methodVisitor.visitInsn(4);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported: " + n2);
            }
        }
        methodVisitor.visitJumpInsn(167, label2);
        methodVisitor.visitLabel(label4);
        methodVisitor.visitInsn(87);
        switch (n2) {
            case 156: 
            case 157: {
                methodVisitor.visitInsn(3);
                break;
            }
            case 155: 
            case 158: {
                methodVisitor.visitInsn(4);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported: " + n2);
            }
        }
        methodVisitor.visitJumpInsn(167, label2);
        methodVisitor.visitLabel(label3);
        methodVisitor.visitInsn(95);
        methodVisitor.visitInsn(89);
        Label label5 = new Label();
        methodVisitor.visitJumpInsn(199, label5);
        methodVisitor.visitInsn(88);
        switch (n2) {
            case 156: 
            case 157: {
                methodVisitor.visitInsn(4);
                break;
            }
            case 155: 
            case 158: {
                methodVisitor.visitInsn(3);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported: " + n2);
            }
        }
        methodVisitor.visitJumpInsn(167, label2);
        methodVisitor.visitLabel(label5);
        if (bl2) {
            CodeFlow.insertUnboxInsns(methodVisitor, c2, string);
        }
        if (c2 == 'D' || c2 == 'J') {
            methodVisitor.visitInsn(93);
            methodVisitor.visitInsn(88);
        } else {
            methodVisitor.visitInsn(95);
        }
        if (bl3) {
            CodeFlow.insertUnboxInsns(methodVisitor, c2, string2);
        }
        if (c2 == 'D') {
            methodVisitor.visitInsn(152);
            methodVisitor.visitJumpInsn(n2, label);
        } else if (c2 == 'F') {
            methodVisitor.visitInsn(150);
            methodVisitor.visitJumpInsn(n2, label);
        } else if (c2 == 'J') {
            methodVisitor.visitInsn(148);
            methodVisitor.visitJumpInsn(n2, label);
        } else if (c2 == 'I') {
            methodVisitor.visitJumpInsn(n3, label);
        } else {
            throw new IllegalStateException("Unexpected descriptor " + string);
        }
        methodVisitor.visitInsn(4);
        methodVisitor.visitJumpInsn(167, label2);
        methodVisitor.visitLabel(label);
        methodVisitor.visitInsn(3);
        methodVisitor.visitLabel(label2);
        codeFlow.pushDescriptor("Z");
    }

    public static boolean equalityCheck(EvaluationContext evaluationContext, Object object, Object object2) {
        Class<?> clazz;
        if (object instanceof Number && object2 instanceof Number) {
            Number number = (Number)object;
            Number number2 = (Number)object2;
            if (number instanceof BigDecimal || number2 instanceof BigDecimal) {
                BigDecimal bigDecimal;
                BigDecimal bigDecimal2 = NumberUtils.convertNumberToTargetClass(number, BigDecimal.class);
                return bigDecimal2.compareTo(bigDecimal = NumberUtils.convertNumberToTargetClass(number2, BigDecimal.class)) == 0;
            }
            if (number instanceof Double || number2 instanceof Double) {
                return number.doubleValue() == number2.doubleValue();
            }
            if (number instanceof Float || number2 instanceof Float) {
                return number.floatValue() == number2.floatValue();
            }
            if (number instanceof BigInteger || number2 instanceof BigInteger) {
                BigInteger bigInteger;
                BigInteger bigInteger2 = NumberUtils.convertNumberToTargetClass(number, BigInteger.class);
                return bigInteger2.compareTo(bigInteger = NumberUtils.convertNumberToTargetClass(number2, BigInteger.class)) == 0;
            }
            if (number instanceof Long || number2 instanceof Long) {
                return number.longValue() == number2.longValue();
            }
            if (number instanceof Integer || number2 instanceof Integer) {
                return number.intValue() == number2.intValue();
            }
            if (number instanceof Short || number2 instanceof Short) {
                return number.shortValue() == number2.shortValue();
            }
            if (number instanceof Byte || number2 instanceof Byte) {
                return number.byteValue() == number2.byteValue();
            }
            return number.doubleValue() == number2.doubleValue();
        }
        if (object instanceof CharSequence && object2 instanceof CharSequence) {
            return object.toString().equals(object2.toString());
        }
        if (object instanceof Boolean && object2 instanceof Boolean) {
            return object.equals(object2);
        }
        if (ObjectUtils.nullSafeEquals(object, object2)) {
            return true;
        }
        if (object instanceof Comparable && object2 instanceof Comparable && (clazz = ClassUtils.determineCommonAncestor(object.getClass(), object2.getClass())) != null && Comparable.class.isAssignableFrom(clazz)) {
            return evaluationContext.getTypeComparator().compare(object, object2) == 0;
        }
        return false;
    }

    protected static final class DescriptorComparison {
        static final DescriptorComparison NOT_NUMBERS = new DescriptorComparison(false, false, ' ');
        static final DescriptorComparison INCOMPATIBLE_NUMBERS = new DescriptorComparison(true, false, ' ');
        final boolean areNumbers;
        final boolean areCompatible;
        final char compatibleType;

        private DescriptorComparison(boolean bl2, boolean bl3, char c2) {
            this.areNumbers = bl2;
            this.areCompatible = bl3;
            this.compatibleType = c2;
        }

        public static DescriptorComparison checkNumericCompatibility(String string, String string2, String string3, String string4) {
            String string5 = string;
            String string6 = string2;
            boolean bl2 = CodeFlow.isPrimitiveOrUnboxableSupportedNumberOrBoolean(string5);
            boolean bl3 = CodeFlow.isPrimitiveOrUnboxableSupportedNumberOrBoolean(string6);
            if (!bl2 && !ObjectUtils.nullSafeEquals(string5, string3)) {
                string5 = string3;
                bl2 = CodeFlow.isPrimitiveOrUnboxableSupportedNumberOrBoolean(string5);
            }
            if (!bl3 && !ObjectUtils.nullSafeEquals(string6, string4)) {
                string6 = string4;
                bl3 = CodeFlow.isPrimitiveOrUnboxableSupportedNumberOrBoolean(string6);
            }
            if (bl2 && bl3) {
                if (CodeFlow.areBoxingCompatible(string5, string6)) {
                    return new DescriptorComparison(true, true, CodeFlow.toPrimitiveTargetDesc(string5));
                }
                return INCOMPATIBLE_NUMBERS;
            }
            return NOT_NUMBERS;
        }
    }
}

