/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.util;

import com.gradle.maven.extension.internal.dep.org.springframework.util.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.StringUtils;
import java.io.File;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;

public abstract class ObjectUtils {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static boolean isArray(Object object) {
        return object != null && object.getClass().isArray();
    }

    public static boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    public static Object[] toObjectArray(Object object) {
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        if (object == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("Source is not an array: " + object);
        }
        int n2 = Array.getLength(object);
        if (n2 == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Class<?> clazz = Array.get(object, 0).getClass();
        Object[] objectArray = (Object[])Array.newInstance(clazz, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = Array.get(object, i2);
        }
        return objectArray;
    }

    public static boolean nullSafeEquals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object.equals(object2)) {
            return true;
        }
        if (object.getClass().isArray() && object2.getClass().isArray()) {
            return ObjectUtils.arrayEquals(object, object2);
        }
        return false;
    }

    private static boolean arrayEquals(Object object, Object object2) {
        if (object instanceof Object[] && object2 instanceof Object[]) {
            return Arrays.equals((Object[])object, (Object[])object2);
        }
        if (object instanceof boolean[] && object2 instanceof boolean[]) {
            return Arrays.equals((boolean[])object, (boolean[])object2);
        }
        if (object instanceof byte[] && object2 instanceof byte[]) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (object instanceof char[] && object2 instanceof char[]) {
            return Arrays.equals((char[])object, (char[])object2);
        }
        if (object instanceof double[] && object2 instanceof double[]) {
            return Arrays.equals((double[])object, (double[])object2);
        }
        if (object instanceof float[] && object2 instanceof float[]) {
            return Arrays.equals((float[])object, (float[])object2);
        }
        if (object instanceof int[] && object2 instanceof int[]) {
            return Arrays.equals((int[])object, (int[])object2);
        }
        if (object instanceof long[] && object2 instanceof long[]) {
            return Arrays.equals((long[])object, (long[])object2);
        }
        if (object instanceof short[] && object2 instanceof short[]) {
            return Arrays.equals((short[])object, (short[])object2);
        }
        return false;
    }

    public static int nullSafeHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (object.getClass().isArray()) {
            if (object instanceof Object[]) {
                return ObjectUtils.nullSafeHashCode((Object[])object);
            }
            if (object instanceof boolean[]) {
                return ObjectUtils.nullSafeHashCode((boolean[])object);
            }
            if (object instanceof byte[]) {
                return ObjectUtils.nullSafeHashCode((byte[])object);
            }
            if (object instanceof char[]) {
                return ObjectUtils.nullSafeHashCode((char[])object);
            }
            if (object instanceof double[]) {
                return ObjectUtils.nullSafeHashCode((double[])object);
            }
            if (object instanceof float[]) {
                return ObjectUtils.nullSafeHashCode((float[])object);
            }
            if (object instanceof int[]) {
                return ObjectUtils.nullSafeHashCode((int[])object);
            }
            if (object instanceof long[]) {
                return ObjectUtils.nullSafeHashCode((long[])object);
            }
            if (object instanceof short[]) {
                return ObjectUtils.nullSafeHashCode((short[])object);
            }
        }
        return object.hashCode();
    }

    public static int nullSafeHashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n2 = 7;
        for (Object object : objectArray) {
            n2 = 31 * n2 + ObjectUtils.nullSafeHashCode(object);
        }
        return n2;
    }

    public static int nullSafeHashCode(boolean[] blArray) {
        if (blArray == null) {
            return 0;
        }
        int n2 = 7;
        for (boolean bl2 : blArray) {
            n2 = 31 * n2 + Boolean.hashCode(bl2);
        }
        return n2;
    }

    public static int nullSafeHashCode(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n2 = 7;
        for (byte by2 : byArray) {
            n2 = 31 * n2 + by2;
        }
        return n2;
    }

    public static int nullSafeHashCode(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n2 = 7;
        for (char c2 : cArray) {
            n2 = 31 * n2 + c2;
        }
        return n2;
    }

    public static int nullSafeHashCode(double[] dArray) {
        if (dArray == null) {
            return 0;
        }
        int n2 = 7;
        for (double d2 : dArray) {
            n2 = 31 * n2 + Double.hashCode(d2);
        }
        return n2;
    }

    public static int nullSafeHashCode(float[] fArray) {
        if (fArray == null) {
            return 0;
        }
        int n2 = 7;
        for (float f2 : fArray) {
            n2 = 31 * n2 + Float.hashCode(f2);
        }
        return n2;
    }

    public static int nullSafeHashCode(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n2 = 7;
        for (int n3 : nArray) {
            n2 = 31 * n2 + n3;
        }
        return n2;
    }

    public static int nullSafeHashCode(long[] lArray) {
        if (lArray == null) {
            return 0;
        }
        int n2 = 7;
        for (long l2 : lArray) {
            n2 = 31 * n2 + Long.hashCode(l2);
        }
        return n2;
    }

    public static int nullSafeHashCode(short[] sArray) {
        if (sArray == null) {
            return 0;
        }
        int n2 = 7;
        for (short s2 : sArray) {
            n2 = 31 * n2 + s2;
        }
        return n2;
    }

    public static String getIdentityHexString(Object object) {
        return Integer.toHexString(System.identityHashCode(object));
    }

    public static String nullSafeToString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Object[]) {
            return ObjectUtils.nullSafeToString((Object[])object);
        }
        if (object instanceof boolean[]) {
            return ObjectUtils.nullSafeToString((boolean[])object);
        }
        if (object instanceof byte[]) {
            return ObjectUtils.nullSafeToString((byte[])object);
        }
        if (object instanceof char[]) {
            return ObjectUtils.nullSafeToString((char[])object);
        }
        if (object instanceof double[]) {
            return ObjectUtils.nullSafeToString((double[])object);
        }
        if (object instanceof float[]) {
            return ObjectUtils.nullSafeToString((float[])object);
        }
        if (object instanceof int[]) {
            return ObjectUtils.nullSafeToString((int[])object);
        }
        if (object instanceof long[]) {
            return ObjectUtils.nullSafeToString((long[])object);
        }
        if (object instanceof short[]) {
            return ObjectUtils.nullSafeToString((short[])object);
        }
        String string = object.toString();
        return string != null ? string : "";
    }

    public static String nullSafeToString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        int n2 = objectArray.length;
        if (n2 == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        for (Object object : objectArray) {
            stringJoiner.add(String.valueOf(object));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(boolean[] blArray) {
        if (blArray == null) {
            return "null";
        }
        int n2 = blArray.length;
        if (n2 == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        for (boolean bl2 : blArray) {
            stringJoiner.add(String.valueOf(bl2));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        int n2 = byArray.length;
        if (n2 == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        for (byte by2 : byArray) {
            stringJoiner.add(String.valueOf(by2));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(char[] cArray) {
        if (cArray == null) {
            return "null";
        }
        int n2 = cArray.length;
        if (n2 == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        for (char c2 : cArray) {
            stringJoiner.add('\'' + String.valueOf(c2) + '\'');
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(double[] dArray) {
        if (dArray == null) {
            return "null";
        }
        int n2 = dArray.length;
        if (n2 == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        for (double d2 : dArray) {
            stringJoiner.add(String.valueOf(d2));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(float[] fArray) {
        if (fArray == null) {
            return "null";
        }
        int n2 = fArray.length;
        if (n2 == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        for (float f2 : fArray) {
            stringJoiner.add(String.valueOf(f2));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        int n2 = nArray.length;
        if (n2 == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        for (int n3 : nArray) {
            stringJoiner.add(String.valueOf(n3));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(long[] lArray) {
        if (lArray == null) {
            return "null";
        }
        int n2 = lArray.length;
        if (n2 == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        for (long l2 : lArray) {
            stringJoiner.add(String.valueOf(l2));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeToString(short[] sArray) {
        if (sArray == null) {
            return "null";
        }
        int n2 = sArray.length;
        if (n2 == 0) {
            return "{}";
        }
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        for (short s2 : sArray) {
            stringJoiner.add(String.valueOf(s2));
        }
        return stringJoiner.toString();
    }

    public static String nullSafeConciseToString(Object object) {
        String string;
        if (object == null) {
            return "null";
        }
        if (object instanceof Optional) {
            Optional optional = (Optional)object;
            return !optional.isPresent() ? "Optional.empty" : String.format("Optional[%s]", ObjectUtils.nullSafeConciseToString(optional.get()));
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) == 0 ? "{}" : "{...}";
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty() ? "[]" : "[...]";
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty() ? "{}" : "{...}";
        }
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        if (object instanceof Charset) {
            return ((Charset)object).name();
        }
        if (object instanceof TimeZone) {
            return ((TimeZone)object).getID();
        }
        if (object instanceof ZoneId) {
            return ((ZoneId)object).getId();
        }
        if (object instanceof CharSequence) {
            return StringUtils.truncate((CharSequence)object);
        }
        Class<?> clazz = object.getClass();
        if (ObjectUtils.isSimpleValueType(clazz) && (string = object.toString()) != null) {
            return StringUtils.truncate(string);
        }
        return clazz.getTypeName() + "@" + ObjectUtils.getIdentityHexString(object);
    }

    private static boolean isSimpleValueType(Class<?> clazz) {
        return Void.class != clazz && Void.TYPE != clazz && (ClassUtils.isPrimitiveOrWrapper(clazz) || Enum.class.isAssignableFrom(clazz) || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || Temporal.class.isAssignableFrom(clazz) || ZoneId.class.isAssignableFrom(clazz) || TimeZone.class.isAssignableFrom(clazz) || File.class.isAssignableFrom(clazz) || Path.class.isAssignableFrom(clazz) || Charset.class.isAssignableFrom(clazz) || Currency.class.isAssignableFrom(clazz) || InetAddress.class.isAssignableFrom(clazz) || URI.class == clazz || URL.class == clazz || UUID.class == clazz || Locale.class == clazz || Pattern.class == clazz || Class.class == clazz);
    }
}

