/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.internal.RelativePathSupplier;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.DirectorySnapshotBuilder;
import org.gradle.internal.snapshot.FileSystemLeafSnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.RelativePathTrackingFileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;
import org.gradle.internal.snapshot.SnapshottingFilter;

public class FileSystemSnapshotFilter {
    public static FileSystemSnapshot filterSnapshot(SnapshottingFilter.FileSystemSnapshotPredicate fileSystemSnapshotPredicate, FileSystemSnapshot fileSystemSnapshot) {
        DirectorySnapshotBuilder directorySnapshotBuilder = MerkleDirectorySnapshotBuilder.noSortingRequired();
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        fileSystemSnapshot.accept(new RelativePathTracker(), new FilteringVisitor(fileSystemSnapshotPredicate, directorySnapshotBuilder, atomicBoolean));
        if (directorySnapshotBuilder.getResult() == null) {
            return FileSystemSnapshot.EMPTY;
        }
        return atomicBoolean.get() ? directorySnapshotBuilder.getResult() : fileSystemSnapshot;
    }

    private static class FilteringVisitor
    implements RelativePathTrackingFileSystemSnapshotHierarchyVisitor {
        private final SnapshottingFilter.FileSystemSnapshotPredicate predicate;
        private final DirectorySnapshotBuilder builder;
        private final AtomicBoolean hasBeenFiltered;

        public FilteringVisitor(SnapshottingFilter.FileSystemSnapshotPredicate fileSystemSnapshotPredicate, DirectorySnapshotBuilder directorySnapshotBuilder, AtomicBoolean atomicBoolean) {
            this.predicate = fileSystemSnapshotPredicate;
            this.builder = directorySnapshotBuilder;
            this.hasBeenFiltered = atomicBoolean;
        }

        @Override
        public void enterDirectory(DirectorySnapshot directorySnapshot, RelativePathSupplier relativePathSupplier) {
            this.builder.enterDirectory(directorySnapshot, DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy.INCLUDE_EMPTY_DIRS);
        }

        @Override
        public SnapshotVisitResult visitEntry(FileSystemLocationSnapshot fileSystemLocationSnapshot, RelativePathSupplier relativePathSupplier) {
            SnapshotVisitResult snapshotVisitResult;
            final boolean bl2 = relativePathSupplier.isRoot();
            Collection<String> collection = bl2 ? ImmutableList.of(fileSystemLocationSnapshot.getName()) : relativePathSupplier.getSegments();
            boolean bl3 = fileSystemLocationSnapshot.accept(new FileSystemLocationSnapshot.FileSystemLocationSnapshotTransformer<Boolean>(){

                @Override
                public Boolean visitDirectory(DirectorySnapshot directorySnapshot) {
                    return bl2;
                }

                @Override
                public Boolean visitRegularFile(RegularFileSnapshot regularFileSnapshot) {
                    return false;
                }

                @Override
                public Boolean visitMissing(MissingFileSnapshot missingFileSnapshot) {
                    return false;
                }
            });
            if (bl3 || this.predicate.test(fileSystemLocationSnapshot, collection)) {
                if (fileSystemLocationSnapshot instanceof FileSystemLeafSnapshot) {
                    this.builder.visitLeafElement((FileSystemLeafSnapshot)fileSystemLocationSnapshot);
                }
                snapshotVisitResult = SnapshotVisitResult.CONTINUE;
            } else {
                this.hasBeenFiltered.set(true);
                snapshotVisitResult = SnapshotVisitResult.SKIP_SUBTREE;
            }
            return snapshotVisitResult;
        }

        @Override
        public void leaveDirectory(DirectorySnapshot directorySnapshot, RelativePathSupplier relativePathSupplier) {
            this.builder.leaveDirectory();
        }
    }
}

