/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd;

import java.net.URI;

public final class DTDId {
    protected final String mPublicId;
    protected final URI mSystemId;
    protected final int mConfigFlags;
    protected final boolean mXml11;
    protected int mHashCode = 0;

    private DTDId(String string, URI uRI, int n2, boolean bl2) {
        this.mPublicId = string;
        this.mSystemId = uRI;
        this.mConfigFlags = n2;
        this.mXml11 = bl2;
    }

    public static DTDId constructFromPublicId(String string, int n2, boolean bl2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Empty/null public id.");
        }
        return new DTDId(string, null, n2, bl2);
    }

    public static DTDId constructFromSystemId(URI uRI, int n2, boolean bl2) {
        if (uRI == null) {
            throw new IllegalArgumentException("Null system id.");
        }
        return new DTDId(null, uRI, n2, bl2);
    }

    public static DTDId construct(String string, URI uRI, int n2, boolean bl2) {
        if (string != null && string.length() > 0) {
            return new DTDId(string, null, n2, bl2);
        }
        if (uRI == null) {
            throw new IllegalArgumentException("Illegal arguments; both public and system id null/empty.");
        }
        return new DTDId(null, uRI, n2, bl2);
    }

    public int hashCode() {
        int n2 = this.mHashCode;
        if (n2 == 0) {
            n2 = this.mConfigFlags;
            n2 = this.mPublicId != null ? (n2 ^= this.mPublicId.hashCode()) : (n2 ^= this.mSystemId.hashCode());
            if (this.mXml11) {
                n2 ^= 1;
            }
            this.mHashCode = n2;
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append("Public-id: ");
        stringBuffer.append(this.mPublicId);
        stringBuffer.append(", system-id: ");
        stringBuffer.append(this.mSystemId);
        stringBuffer.append(" [config flags: 0x");
        stringBuffer.append(Integer.toHexString(this.mConfigFlags));
        stringBuffer.append("], xml11: ");
        stringBuffer.append(this.mXml11);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        DTDId dTDId = (DTDId)object;
        if (dTDId.mConfigFlags != this.mConfigFlags || dTDId.mXml11 != this.mXml11) {
            return false;
        }
        if (this.mPublicId != null) {
            String string = dTDId.mPublicId;
            return string != null && string.equals(this.mPublicId);
        }
        return this.mSystemId.equals(dTDId.mSystemId);
    }
}

