/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ExpressionPool;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.ChoiceState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.GrammarReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.GrammarReaderController;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.SequenceState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.State;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.TerminalState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.datatype.xsd.FacetState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.ElementRefState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.HedgeRefState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.core.InlineElementState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.StartTagInfo;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;

public abstract class RELAXReader
extends GrammarReader {
    public static final String RELAXCoreNamespace = "http://www.xml.gr.jp/xmlns/relaxCore";
    public final StateFactory sfactory;
    public static final String ERR_ILLEGAL_OCCURS = "RELAXReader.IllegalOccurs";
    public static final String ERR_MISPLACED_OCCURS = "RELAXReader.MisplacedOccurs";

    public RELAXReader(GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory, StateFactory stateFactory, ExpressionPool expressionPool, State state) {
        super(grammarReaderController, sAXParserFactory, expressionPool, state);
        this.sfactory = stateFactory;
    }

    public State createExpressionChildState(State state, StartTagInfo startTagInfo) {
        if (startTagInfo.localName.equals("ref")) {
            return this.sfactory.refLabel(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("hedgeRef")) {
            return this.sfactory.hedgeRef(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("choice")) {
            return this.sfactory.choice(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("none")) {
            return this.sfactory.none(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("empty")) {
            return this.sfactory.empty(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("sequence")) {
            return this.sfactory.sequence(state, startTagInfo);
        }
        return null;
    }

    public FacetState createFacetState(State state, StartTagInfo startTagInfo) {
        if (!RELAXCoreNamespace.equals(startTagInfo.namespaceURI)) {
            return null;
        }
        if (FacetState.facetNames.contains(startTagInfo.localName)) {
            return this.sfactory.facets(state, startTagInfo);
        }
        return null;
    }

    protected boolean canHaveOccurs(State state) {
        return state instanceof SequenceState || state instanceof ElementRefState || state instanceof HedgeRefState || state instanceof ChoiceState || state instanceof InlineElementState;
    }

    protected Expression interceptExpression(State state, Expression expression) {
        String string = state.getStartTag().getAttribute("occurs");
        if (this.canHaveOccurs(state)) {
            if (string != null) {
                if (string.equals("?")) {
                    expression = this.pool.createOptional(expression);
                } else if (string.equals("+")) {
                    expression = this.pool.createOneOrMore(expression);
                } else if (string.equals("*")) {
                    expression = this.pool.createZeroOrMore(expression);
                } else {
                    this.reportError(ERR_ILLEGAL_OCCURS, (Object)string);
                }
            }
        } else if (string != null) {
            this.reportError(ERR_MISPLACED_OCCURS, (Object)state.getStartTag().localName);
        }
        return expression;
    }

    protected abstract Expression resolveElementRef(String var1, String var2);

    protected abstract Expression resolveHedgeRef(String var1, String var2);

    protected String localizeMessage(String string, Object[] objectArray) {
        String string2;
        try {
            string2 = ResourceBundle.getBundle("com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.relax.Messages").getString(string);
        }
        catch (Exception exception) {
            string2 = ResourceBundle.getBundle("com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.Messages").getString(string);
        }
        return MessageFormat.format(string2, objectArray);
    }

    protected ExpressionPool getPool() {
        return this.pool;
    }

    public static class StateFactory {
        protected State refLabel(State state, StartTagInfo startTagInfo) {
            return new ElementRefState();
        }

        protected State hedgeRef(State state, StartTagInfo startTagInfo) {
            return new HedgeRefState();
        }

        protected State choice(State state, StartTagInfo startTagInfo) {
            return new ChoiceState();
        }

        protected State none(State state, StartTagInfo startTagInfo) {
            return new TerminalState(Expression.nullSet);
        }

        protected State empty(State state, StartTagInfo startTagInfo) {
            return new TerminalState(Expression.epsilon);
        }

        protected State sequence(State state, StartTagInfo startTagInfo) {
            return new SequenceState();
        }

        protected FacetState facets(State state, StartTagInfo startTagInfo) {
            return new FacetState();
        }
    }
}

