/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routeopt.client;

import com.graphhopper.routeopt.client.ApiCallback;
import com.graphhopper.routeopt.client.ApiException;
import com.graphhopper.routeopt.client.ApiResponse;
import com.graphhopper.routeopt.client.JSON;
import com.graphhopper.routeopt.client.Pair;
import com.graphhopper.routeopt.client.ProgressRequestBody;
import com.graphhopper.routeopt.client.StringUtil;
import com.graphhopper.routeopt.client.auth.ApiKeyAuth;
import com.graphhopper.routeopt.client.auth.Authentication;
import com.graphhopper.routeopt.client.auth.HttpBasicAuth;
import com.graphhopper.routeopt.client.auth.OAuth;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.internal.http.HttpMethod;
import com.squareup.okhttp.logging.HttpLoggingInterceptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class ApiClient {
    public static final double JAVA_VERSION;
    public static final boolean IS_ANDROID;
    public static final int ANDROID_SDK_VERSION;
    public static final String LENIENT_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private String basePath = "https://graphhopper.com/api/1/vrp";
    private boolean lenientOnJson = false;
    private boolean debugging = false;
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private String tempFolderPath = null;
    private Map<String, Authentication> authentications;
    private DateFormat dateFormat;
    private DateFormat datetimeFormat;
    private boolean lenientDatetimeFormat;
    private int dateLength;
    private InputStream sslCaCert;
    private boolean verifyingSsl = true;
    private OkHttpClient httpClient = new OkHttpClient();
    private JSON json = new JSON(this);
    private HttpLoggingInterceptor loggingInterceptor;

    public ApiClient() {
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.initDatetimeFormat();
        this.lenientDatetimeFormat = true;
        this.setUserAgent("Swagger-Codegen/0.8-SNAPSHOT/java");
        this.authentications = new HashMap<String, Authentication>();
        this.authentications.put("api_key", new ApiKeyAuth("query", "key"));
        this.authentications = Collections.unmodifiableMap(this.authentications);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public JSON getJSON() {
        return this.json;
    }

    public ApiClient setJSON(JSON json) {
        this.json = json;
        return this;
    }

    public boolean isVerifyingSsl() {
        return this.verifyingSsl;
    }

    public ApiClient setVerifyingSsl(boolean verifyingSsl) {
        this.verifyingSsl = verifyingSsl;
        this.applySslSettings();
        return this;
    }

    public InputStream getSslCaCert() {
        return this.sslCaCert;
    }

    public ApiClient setSslCaCert(InputStream sslCaCert) {
        this.sslCaCert = sslCaCert;
        this.applySslSettings();
        return this;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.dateLength = this.dateFormat.format(new Date()).length();
        return this;
    }

    public DateFormat getDatetimeFormat() {
        return this.datetimeFormat;
    }

    public ApiClient setDatetimeFormat(DateFormat datetimeFormat) {
        this.datetimeFormat = datetimeFormat;
        return this;
    }

    public boolean isLenientDatetimeFormat() {
        return this.lenientDatetimeFormat;
    }

    public ApiClient setLenientDatetimeFormat(boolean lenientDatetimeFormat) {
        this.lenientDatetimeFormat = lenientDatetimeFormat;
        return this;
    }

    public Date parseDate(String str) {
        if (str == null) {
            return null;
        }
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Date parseDatetime(String str) {
        DateFormat format;
        if (str == null) {
            return null;
        }
        if (this.lenientDatetimeFormat) {
            str = str.replaceAll("[zZ]\\z", "+0000");
            str = str.replaceAll("([+-]\\d{2}):(\\d{2})\\z", "$1$2");
            str = str.replaceAll("([+-]\\d{2})\\z", "$100");
            str = str.replaceAll("(:\\d{1,2})([+-]\\d{4})\\z", "$1.000$2");
            format = new SimpleDateFormat(LENIENT_DATETIME_FORMAT);
        } else {
            format = this.datetimeFormat;
        }
        try {
            return format.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Date parseDateOrDatetime(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() <= this.dateLength) {
            return this.parseDate(str);
        }
        return this.parseDatetime(str);
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String formatDatetime(Date date) {
        return this.datetimeFormat.format(date);
    }

    public Map<String, Authentication> getAuthentications() {
        return this.authentications;
    }

    public Authentication getAuthentication(String authName) {
        return this.authentications.get(authName);
    }

    public void setUsername(String username) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setUsername(username);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setPassword(String password) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof HttpBasicAuth)) continue;
            ((HttpBasicAuth)auth).setPassword(password);
            return;
        }
        throw new RuntimeException("No HTTP basic authentication configured!");
    }

    public void setApiKey(String apiKey) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKey(apiKey);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setApiKeyPrefix(String apiKeyPrefix) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof ApiKeyAuth)) continue;
            ((ApiKeyAuth)auth).setApiKeyPrefix(apiKeyPrefix);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setAccessToken(String accessToken) {
        for (Authentication auth : this.authentications.values()) {
            if (!(auth instanceof OAuth)) continue;
            ((OAuth)auth).setAccessToken(accessToken);
            return;
        }
        throw new RuntimeException("No OAuth2 authentication configured!");
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public boolean isLenientOnJson() {
        return this.lenientOnJson;
    }

    public ApiClient setLenientOnJson(boolean lenient) {
        this.lenientOnJson = lenient;
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        if (debugging != this.debugging) {
            if (debugging) {
                this.loggingInterceptor = new HttpLoggingInterceptor();
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                this.httpClient.interceptors().add(this.loggingInterceptor);
            } else {
                this.httpClient.interceptors().remove(this.loggingInterceptor);
                this.loggingInterceptor = null;
            }
        }
        this.debugging = debugging;
        return this;
    }

    public String getTempFolderPath() {
        return this.tempFolderPath;
    }

    public ApiClient setTempFolderPath(String tempFolderPath) {
        this.tempFolderPath = tempFolderPath;
        return this;
    }

    public int getConnectTimeout() {
        return this.httpClient.getConnectTimeout();
    }

    public ApiClient setConnectTimeout(int connectionTimeout) {
        this.httpClient.setConnectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDatetime((Date)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        Collection valueCollection = null;
        if (!(value instanceof Collection)) {
            params.add(new Pair(name, this.parameterToString(value)));
            return params;
        }
        valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        String string = collectionFormat = collectionFormat == null || collectionFormat.isEmpty() ? "csv" : collectionFormat;
        if (collectionFormat.equals("multi")) {
            for (Object item : valueCollection) {
                params.add(new Pair(name, this.parameterToString(item)));
            }
            return params;
        }
        String delimiter = ",";
        if (collectionFormat.equals("csv")) {
            delimiter = ",";
        } else if (collectionFormat.equals("ssv")) {
            delimiter = " ";
        } else if (collectionFormat.equals("tsv")) {
            delimiter = "\t";
        } else if (collectionFormat.equals("pipes")) {
            delimiter = "|";
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : valueCollection) {
            sb.append(delimiter);
            sb.append(this.parameterToString(item));
        }
        params.add(new Pair(name, sb.substring(1)));
        return params;
    }

    public String sanitizeFilename(String filename) {
        return filename.replaceAll(".*[/\\\\]", "");
    }

    public boolean isJsonMime(String mime) {
        return mime != null && mime.matches("(?i)application\\/json(;.*)?");
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public <T> T deserialize(Response response, Type returnType) throws ApiException {
        String respBody;
        if (response == null || returnType == null) {
            return null;
        }
        if ("byte[]".equals(returnType.toString())) {
            try {
                return (T)response.body().bytes();
            }
            catch (IOException e) {
                throw new ApiException(e);
            }
        }
        if (returnType.equals(File.class)) {
            return (T)this.downloadFileFromResponse(response);
        }
        try {
            respBody = response.body() != null ? response.body().string() : null;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (respBody == null || "".equals(respBody)) {
            return null;
        }
        String contentType = response.headers().get("Content-Type");
        if (contentType == null) {
            contentType = "application/json";
        }
        if (this.isJsonMime(contentType)) {
            return this.json.deserialize(respBody, returnType);
        }
        if (returnType.equals(String.class)) {
            return (T)respBody;
        }
        throw new ApiException("Content type \"" + contentType + "\" is not supported for type: " + returnType, response.code(), (Map<String, List<String>>)response.headers().toMultimap(), respBody);
    }

    public RequestBody serialize(Object obj, String contentType) throws ApiException {
        if (obj instanceof byte[]) {
            return RequestBody.create((MediaType)MediaType.parse((String)contentType), (byte[])((byte[])obj));
        }
        if (obj instanceof File) {
            return RequestBody.create((MediaType)MediaType.parse((String)contentType), (File)((File)obj));
        }
        if (this.isJsonMime(contentType)) {
            String content = obj != null ? this.json.serialize(obj) : null;
            return RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)content);
        }
        throw new ApiException("Content type \"" + contentType + "\" is not supported");
    }

    public File downloadFileFromResponse(Response response) throws ApiException {
        try {
            File file = this.prepareDownloadFile(response);
            BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)file));
            sink.writeAll((Source)response.body().source());
            sink.close();
            return file;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public File prepareDownloadFile(Response response) throws IOException {
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        String contentDisposition = response.header("Content-Disposition");
        if (contentDisposition != null && !"".equals(contentDisposition) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition)).find()) {
            filename = this.sanitizeFilename(matcher.group(1));
        }
        String prefix = null;
        String suffix = null;
        if (filename == null) {
            prefix = "download-";
            suffix = "";
        } else {
            int pos = filename.lastIndexOf(".");
            if (pos == -1) {
                prefix = filename + "-";
            } else {
                prefix = filename.substring(0, pos) + "-";
                suffix = filename.substring(pos);
            }
            if (prefix.length() < 3) {
                prefix = "download-";
            }
        }
        if (this.tempFolderPath == null) {
            return File.createTempFile(prefix, suffix);
        }
        return File.createTempFile(prefix, suffix, new File(this.tempFolderPath));
    }

    public <T> ApiResponse<T> execute(Call call) throws ApiException {
        return this.execute(call, null);
    }

    public <T> ApiResponse<T> execute(Call call, Type returnType) throws ApiException {
        try {
            Response response = call.execute();
            T data = this.handleResponse(response, returnType);
            return new ApiResponse<T>(response.code(), response.headers().toMultimap(), data);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public <T> void executeAsync(Call call, ApiCallback<T> callback) {
        this.executeAsync(call, null, callback);
    }

    public <T> void executeAsync(Call call, final Type returnType, final ApiCallback<T> callback) {
        call.enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                callback.onFailure(new ApiException(e), 0, null);
            }

            public void onResponse(Response response) throws IOException {
                Object result;
                try {
                    result = ApiClient.this.handleResponse(response, returnType);
                }
                catch (ApiException e) {
                    callback.onFailure(e, response.code(), response.headers().toMultimap());
                    return;
                }
                callback.onSuccess(result, response.code(), response.headers().toMultimap());
            }
        });
    }

    public <T> T handleResponse(Response response, Type returnType) throws ApiException {
        if (response.isSuccessful()) {
            if (returnType == null || response.code() == 204) {
                return null;
            }
            return this.deserialize(response, returnType);
        }
        String respBody = null;
        if (response.body() != null) {
            try {
                respBody = response.body().string();
            }
            catch (IOException e) {
                throw new ApiException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
            }
        }
        throw new ApiException(response.message(), response.code(), (Map<String, List<String>>)response.headers().toMultimap(), respBody);
    }

    public Call buildCall(String path, String method, List<Pair> queryParams, Object body, Map<String, String> headerParams, Map<String, Object> formParams, String[] authNames, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        this.updateParamsForAuth(authNames, queryParams, headerParams);
        String url = this.buildUrl(path, queryParams);
        Request.Builder reqBuilder = new Request.Builder().url(url);
        this.processHeaderParams(headerParams, reqBuilder);
        String contentType = headerParams.get("Content-Type");
        if (contentType == null) {
            contentType = "application/json";
        }
        Object reqBody = !HttpMethod.permitsRequestBody((String)method) ? null : ("application/x-www-form-urlencoded".equals(contentType) ? this.buildRequestBodyFormEncoding(formParams) : ("multipart/form-data".equals(contentType) ? this.buildRequestBodyMultipart(formParams) : (body == null ? ("DELETE".equals(method) ? null : RequestBody.create((MediaType)MediaType.parse((String)contentType), (String)"")) : this.serialize(body, contentType))));
        Request request = null;
        if (progressRequestListener != null && reqBody != null) {
            ProgressRequestBody progressRequestBody = new ProgressRequestBody((RequestBody)reqBody, progressRequestListener);
            request = reqBuilder.method(method, (RequestBody)progressRequestBody).build();
        } else {
            request = reqBuilder.method(method, reqBody).build();
        }
        return this.httpClient.newCall(request);
    }

    public String buildUrl(String path, List<Pair> queryParams) {
        StringBuilder url = new StringBuilder();
        url.append(this.basePath).append(path);
        if (queryParams != null && !queryParams.isEmpty()) {
            String prefix = path.contains("?") ? "&" : "?";
            for (Pair param : queryParams) {
                if (param.getValue() == null) continue;
                if (prefix != null) {
                    url.append(prefix);
                    prefix = null;
                } else {
                    url.append("&");
                }
                String value = this.parameterToString(param.getValue());
                url.append(this.escapeString(param.getName())).append("=").append(this.escapeString(value));
            }
        }
        return url.toString();
    }

    public void processHeaderParams(Map<String, String> headerParams, Request.Builder reqBuilder) {
        for (Map.Entry<String, String> param : headerParams.entrySet()) {
            reqBuilder.header(param.getKey(), this.parameterToString(param.getValue()));
        }
        for (Map.Entry<String, String> header : this.defaultHeaderMap.entrySet()) {
            if (headerParams.containsKey(header.getKey())) continue;
            reqBuilder.header(header.getKey(), this.parameterToString(header.getValue()));
        }
    }

    public void updateParamsForAuth(String[] authNames, List<Pair> queryParams, Map<String, String> headerParams) {
        for (String authName : authNames) {
            Authentication auth = this.authentications.get(authName);
            if (auth == null) {
                throw new RuntimeException("Authentication undefined: " + authName);
            }
            auth.applyToParams(queryParams, headerParams);
        }
    }

    public RequestBody buildRequestBodyFormEncoding(Map<String, Object> formParams) {
        FormEncodingBuilder formBuilder = new FormEncodingBuilder();
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            formBuilder.add(param.getKey(), this.parameterToString(param.getValue()));
        }
        return formBuilder.build();
    }

    public RequestBody buildRequestBodyMultipart(Map<String, Object> formParams) {
        MultipartBuilder mpBuilder = new MultipartBuilder().type(MultipartBuilder.FORM);
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            if (param.getValue() instanceof File) {
                File file = (File)param.getValue();
                Headers partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + param.getKey() + "\"; filename=\"" + file.getName() + "\""});
                MediaType mediaType = MediaType.parse((String)this.guessContentTypeFromFile(file));
                mpBuilder.addPart(partHeaders, RequestBody.create((MediaType)mediaType, (File)file));
                continue;
            }
            Headers partHeaders = Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + param.getKey() + "\""});
            mpBuilder.addPart(partHeaders, RequestBody.create(null, (String)this.parameterToString(param.getValue())));
        }
        return mpBuilder.build();
    }

    public String guessContentTypeFromFile(File file) {
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        if (contentType == null) {
            return "application/octet-stream";
        }
        return contentType;
    }

    private void initDatetimeFormat() {
        String formatWithTimeZone = null;
        if (IS_ANDROID) {
            if (ANDROID_SDK_VERSION >= 18) {
                formatWithTimeZone = "yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ";
            }
        } else if (JAVA_VERSION >= 1.7) {
            formatWithTimeZone = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
        }
        if (formatWithTimeZone != null) {
            this.datetimeFormat = new SimpleDateFormat(formatWithTimeZone);
        } else {
            this.datetimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            this.datetimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    }

    private void applySslSettings() {
        try {
            KeyManager[] keyManagers = null;
            TrustManager[] trustManagers = null;
            HostnameVerifier hostnameVerifier = null;
            if (!this.verifyingSsl) {
                X509TrustManager trustAll = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
                SSLContext sslContext = SSLContext.getInstance("TLS");
                trustManagers = new TrustManager[]{trustAll};
                hostnameVerifier = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
            } else if (this.sslCaCert != null) {
                char[] password = null;
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(this.sslCaCert);
                if (certificates.isEmpty()) {
                    throw new IllegalArgumentException("expected non-empty set of trusted certificates");
                }
                KeyStore caKeyStore = this.newEmptyKeyStore(password);
                int index = 0;
                for (Certificate certificate : certificates) {
                    String certificateAlias = "ca" + Integer.toString(index++);
                    caKeyStore.setCertificateEntry(certificateAlias, certificate);
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(caKeyStore);
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            if (keyManagers != null || trustManagers != null) {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(keyManagers, trustManagers, new SecureRandom());
                this.httpClient.setSslSocketFactory(sslContext.getSocketFactory());
            } else {
                this.httpClient.setSslSocketFactory(null);
            }
            this.httpClient.setHostnameVerifier(hostnameVerifier);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private KeyStore newEmptyKeyStore(char[] password) throws GeneralSecurityException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, password);
            return keyStore;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        boolean isAndroid;
        JAVA_VERSION = Double.parseDouble(System.getProperty("java.specification.version"));
        try {
            Class.forName("android.app.Activity");
            isAndroid = true;
        }
        catch (ClassNotFoundException e) {
            isAndroid = false;
        }
        IS_ANDROID = isAndroid;
        int sdkVersion = 0;
        if (IS_ANDROID) {
            try {
                sdkVersion = Class.forName("android.os.Build$VERSION").getField("SDK_INT").getInt(null);
            }
            catch (Exception e) {
                try {
                    sdkVersion = Integer.parseInt((String)Class.forName("android.os.Build$VERSION").getField("SDK").get(null));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        ANDROID_SDK_VERSION = sdkVersion;
    }
}

