/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routeopt.client.api;

import com.google.gson.reflect.TypeToken;
import com.graphhopper.routeopt.client.ApiCallback;
import com.graphhopper.routeopt.client.ApiClient;
import com.graphhopper.routeopt.client.ApiException;
import com.graphhopper.routeopt.client.ApiResponse;
import com.graphhopper.routeopt.client.Configuration;
import com.graphhopper.routeopt.client.Pair;
import com.graphhopper.routeopt.client.ProgressRequestBody;
import com.graphhopper.routeopt.client.ProgressResponseBody;
import com.graphhopper.routeopt.client.model.Response;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class SolutionApi {
    private ApiClient apiClient;

    public SolutionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SolutionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call getSolutionCall(String key, String jobId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException("Missing the required parameter 'key' when calling getSolution(Async)");
        }
        if (jobId == null) {
            throw new ApiException("Missing the required parameter 'jobId' when calling getSolution(Async)");
        }
        String localVarPath = "/solution/{jobId}".replaceAll("\\{format\\}", "json").replaceAll("\\{jobId\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (key != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "key", key));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public com.squareup.okhttp.Response intercept(Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"api_key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    public Response getSolution(String key, String jobId) throws ApiException {
        ApiResponse<Response> resp = this.getSolutionWithHttpInfo(key, jobId);
        return resp.getData();
    }

    public ApiResponse<Response> getSolutionWithHttpInfo(String key, String jobId) throws ApiException {
        Call call = this.getSolutionCall(key, jobId, null, null);
        Type localVarReturnType = new TypeToken<Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSolutionAsync(String key, String jobId, final ApiCallback<Response> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSolutionCall(key, jobId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

