/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routeopt.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Activity {
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="location_id")
    private String locationId = null;
    @SerializedName(value="arr_time")
    private Long arrTime = null;
    @SerializedName(value="end_time")
    private Long endTime = null;
    @SerializedName(value="waiting_time")
    private Long waitingTime = null;
    @SerializedName(value="distance")
    private Long distance = null;
    @SerializedName(value="driving_time")
    private Long drivingTime = null;
    @SerializedName(value="load_before")
    private List<Integer> loadBefore = new ArrayList<Integer>();
    @SerializedName(value="load_after")
    private List<Integer> loadAfter = new ArrayList<Integer>();

    public Activity type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="type of activity")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Activity id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="id referring to the underlying service or shipment, i.e. the shipment or service this activity belongs to")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Activity locationId(String locationId) {
        this.locationId = locationId;
        return this;
    }

    @ApiModelProperty(example="null", value="id that refers to address")
    public String getLocationId() {
        return this.locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public Activity arrTime(Long arrTime) {
        this.arrTime = arrTime;
        return this;
    }

    @ApiModelProperty(example="null", value="arrival time at this activity in ms")
    public Long getArrTime() {
        return this.arrTime;
    }

    public void setArrTime(Long arrTime) {
        this.arrTime = arrTime;
    }

    public Activity endTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(example="null", value="end time of and thus departure time at this activity")
    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Activity waitingTime(Long waitingTime) {
        this.waitingTime = waitingTime;
        return this;
    }

    @ApiModelProperty(example="null", value="waiting time at this activity in ms")
    public Long getWaitingTime() {
        return this.waitingTime;
    }

    public void setWaitingTime(Long waitingTime) {
        this.waitingTime = waitingTime;
    }

    public Activity distance(Long distance) {
        this.distance = distance;
        return this;
    }

    @ApiModelProperty(example="null", value="cumulated distance from start to this activity in m")
    public Long getDistance() {
        return this.distance;
    }

    public void setDistance(Long distance) {
        this.distance = distance;
    }

    public Activity drivingTime(Long drivingTime) {
        this.drivingTime = drivingTime;
        return this;
    }

    @ApiModelProperty(example="null", value="driving time of driver in ms")
    public Long getDrivingTime() {
        return this.drivingTime;
    }

    public void setDrivingTime(Long drivingTime) {
        this.drivingTime = drivingTime;
    }

    public Activity loadBefore(List<Integer> loadBefore) {
        this.loadBefore = loadBefore;
        return this;
    }

    public Activity addLoadBeforeItem(Integer loadBeforeItem) {
        this.loadBefore.add(loadBeforeItem);
        return this;
    }

    @ApiModelProperty(example="null", value="Array with size/capacity dimensions before this activity")
    public List<Integer> getLoadBefore() {
        return this.loadBefore;
    }

    public void setLoadBefore(List<Integer> loadBefore) {
        this.loadBefore = loadBefore;
    }

    public Activity loadAfter(List<Integer> loadAfter) {
        this.loadAfter = loadAfter;
        return this;
    }

    public Activity addLoadAfterItem(Integer loadAfterItem) {
        this.loadAfter.add(loadAfterItem);
        return this;
    }

    @ApiModelProperty(example="null", value="Array with size/capacity dimensions after this activity")
    public List<Integer> getLoadAfter() {
        return this.loadAfter;
    }

    public void setLoadAfter(List<Integer> loadAfter) {
        this.loadAfter = loadAfter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Activity activity = (Activity)o;
        return Objects.equals((Object)this.type, (Object)activity.type) && Objects.equals(this.id, activity.id) && Objects.equals(this.locationId, activity.locationId) && Objects.equals(this.arrTime, activity.arrTime) && Objects.equals(this.endTime, activity.endTime) && Objects.equals(this.waitingTime, activity.waitingTime) && Objects.equals(this.distance, activity.distance) && Objects.equals(this.drivingTime, activity.drivingTime) && Objects.equals(this.loadBefore, activity.loadBefore) && Objects.equals(this.loadAfter, activity.loadAfter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id, this.locationId, this.arrTime, this.endTime, this.waitingTime, this.distance, this.drivingTime, this.loadBefore, this.loadAfter});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Activity {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        sb.append("    arrTime: ").append(this.toIndentedString(this.arrTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    waitingTime: ").append(this.toIndentedString(this.waitingTime)).append("\n");
        sb.append("    distance: ").append(this.toIndentedString(this.distance)).append("\n");
        sb.append("    drivingTime: ").append(this.toIndentedString(this.drivingTime)).append("\n");
        sb.append("    loadBefore: ").append(this.toIndentedString(this.loadBefore)).append("\n");
        sb.append("    loadAfter: ").append(this.toIndentedString(this.loadAfter)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        START("start"),
        END("end"),
        SERVICE("service"),
        PICKUPSHIPMENT("pickupShipment"),
        DELIVERSHIPMENT("deliverShipment"),
        PICKUP("pickup"),
        DELIVERY("delivery");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

