/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routeopt.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class Objective {
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="value")
    private ValueEnum value = null;

    public Objective type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="type of objective function, i.e. min or min-max ")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Objective value(ValueEnum value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="objective function value")
    public ValueEnum getValue() {
        return this.value;
    }

    public void setValue(ValueEnum value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Objective objective = (Objective)o;
        return Objects.equals((Object)this.type, (Object)objective.type) && Objects.equals((Object)this.value, (Object)objective.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Objective {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString((Object)this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ValueEnum {
        COMPLETION_TIME("completion_time"),
        TRANSPORT_TIME("transport_time"),
        VEHICLES("vehicles");

        private String value;

        private ValueEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum TypeEnum {
        MIN("min"),
        MIN_MAX("min-max");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

