/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routeopt.client.model;

import com.google.gson.annotations.SerializedName;
import com.graphhopper.routeopt.client.model.Algorithm;
import com.graphhopper.routeopt.client.model.CostMatrix;
import com.graphhopper.routeopt.client.model.Objective;
import com.graphhopper.routeopt.client.model.Relation;
import com.graphhopper.routeopt.client.model.Service;
import com.graphhopper.routeopt.client.model.Shipment;
import com.graphhopper.routeopt.client.model.Vehicle;
import com.graphhopper.routeopt.client.model.VehicleType;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Request {
    @SerializedName(value="vehicles")
    private List<Vehicle> vehicles = new ArrayList<Vehicle>();
    @SerializedName(value="vehicle_types")
    private List<VehicleType> vehicleTypes = new ArrayList<VehicleType>();
    @SerializedName(value="services")
    private List<Service> services = new ArrayList<Service>();
    @SerializedName(value="shipments")
    private List<Shipment> shipments = new ArrayList<Shipment>();
    @SerializedName(value="relations")
    private List<Relation> relations = new ArrayList<Relation>();
    @SerializedName(value="algorithm")
    private Algorithm algorithm = null;
    @SerializedName(value="objectives")
    private List<Objective> objectives = new ArrayList<Objective>();
    @SerializedName(value="cost_matrices")
    private List<CostMatrix> costMatrices = new ArrayList<CostMatrix>();

    public Request vehicles(List<Vehicle> vehicles) {
        this.vehicles = vehicles;
        return this;
    }

    public Request addVehiclesItem(Vehicle vehiclesItem) {
        this.vehicles.add(vehiclesItem);
        return this;
    }

    @ApiModelProperty(example="null", value="An array of vehicles that can be employed")
    public List<Vehicle> getVehicles() {
        return this.vehicles;
    }

    public void setVehicles(List<Vehicle> vehicles) {
        this.vehicles = vehicles;
    }

    public Request vehicleTypes(List<VehicleType> vehicleTypes) {
        this.vehicleTypes = vehicleTypes;
        return this;
    }

    public Request addVehicleTypesItem(VehicleType vehicleTypesItem) {
        this.vehicleTypes.add(vehicleTypesItem);
        return this;
    }

    @ApiModelProperty(example="null", value="An array of vehicle types")
    public List<VehicleType> getVehicleTypes() {
        return this.vehicleTypes;
    }

    public void setVehicleTypes(List<VehicleType> vehicleTypes) {
        this.vehicleTypes = vehicleTypes;
    }

    public Request services(List<Service> services) {
        this.services = services;
        return this;
    }

    public Request addServicesItem(Service servicesItem) {
        this.services.add(servicesItem);
        return this;
    }

    @ApiModelProperty(example="null", value="An array of services")
    public List<Service> getServices() {
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }

    public Request shipments(List<Shipment> shipments) {
        this.shipments = shipments;
        return this;
    }

    public Request addShipmentsItem(Shipment shipmentsItem) {
        this.shipments.add(shipmentsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="An array of shipments")
    public List<Shipment> getShipments() {
        return this.shipments;
    }

    public void setShipments(List<Shipment> shipments) {
        this.shipments = shipments;
    }

    public Request relations(List<Relation> relations) {
        this.relations = relations;
        return this;
    }

    public Request addRelationsItem(Relation relationsItem) {
        this.relations.add(relationsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="An array of relations")
    public List<Relation> getRelations() {
        return this.relations;
    }

    public void setRelations(List<Relation> relations) {
        this.relations = relations;
    }

    public Request algorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public Request objectives(List<Objective> objectives) {
        this.objectives = objectives;
        return this;
    }

    public Request addObjectivesItem(Objective objectivesItem) {
        this.objectives.add(objectivesItem);
        return this;
    }

    @ApiModelProperty(example="null", value="An array of objectives")
    public List<Objective> getObjectives() {
        return this.objectives;
    }

    public void setObjectives(List<Objective> objectives) {
        this.objectives = objectives;
    }

    public Request costMatrices(List<CostMatrix> costMatrices) {
        this.costMatrices = costMatrices;
        return this;
    }

    public Request addCostMatricesItem(CostMatrix costMatricesItem) {
        this.costMatrices.add(costMatricesItem);
        return this;
    }

    @ApiModelProperty(example="null", value="An array of cost matrices")
    public List<CostMatrix> getCostMatrices() {
        return this.costMatrices;
    }

    public void setCostMatrices(List<CostMatrix> costMatrices) {
        this.costMatrices = costMatrices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Request request = (Request)o;
        return Objects.equals(this.vehicles, request.vehicles) && Objects.equals(this.vehicleTypes, request.vehicleTypes) && Objects.equals(this.services, request.services) && Objects.equals(this.shipments, request.shipments) && Objects.equals(this.relations, request.relations) && Objects.equals(this.algorithm, request.algorithm) && Objects.equals(this.objectives, request.objectives) && Objects.equals(this.costMatrices, request.costMatrices);
    }

    public int hashCode() {
        return Objects.hash(this.vehicles, this.vehicleTypes, this.services, this.shipments, this.relations, this.algorithm, this.objectives, this.costMatrices);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Request {\n");
        sb.append("    vehicles: ").append(this.toIndentedString(this.vehicles)).append("\n");
        sb.append("    vehicleTypes: ").append(this.toIndentedString(this.vehicleTypes)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("    shipments: ").append(this.toIndentedString(this.shipments)).append("\n");
        sb.append("    relations: ").append(this.toIndentedString(this.relations)).append("\n");
        sb.append("    algorithm: ").append(this.toIndentedString(this.algorithm)).append("\n");
        sb.append("    objectives: ").append(this.toIndentedString(this.objectives)).append("\n");
        sb.append("    costMatrices: ").append(this.toIndentedString(this.costMatrices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

