/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routeopt.client.model;

import com.google.gson.annotations.SerializedName;
import com.graphhopper.routeopt.client.model.Activity;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Route {
    @SerializedName(value="vehicle_id")
    private String vehicleId = null;
    @SerializedName(value="distance")
    private Long distance = null;
    @SerializedName(value="transport_time")
    private Long transportTime = null;
    @SerializedName(value="completion_time")
    private Long completionTime = null;
    @SerializedName(value="waiting_time")
    private Long waitingTime = null;
    @SerializedName(value="activities")
    private List<Activity> activities = new ArrayList<Activity>();

    public Route vehicleId(String vehicleId) {
        this.vehicleId = vehicleId;
        return this;
    }

    @ApiModelProperty(example="null", value="id of vehicle that operates route")
    public String getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(String vehicleId) {
        this.vehicleId = vehicleId;
    }

    public Route distance(Long distance) {
        this.distance = distance;
        return this;
    }

    @ApiModelProperty(example="null", value="distance of route in meter")
    public Long getDistance() {
        return this.distance;
    }

    public void setDistance(Long distance) {
        this.distance = distance;
    }

    public Route transportTime(Long transportTime) {
        this.transportTime = transportTime;
        return this;
    }

    @ApiModelProperty(example="null", value="transport time of route in ms")
    public Long getTransportTime() {
        return this.transportTime;
    }

    public void setTransportTime(Long transportTime) {
        this.transportTime = transportTime;
    }

    public Route completionTime(Long completionTime) {
        this.completionTime = completionTime;
        return this;
    }

    @ApiModelProperty(example="null", value="completion time of route in ms")
    public Long getCompletionTime() {
        return this.completionTime;
    }

    public void setCompletionTime(Long completionTime) {
        this.completionTime = completionTime;
    }

    public Route waitingTime(Long waitingTime) {
        this.waitingTime = waitingTime;
        return this;
    }

    @ApiModelProperty(example="null", value="waiting time of route in ms")
    public Long getWaitingTime() {
        return this.waitingTime;
    }

    public void setWaitingTime(Long waitingTime) {
        this.waitingTime = waitingTime;
    }

    public Route activities(List<Activity> activities) {
        this.activities = activities;
        return this;
    }

    public Route addActivitiesItem(Activity activitiesItem) {
        this.activities.add(activitiesItem);
        return this;
    }

    @ApiModelProperty(example="null", value="array of activities")
    public List<Activity> getActivities() {
        return this.activities;
    }

    public void setActivities(List<Activity> activities) {
        this.activities = activities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Route route = (Route)o;
        return Objects.equals(this.vehicleId, route.vehicleId) && Objects.equals(this.distance, route.distance) && Objects.equals(this.transportTime, route.transportTime) && Objects.equals(this.completionTime, route.completionTime) && Objects.equals(this.waitingTime, route.waitingTime) && Objects.equals(this.activities, route.activities);
    }

    public int hashCode() {
        return Objects.hash(this.vehicleId, this.distance, this.transportTime, this.completionTime, this.waitingTime, this.activities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Route {\n");
        sb.append("    vehicleId: ").append(this.toIndentedString(this.vehicleId)).append("\n");
        sb.append("    distance: ").append(this.toIndentedString(this.distance)).append("\n");
        sb.append("    transportTime: ").append(this.toIndentedString(this.transportTime)).append("\n");
        sb.append("    completionTime: ").append(this.toIndentedString(this.completionTime)).append("\n");
        sb.append("    waitingTime: ").append(this.toIndentedString(this.waitingTime)).append("\n");
        sb.append("    activities: ").append(this.toIndentedString(this.activities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

