/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routeopt.client.model;

import com.google.gson.annotations.SerializedName;
import com.graphhopper.routeopt.client.model.Address;
import com.graphhopper.routeopt.client.model.TimeWindow;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Service {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="priority")
    private Integer priority = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="address")
    private Address address = null;
    @SerializedName(value="duration")
    private Long duration = null;
    @SerializedName(value="time_windows")
    private List<TimeWindow> timeWindows = new ArrayList<TimeWindow>();
    @SerializedName(value="size")
    private List<Integer> size = new ArrayList<Integer>();
    @SerializedName(value="required_skills")
    private List<String> requiredSkills = new ArrayList<String>();
    @SerializedName(value="allowed_vehicles")
    private List<String> allowedVehicles = new ArrayList<String>();

    public Service id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier of service")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Service type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="type of service")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Service priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(example="null", value="priority of service, i.e. 1 = high, 2 = normal, 3 = low. default is 2.")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Service name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="name of service")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Service address(Address address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Service duration(Long duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(example="null", value="duration of service, i.e. time in ms the corresponding activity takes")
    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public Service timeWindows(List<TimeWindow> timeWindows) {
        this.timeWindows = timeWindows;
        return this;
    }

    public Service addTimeWindowsItem(TimeWindow timeWindowsItem) {
        this.timeWindows.add(timeWindowsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="array of time windows. currently, only a single time window is allowed")
    public List<TimeWindow> getTimeWindows() {
        return this.timeWindows;
    }

    public void setTimeWindows(List<TimeWindow> timeWindows) {
        this.timeWindows = timeWindows;
    }

    public Service size(List<Integer> size) {
        this.size = size;
        return this;
    }

    public Service addSizeItem(Integer sizeItem) {
        this.size.add(sizeItem);
        return this;
    }

    @ApiModelProperty(example="null", value="array of capacity dimensions")
    public List<Integer> getSize() {
        return this.size;
    }

    public void setSize(List<Integer> size) {
        this.size = size;
    }

    public Service requiredSkills(List<String> requiredSkills) {
        this.requiredSkills = requiredSkills;
        return this;
    }

    public Service addRequiredSkillsItem(String requiredSkillsItem) {
        this.requiredSkills.add(requiredSkillsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="array of required skills")
    public List<String> getRequiredSkills() {
        return this.requiredSkills;
    }

    public void setRequiredSkills(List<String> requiredSkills) {
        this.requiredSkills = requiredSkills;
    }

    public Service allowedVehicles(List<String> allowedVehicles) {
        this.allowedVehicles = allowedVehicles;
        return this;
    }

    public Service addAllowedVehiclesItem(String allowedVehiclesItem) {
        this.allowedVehicles.add(allowedVehiclesItem);
        return this;
    }

    @ApiModelProperty(example="null", value="array of allowed vehicle ids")
    public List<String> getAllowedVehicles() {
        return this.allowedVehicles;
    }

    public void setAllowedVehicles(List<String> allowedVehicles) {
        this.allowedVehicles = allowedVehicles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service service = (Service)o;
        return Objects.equals(this.id, service.id) && Objects.equals((Object)this.type, (Object)service.type) && Objects.equals(this.priority, service.priority) && Objects.equals(this.name, service.name) && Objects.equals(this.address, service.address) && Objects.equals(this.duration, service.duration) && Objects.equals(this.timeWindows, service.timeWindows) && Objects.equals(this.size, service.size) && Objects.equals(this.requiredSkills, service.requiredSkills) && Objects.equals(this.allowedVehicles, service.allowedVehicles);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.priority, this.name, this.address, this.duration, this.timeWindows, this.size, this.requiredSkills, this.allowedVehicles});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Service {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    timeWindows: ").append(this.toIndentedString(this.timeWindows)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    requiredSkills: ").append(this.toIndentedString(this.requiredSkills)).append("\n");
        sb.append("    allowedVehicles: ").append(this.toIndentedString(this.allowedVehicles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        SERVICE("service"),
        PICKUP("pickup"),
        DELIVERY("delivery");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

