/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routeopt.client.model;

import com.google.gson.annotations.SerializedName;
import com.graphhopper.routeopt.client.model.Stop;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Shipment {
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="priority")
    private Integer priority = null;
    @SerializedName(value="pickup")
    private Stop pickup = null;
    @SerializedName(value="delivery")
    private Stop delivery = null;
    @SerializedName(value="size")
    private List<Integer> size = new ArrayList<Integer>();
    @SerializedName(value="required_skills")
    private List<String> requiredSkills = new ArrayList<String>();
    @SerializedName(value="allowed_vehicles")
    private List<String> allowedVehicles = new ArrayList<String>();

    public Shipment id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier of service")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Shipment name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="name of shipment")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Shipment priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(example="null", value="priority of service, i.e. 1 = high, 2 = normal, 3 = low. default is 2.")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Shipment pickup(Stop pickup) {
        this.pickup = pickup;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Stop getPickup() {
        return this.pickup;
    }

    public void setPickup(Stop pickup) {
        this.pickup = pickup;
    }

    public Shipment delivery(Stop delivery) {
        this.delivery = delivery;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Stop getDelivery() {
        return this.delivery;
    }

    public void setDelivery(Stop delivery) {
        this.delivery = delivery;
    }

    public Shipment size(List<Integer> size) {
        this.size = size;
        return this;
    }

    public Shipment addSizeItem(Integer sizeItem) {
        this.size.add(sizeItem);
        return this;
    }

    @ApiModelProperty(example="null", value="array of capacity dimensions")
    public List<Integer> getSize() {
        return this.size;
    }

    public void setSize(List<Integer> size) {
        this.size = size;
    }

    public Shipment requiredSkills(List<String> requiredSkills) {
        this.requiredSkills = requiredSkills;
        return this;
    }

    public Shipment addRequiredSkillsItem(String requiredSkillsItem) {
        this.requiredSkills.add(requiredSkillsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="array of required skills")
    public List<String> getRequiredSkills() {
        return this.requiredSkills;
    }

    public void setRequiredSkills(List<String> requiredSkills) {
        this.requiredSkills = requiredSkills;
    }

    public Shipment allowedVehicles(List<String> allowedVehicles) {
        this.allowedVehicles = allowedVehicles;
        return this;
    }

    public Shipment addAllowedVehiclesItem(String allowedVehiclesItem) {
        this.allowedVehicles.add(allowedVehiclesItem);
        return this;
    }

    @ApiModelProperty(example="null", value="array of allowed vehicle ids")
    public List<String> getAllowedVehicles() {
        return this.allowedVehicles;
    }

    public void setAllowedVehicles(List<String> allowedVehicles) {
        this.allowedVehicles = allowedVehicles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Shipment shipment = (Shipment)o;
        return Objects.equals(this.id, shipment.id) && Objects.equals(this.name, shipment.name) && Objects.equals(this.priority, shipment.priority) && Objects.equals(this.pickup, shipment.pickup) && Objects.equals(this.delivery, shipment.delivery) && Objects.equals(this.size, shipment.size) && Objects.equals(this.requiredSkills, shipment.requiredSkills) && Objects.equals(this.allowedVehicles, shipment.allowedVehicles);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.priority, this.pickup, this.delivery, this.size, this.requiredSkills, this.allowedVehicles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Shipment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    pickup: ").append(this.toIndentedString(this.pickup)).append("\n");
        sb.append("    delivery: ").append(this.toIndentedString(this.delivery)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    requiredSkills: ").append(this.toIndentedString(this.requiredSkills)).append("\n");
        sb.append("    allowedVehicles: ").append(this.toIndentedString(this.allowedVehicles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

