/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routeopt.client.model;

import com.google.gson.annotations.SerializedName;
import com.graphhopper.routeopt.client.model.Address;
import com.graphhopper.routeopt.client.model.ModelBreak;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Vehicle {
    @SerializedName(value="vehicle_id")
    private String vehicleId = null;
    @SerializedName(value="type_id")
    private String typeId = null;
    @SerializedName(value="start_address")
    private Address startAddress = null;
    @SerializedName(value="end_address")
    private Address endAddress = null;
    @SerializedName(value="break")
    private ModelBreak _break = null;
    @SerializedName(value="return_to_depot")
    private Boolean returnToDepot = null;
    @SerializedName(value="earliest_start")
    private Long earliestStart = null;
    @SerializedName(value="latest_end")
    private Long latestEnd = null;
    @SerializedName(value="skills")
    private List<String> skills = new ArrayList<String>();

    public Vehicle vehicleId(String vehicleId) {
        this.vehicleId = vehicleId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier of vehicle")
    public String getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(String vehicleId) {
        this.vehicleId = vehicleId;
    }

    public Vehicle typeId(String typeId) {
        this.typeId = typeId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier referring to the available vehicle types")
    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public Vehicle startAddress(Address startAddress) {
        this.startAddress = startAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Address getStartAddress() {
        return this.startAddress;
    }

    public void setStartAddress(Address startAddress) {
        this.startAddress = startAddress;
    }

    public Vehicle endAddress(Address endAddress) {
        this.endAddress = endAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Address getEndAddress() {
        return this.endAddress;
    }

    public void setEndAddress(Address endAddress) {
        this.endAddress = endAddress;
    }

    public Vehicle _break(ModelBreak _break) {
        this._break = _break;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public ModelBreak getBreak() {
        return this._break;
    }

    public void setBreak(ModelBreak _break) {
        this._break = _break;
    }

    public Vehicle returnToDepot(Boolean returnToDepot) {
        this.returnToDepot = returnToDepot;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether vehicle should return to start address or not. If not, it can end at any service activity.")
    public Boolean getReturnToDepot() {
        return this.returnToDepot;
    }

    public void setReturnToDepot(Boolean returnToDepot) {
        this.returnToDepot = returnToDepot;
    }

    public Vehicle earliestStart(Long earliestStart) {
        this.earliestStart = earliestStart;
        return this;
    }

    @ApiModelProperty(example="null", value="earliest start of vehicle at its start location")
    public Long getEarliestStart() {
        return this.earliestStart;
    }

    public void setEarliestStart(Long earliestStart) {
        this.earliestStart = earliestStart;
    }

    public Vehicle latestEnd(Long latestEnd) {
        this.latestEnd = latestEnd;
        return this;
    }

    @ApiModelProperty(example="null", value="latest end of vehicle at its end location")
    public Long getLatestEnd() {
        return this.latestEnd;
    }

    public void setLatestEnd(Long latestEnd) {
        this.latestEnd = latestEnd;
    }

    public Vehicle skills(List<String> skills) {
        this.skills = skills;
        return this;
    }

    public Vehicle addSkillsItem(String skillsItem) {
        this.skills.add(skillsItem);
        return this;
    }

    @ApiModelProperty(example="null", value="array of skills")
    public List<String> getSkills() {
        return this.skills;
    }

    public void setSkills(List<String> skills) {
        this.skills = skills;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vehicle vehicle = (Vehicle)o;
        return Objects.equals(this.vehicleId, vehicle.vehicleId) && Objects.equals(this.typeId, vehicle.typeId) && Objects.equals(this.startAddress, vehicle.startAddress) && Objects.equals(this.endAddress, vehicle.endAddress) && Objects.equals(this._break, vehicle._break) && Objects.equals(this.returnToDepot, vehicle.returnToDepot) && Objects.equals(this.earliestStart, vehicle.earliestStart) && Objects.equals(this.latestEnd, vehicle.latestEnd) && Objects.equals(this.skills, vehicle.skills);
    }

    public int hashCode() {
        return Objects.hash(this.vehicleId, this.typeId, this.startAddress, this.endAddress, this._break, this.returnToDepot, this.earliestStart, this.latestEnd, this.skills);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Vehicle {\n");
        sb.append("    vehicleId: ").append(this.toIndentedString(this.vehicleId)).append("\n");
        sb.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        sb.append("    startAddress: ").append(this.toIndentedString(this.startAddress)).append("\n");
        sb.append("    endAddress: ").append(this.toIndentedString(this.endAddress)).append("\n");
        sb.append("    _break: ").append(this.toIndentedString(this._break)).append("\n");
        sb.append("    returnToDepot: ").append(this.toIndentedString(this.returnToDepot)).append("\n");
        sb.append("    earliestStart: ").append(this.toIndentedString(this.earliestStart)).append("\n");
        sb.append("    latestEnd: ").append(this.toIndentedString(this.latestEnd)).append("\n");
        sb.append("    skills: ").append(this.toIndentedString(this.skills)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

