/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routeopt.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class VehicleType {
    @SerializedName(value="type_id")
    private String typeId = null;
    @SerializedName(value="profile")
    private ProfileEnum profile = null;
    @SerializedName(value="capacity")
    private List<Integer> capacity = new ArrayList<Integer>();
    @SerializedName(value="speed_factor")
    private Double speedFactor = null;
    @SerializedName(value="service_time_factor")
    private Double serviceTimeFactor = null;

    public VehicleType typeId(String typeId) {
        this.typeId = typeId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the vehicle type")
    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public VehicleType profile(ProfileEnum profile) {
        this.profile = profile;
        return this;
    }

    @ApiModelProperty(example="car", value="Profile of vehicle type")
    public ProfileEnum getProfile() {
        return this.profile;
    }

    public void setProfile(ProfileEnum profile) {
        this.profile = profile;
    }

    public VehicleType capacity(List<Integer> capacity) {
        this.capacity = capacity;
        return this;
    }

    public VehicleType addCapacityItem(Integer capacityItem) {
        this.capacity.add(capacityItem);
        return this;
    }

    @ApiModelProperty(example="null", value="array of capacity dimensions")
    public List<Integer> getCapacity() {
        return this.capacity;
    }

    public void setCapacity(List<Integer> capacity) {
        this.capacity = capacity;
    }

    public VehicleType speedFactor(Double speedFactor) {
        this.speedFactor = speedFactor;
        return this;
    }

    @ApiModelProperty(example="null", value="speed_factor of vehicle type")
    public Double getSpeedFactor() {
        return this.speedFactor;
    }

    public void setSpeedFactor(Double speedFactor) {
        this.speedFactor = speedFactor;
    }

    public VehicleType serviceTimeFactor(Double serviceTimeFactor) {
        this.serviceTimeFactor = serviceTimeFactor;
        return this;
    }

    @ApiModelProperty(example="null", value="service time factor of vehicle type")
    public Double getServiceTimeFactor() {
        return this.serviceTimeFactor;
    }

    public void setServiceTimeFactor(Double serviceTimeFactor) {
        this.serviceTimeFactor = serviceTimeFactor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleType vehicleType = (VehicleType)o;
        return Objects.equals(this.typeId, vehicleType.typeId) && Objects.equals((Object)this.profile, (Object)vehicleType.profile) && Objects.equals(this.capacity, vehicleType.capacity) && Objects.equals(this.speedFactor, vehicleType.speedFactor) && Objects.equals(this.serviceTimeFactor, vehicleType.serviceTimeFactor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.typeId, this.profile, this.capacity, this.speedFactor, this.serviceTimeFactor});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VehicleType {\n");
        sb.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString((Object)this.profile)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    speedFactor: ").append(this.toIndentedString(this.speedFactor)).append("\n");
        sb.append("    serviceTimeFactor: ").append(this.toIndentedString(this.serviceTimeFactor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProfileEnum {
        CAR("car"),
        BIKE("bike"),
        FOOT("foot"),
        MTB("mtb"),
        MOTORCYCLE("motorcycle"),
        RACINGBIKE("racingbike"),
        TRUCK("truck"),
        SMALL_TRUCK("small_truck"),
        BUS("bus");

        private String value;

        private ProfileEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

