/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routeopt.examples;

import com.graphhopper.routeopt.client.api.SolutionApi;
import com.graphhopper.routeopt.client.api.VrpApi;
import com.graphhopper.routeopt.client.model.Address;
import com.graphhopper.routeopt.client.model.Algorithm;
import com.graphhopper.routeopt.client.model.JobId;
import com.graphhopper.routeopt.client.model.Request;
import com.graphhopper.routeopt.client.model.Response;
import com.graphhopper.routeopt.client.model.Service;
import com.graphhopper.routeopt.client.model.Vehicle;
import java.util.ArrayList;

public class TSP_BiggestCitiesInGermanyExample {
    public static void main(String[] args) throws Exception {
        new TSP_BiggestCitiesInGermanyExample().start();
    }

    private void start() throws Exception {
        Response rsp;
        Request request = this.createRequest();
        VrpApi vrpApi = new VrpApi();
        String key = System.getProperty("graphhopper.key", "");
        JobId jobId = vrpApi.postVrp(key, request);
        System.out.println(this.getClass() + ", jobId: " + jobId.getJobId());
        SolutionApi solApi = new SolutionApi();
        while (!(rsp = solApi.getSolution(key, jobId.getJobId())).getStatus().equals((Object)Response.StatusEnum.FINISHED)) {
            Thread.sleep(200L);
        }
        System.out.println(rsp);
    }

    private Request createRequest() {
        Request request = new Request();
        request.setAlgorithm(new Algorithm());
        ArrayList<Vehicle> vehicles = new ArrayList<Vehicle>();
        Vehicle v = new Vehicle();
        v.setVehicleId("v1");
        v.setStartAddress(this.createAddress("berlin", 52.537, 13.406));
        vehicles.add(v);
        request.setVehicles(vehicles);
        ArrayList<Service> services = new ArrayList<Service>();
        services.add(this.createService("hamburg", 53.552, 9.999));
        services.add(this.createService("munich", 48.145, 11.57));
        services.add(this.createService("cologne", 50.936, 6.957));
        services.add(this.createService("frankfurt", 50.109, 8.67));
        request.setServices(services);
        return request;
    }

    public Address createAddress(String locationId, double lat, double lon) {
        Address a = new Address();
        a.setLat(lat);
        a.setLon(lon);
        a.setLocationId(locationId);
        return a;
    }

    public Service createService(String id, double lat, double lon) {
        Service service = new Service();
        service.setId(id);
        service.setType(Service.TypeEnum.SERVICE);
        service.setAddress(this.createAddress(id, lat, lon));
        return service;
    }
}

