/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.isochrone.algorithm;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.AbstractRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.GHUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.function.Consumer;

public class ShortestPathTree
extends AbstractRoutingAlgorithm {
    private final IntObjectHashMap<IsoLabel> fromMap;
    private final PriorityQueue<IsoLabel> queueByWeighting;
    private PriorityQueue<IsoLabel> queueByZ;
    private int visitedNodes;
    private double limit = -1.0;
    private ExploreType exploreType = ExploreType.TIME;
    private final boolean reverseFlow;

    public ShortestPathTree(Graph g, Weighting weighting, boolean reverseFlow, TraversalMode traversalMode) {
        super(g, weighting, traversalMode);
        this.queueByWeighting = new PriorityQueue<IsoLabel>(1000, Comparator.comparingDouble(l -> l.weight));
        this.queueByZ = new PriorityQueue(1000);
        this.fromMap = new GHIntObjectHashMap<IsoLabel>(1000);
        this.reverseFlow = reverseFlow;
    }

    @Override
    public Path calcPath(int from, int to) {
        throw new IllegalStateException("call search instead");
    }

    public void setTimeLimit(double limit) {
        this.exploreType = ExploreType.TIME;
        this.limit = limit;
        this.queueByZ = new PriorityQueue<IsoLabel>(1000, Comparator.comparingLong(l -> l.time));
    }

    public void setDistanceLimit(double limit) {
        this.exploreType = ExploreType.DISTANCE;
        this.limit = limit;
        this.queueByZ = new PriorityQueue<IsoLabel>(1000, Comparator.comparingDouble(l -> l.distance));
    }

    public void setWeightLimit(double limit) {
        this.exploreType = ExploreType.WEIGHT;
        this.limit = limit;
        this.queueByZ = new PriorityQueue<IsoLabel>(1000, Comparator.comparingDouble(l -> l.weight));
    }

    public void search(int from, Consumer<IsoLabel> consumer) {
        this.checkAlreadyRun();
        IsoLabel currentLabel = new IsoLabel(from, -1, 0.0, 0L, 0.0, null);
        this.queueByWeighting.add(currentLabel);
        this.queueByZ.add(currentLabel);
        if (this.traversalMode == TraversalMode.NODE_BASED) {
            this.fromMap.put(from, (Object)currentLabel);
        }
        while (!this.finished()) {
            currentLabel = this.queueByWeighting.poll();
            if (currentLabel.deleted) continue;
            if (this.getExploreValue(currentLabel) <= this.limit) {
                consumer.accept(currentLabel);
            }
            currentLabel.deleted = true;
            ++this.visitedNodes;
            EdgeIterator iter = this.edgeExplorer.setBaseNode(currentLabel.node);
            while (iter.next()) {
                double nextWeight;
                if (!this.accept(iter, currentLabel.edge) || Double.isInfinite(nextWeight = GHUtility.calcWeightWithTurnWeight(this.weighting, iter, this.reverseFlow, currentLabel.edge) + currentLabel.weight)) continue;
                double nextDistance = iter.getDistance() + currentLabel.distance;
                long nextTime = GHUtility.calcMillisWithTurnMillis(this.weighting, iter, this.reverseFlow, currentLabel.edge) + currentLabel.time;
                int nextTraversalId = this.traversalMode.createTraversalId(iter, this.reverseFlow);
                IsoLabel nextLabel = (IsoLabel)this.fromMap.get(nextTraversalId);
                if (nextLabel == null) {
                    nextLabel = new IsoLabel(iter.getAdjNode(), iter.getEdge(), nextWeight, nextTime, nextDistance, currentLabel);
                    this.fromMap.put(nextTraversalId, (Object)nextLabel);
                    this.queueByWeighting.add(nextLabel);
                    this.queueByZ.add(nextLabel);
                    continue;
                }
                if (!(nextLabel.weight > nextWeight)) continue;
                nextLabel.deleted = true;
                nextLabel = new IsoLabel(iter.getAdjNode(), iter.getEdge(), nextWeight, nextTime, nextDistance, currentLabel);
                this.fromMap.put(nextTraversalId, (Object)nextLabel);
                this.queueByWeighting.add(nextLabel);
                this.queueByZ.add(nextLabel);
            }
        }
    }

    public Collection<IsoLabel> getIsochroneEdges() {
        return this.getIsochroneEdges(this.limit);
    }

    public ArrayList<IsoLabel> getIsochroneEdges(double z) {
        ArrayList<IsoLabel> result = new ArrayList<IsoLabel>();
        for (ObjectCursor cursor : this.fromMap.values()) {
            if (((IsoLabel)cursor.value).parent == null || !(this.getExploreValue((IsoLabel)cursor.value) > z ^ this.getExploreValue(((IsoLabel)cursor.value).parent) > z)) continue;
            result.add((IsoLabel)cursor.value);
        }
        return result;
    }

    private double getExploreValue(IsoLabel label) {
        if (this.exploreType == ExploreType.TIME) {
            return label.time;
        }
        if (this.exploreType == ExploreType.WEIGHT) {
            return label.weight;
        }
        return label.distance;
    }

    protected boolean finished() {
        while (this.queueByZ.peek() != null && this.queueByZ.peek().deleted) {
            this.queueByZ.poll();
        }
        if (this.queueByZ.peek() == null) {
            return true;
        }
        return this.getExploreValue(this.queueByZ.peek()) >= this.limit;
    }

    @Override
    public String getName() {
        return "reachability";
    }

    @Override
    public int getVisitedNodes() {
        return this.visitedNodes;
    }

    public static class IsoLabel {
        public boolean deleted = false;
        public int node;
        public int edge;
        public double weight;
        public long time;
        public double distance;
        public IsoLabel parent;

        IsoLabel(int node, int edge, double weight, long time, double distance, IsoLabel parent) {
            this.node = node;
            this.edge = edge;
            this.weight = weight;
            this.time = time;
            this.distance = distance;
            this.parent = parent;
        }

        public String toString() {
            return "IsoLabel{node=" + this.node + ", edge=" + this.edge + ", weight=" + this.weight + ", time=" + this.time + ", distance=" + this.distance + '}';
        }
    }

    static enum ExploreType {
        TIME,
        DISTANCE,
        WEIGHT;

    }
}

