/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.isochrone.algorithm;

import com.graphhopper.isochrone.algorithm.ReadableQuadEdge;
import com.graphhopper.isochrone.algorithm.ReadableTriangulation;
import com.graphhopper.isochrone.algorithm.Triangulation;
import java.util.Collection;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;

public class TriangulationAsReadableTriangulation
implements ReadableTriangulation {
    private final Triangulation triangulation;

    public TriangulationAsReadableTriangulation(Triangulation triangulation) {
        this.triangulation = triangulation;
    }

    @Override
    public Collection<ReadableQuadEdge> getEdges() {
        return this.triangulation.getEdges();
    }

    @Override
    public ReadableQuadEdge getEdge(int o, int d) {
        return ReadableQuadEdge.wrap(this.triangulation.getEdge(o, d));
    }

    @Override
    public ReadableQuadEdge getVertexQuadEdge(int v) {
        QuadEdge edge = (QuadEdge)this.triangulation.vertexQuadEdges.get(v);
        return edge != null ? ReadableQuadEdge.wrap(edge) : null;
    }
}

