/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.PointList;

public class EdgeElevationSmoothingRamer {
    public static void smooth(PointList pointList, double maxElevationDelta) {
        EdgeElevationSmoothingRamer.internSmooth(pointList, 0, pointList.size() - 1, maxElevationDelta);
    }

    static void internSmooth(PointList pointList, int fromIndex, int lastIndex, double maxElevationDelta) {
        double lon;
        double lat;
        int i;
        double prevLon;
        if (lastIndex - fromIndex < 2) {
            return;
        }
        double prevLat = pointList.getLat(fromIndex);
        double dist2D = DistanceCalcEarth.DIST_EARTH.calcDist(prevLat, prevLon = pointList.getLon(fromIndex), pointList.getLat(lastIndex), pointList.getLon(lastIndex));
        double averageSlope = dist2D == 0.0 ? 0.0 : (pointList.getEle(lastIndex) - pointList.getEle(fromIndex)) / dist2D;
        double prevAverageSlopeEle = pointList.getEle(fromIndex);
        double maxEleDelta = -1.0;
        int indexWithMaxDelta = -1;
        for (i = fromIndex + 1; i < lastIndex; ++i) {
            double tmpDist2D;
            double eleFromAverageSlope;
            lat = pointList.getLat(i);
            lon = pointList.getLon(i);
            double ele = pointList.getEle(i);
            double tmpEleDelta = Math.abs(ele - (eleFromAverageSlope = averageSlope * (tmpDist2D = DistanceCalcEarth.DIST_EARTH.calcDist(prevLat, prevLon, lat, lon)) + prevAverageSlopeEle));
            if (maxEleDelta < tmpEleDelta) {
                indexWithMaxDelta = i;
                maxEleDelta = tmpEleDelta;
            }
            prevAverageSlopeEle = eleFromAverageSlope;
            prevLat = lat;
            prevLon = lon;
        }
        if (indexWithMaxDelta < 0 || maxElevationDelta > maxEleDelta) {
            prevLat = pointList.getLat(fromIndex);
            prevLon = pointList.getLon(fromIndex);
            prevAverageSlopeEle = pointList.getEle(fromIndex);
            for (i = fromIndex + 1; i < lastIndex; ++i) {
                lat = pointList.getLat(i);
                lon = pointList.getLon(i);
                double tmpDist2D = DistanceCalcEarth.DIST_EARTH.calcDist(prevLat, prevLon, lat, lon);
                double eleFromAverageSlope = averageSlope * tmpDist2D + prevAverageSlopeEle;
                pointList.setElevation(i, eleFromAverageSlope);
                prevAverageSlopeEle = eleFromAverageSlope;
                prevLat = lat;
                prevLon = lon;
            }
        } else {
            EdgeElevationSmoothingRamer.internSmooth(pointList, fromIndex, indexWithMaxDelta, maxElevationDelta);
            EdgeElevationSmoothingRamer.internSmooth(pointList, indexWithMaxDelta, lastIndex, maxElevationDelta);
        }
    }
}

