/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.AStar;
import com.graphhopper.routing.AbstractBidirCHAlgo;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.BalancedWeightApproximator;
import com.graphhopper.routing.weighting.BeelineWeightApproximator;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.storage.RoutingCHEdgeIteratorState;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.util.DistancePlaneProjection;

public class AStarBidirectionCH
extends AbstractBidirCHAlgo {
    private BalancedWeightApproximator weightApprox;

    public AStarBidirectionCH(RoutingCHGraph graph) {
        super(graph, TraversalMode.NODE_BASED);
        BeelineWeightApproximator defaultApprox = new BeelineWeightApproximator(this.nodeAccess, graph.getWeighting());
        defaultApprox.setDistanceCalc(DistancePlaneProjection.DIST_PLANE);
        this.setApproximation(defaultApprox);
    }

    @Override
    void init(int from, double fromWeight, int to, double toWeight) {
        this.weightApprox.setFromTo(from, to);
        super.init(from, fromWeight, to, toWeight);
    }

    @Override
    protected SPTEntry createStartEntry(int node, double weight, boolean reverse) {
        double heapWeight = weight + this.weightApprox.approximate(node, reverse);
        return new AStar.AStarEntry(-1, node, heapWeight, weight);
    }

    @Override
    protected SPTEntry createEntry(int edge, int adjNode, int incEdge, double weight, SPTEntry parent, boolean reverse) {
        double heapWeight = weight + this.weightApprox.approximate(adjNode, reverse);
        return new AStar.AStarEntry(edge, adjNode, heapWeight, weight, parent);
    }

    @Override
    protected void updateEntry(SPTEntry entry, int edge, int adjNode, int incEdge, double weight, SPTEntry parent, boolean reverse) {
        entry.edge = edge;
        entry.weight = weight + this.weightApprox.approximate(adjNode, reverse);
        ((AStar.AStarEntry)entry).weightOfVisitedPath = weight;
        entry.parent = parent;
    }

    @Override
    protected double calcWeight(RoutingCHEdgeIteratorState iter, SPTEntry currEdge, boolean reverse) {
        return super.calcWeight(iter, currEdge, reverse);
    }

    public WeightApproximator getApproximation() {
        return this.weightApprox.getApproximation();
    }

    public AStarBidirectionCH setApproximation(WeightApproximator approx) {
        this.weightApprox = new BalancedWeightApproximator(approx);
        return this;
    }

    @Override
    public String getName() {
        return "astarbi|ch";
    }
}

