/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.EdgeRestrictions;
import com.graphhopper.routing.EdgeToEdgeRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.PathCalculator;
import com.graphhopper.routing.ch.CHRoutingAlgorithmFactory;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.exceptions.MaximumNodesExceededException;
import java.util.Collections;
import java.util.List;

public class CHPathCalculator
implements PathCalculator {
    private final CHRoutingAlgorithmFactory algoFactory;
    private final PMap algoOpts;
    private String debug;
    private int visitedNodes;

    public CHPathCalculator(CHRoutingAlgorithmFactory algoFactory, PMap algoOpts) {
        this.algoFactory = algoFactory;
        this.algoOpts = algoOpts;
    }

    @Override
    public List<Path> calcPaths(int from, int to, EdgeRestrictions edgeRestrictions) {
        if (!edgeRestrictions.getUnfavoredEdges().isEmpty()) {
            throw new IllegalArgumentException("Using unfavored edges is currently not supported for CH");
        }
        EdgeToEdgeRoutingAlgorithm algo = this.createAlgo();
        return this.calcPaths(from, to, edgeRestrictions, algo);
    }

    private EdgeToEdgeRoutingAlgorithm createAlgo() {
        StopWatch sw = new StopWatch().start();
        EdgeToEdgeRoutingAlgorithm algo = this.algoFactory.createAlgo(this.algoOpts);
        this.debug = ", algoInit:" + sw.stop().getNanos() / 1000L + " \u03bcs";
        return algo;
    }

    private List<Path> calcPaths(int from, int to, EdgeRestrictions edgeRestrictions, EdgeToEdgeRoutingAlgorithm algo) {
        StopWatch sw = new StopWatch().start();
        List<Path> paths = edgeRestrictions.getSourceOutEdge() != -2 || edgeRestrictions.getTargetInEdge() != -2 ? Collections.singletonList(algo.calcPath(from, to, edgeRestrictions.getSourceOutEdge(), edgeRestrictions.getTargetInEdge())) : algo.calcPaths(from, to);
        if (paths.isEmpty()) {
            throw new IllegalStateException("Path list was empty for " + from + " -> " + to);
        }
        int maxVisitedNodes = this.algoOpts.getInt("max_visited_nodes", Integer.MAX_VALUE);
        if (algo.getVisitedNodes() >= maxVisitedNodes) {
            throw new MaximumNodesExceededException("No path found due to maximum nodes exceeded " + maxVisitedNodes, maxVisitedNodes);
        }
        this.visitedNodes = algo.getVisitedNodes();
        this.debug = this.debug + ", " + algo.getName() + "-routing:" + sw.stop().getMillis() + " ms";
        return paths;
    }

    @Override
    public String getDebugString() {
        return this.debug;
    }

    @Override
    public int getVisitedNodes() {
        return this.visitedNodes;
    }
}

