/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.config.Profile;
import com.graphhopper.routing.WeightingFactory;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.TurnRestriction;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.VehicleEncodedValues;
import com.graphhopper.routing.weighting.DefaultTurnCostProvider;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.routing.weighting.custom.CustomModelParser;
import com.graphhopper.routing.weighting.custom.CustomWeighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;

public class DefaultWeightingFactory
implements WeightingFactory {
    private final BaseGraph graph;
    private final EncodingManager encodingManager;

    public DefaultWeightingFactory(BaseGraph graph, EncodingManager encodingManager) {
        this.graph = graph;
        this.encodingManager = encodingManager;
    }

    @Override
    public Weighting createWeighting(Profile profile, PMap requestHints, boolean disableTurnCosts) {
        DecimalEncodedValue priorityEnc;
        TurnCostProvider turnCostProvider;
        PMap hints = new PMap();
        hints.putAll(profile.getHints());
        hints.putAll(requestHints);
        String vehicle = profile.getVehicle();
        if (profile.isTurnCosts() && !disableTurnCosts) {
            BooleanEncodedValue turnRestrictionEnc = this.encodingManager.getTurnBooleanEncodedValue(TurnRestriction.key(vehicle));
            if (turnRestrictionEnc == null) {
                throw new IllegalArgumentException("Vehicle " + vehicle + " does not support turn costs");
            }
            int uTurnCosts = hints.getInt("u_turn_costs", -1);
            turnCostProvider = new DefaultTurnCostProvider(turnRestrictionEnc, this.graph.getTurnCostStorage(), uTurnCosts);
        } else {
            turnCostProvider = TurnCostProvider.NO_TURN_COST_PROVIDER;
        }
        String weightingStr = Helper.toLowerCase((String)profile.getWeighting());
        if (weightingStr.isEmpty()) {
            throw new IllegalArgumentException("You have to specify a weighting");
        }
        CustomWeighting weighting = null;
        BooleanEncodedValue accessEnc = this.encodingManager.getBooleanEncodedValue(VehicleAccess.key(vehicle));
        DecimalEncodedValue speedEnc = this.encodingManager.getDecimalEncodedValue(VehicleSpeed.key(vehicle));
        DecimalEncodedValue decimalEncodedValue = priorityEnc = this.encodingManager.hasEncodedValue(VehiclePriority.key(vehicle)) ? this.encodingManager.getDecimalEncodedValue(VehiclePriority.key(vehicle)) : null;
        if ("custom".equalsIgnoreCase(weightingStr)) {
            CustomModel queryCustomModel = (CustomModel)requestHints.getObject("custom_model", null);
            CustomModel mergedCustomModel = CustomModel.merge((CustomModel)profile.getCustomModel(), (CustomModel)queryCustomModel);
            if (requestHints.has("heading_penalty")) {
                mergedCustomModel.setHeadingPenalty(requestHints.getDouble("heading_penalty", 300.0));
            }
            weighting = CustomModelParser.createWeighting(accessEnc, speedEnc, priorityEnc, this.encodingManager, turnCostProvider, mergedCustomModel);
        } else {
            if ("shortest".equalsIgnoreCase(weightingStr)) {
                throw new IllegalArgumentException("Instead of weighting=shortest use weighting=custom with a high distance_influence");
            }
            if ("fastest".equalsIgnoreCase(weightingStr)) {
                throw new IllegalArgumentException("Instead of weighting=fastest use weighting=custom with a custom model that avoids road_access == DESTINATION");
            }
            if ("curvature".equalsIgnoreCase(weightingStr)) {
                throw new IllegalArgumentException("The curvature weighting is no longer supported since 7.0. Use a custom model with the EncodedValue 'curvature' instead");
            }
            if ("short_fastest".equalsIgnoreCase(weightingStr)) {
                throw new IllegalArgumentException("Instead of weighting=short_fastest use weighting=custom with a distance_influence");
            }
        }
        if (weighting == null) {
            throw new IllegalArgumentException("Weighting '" + weightingStr + "' not supported");
        }
        return weighting;
    }

    public boolean isOutdoorVehicle(String name) {
        return VehicleEncodedValues.OUTDOOR_VEHICLES.contains(name);
    }
}

