/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.IntEncodedValueImpl;

public final class DecimalEncodedValueImpl
extends IntEncodedValueImpl
implements DecimalEncodedValue {
    private final double factor;
    private final boolean useMaximumAsInfinity;

    public DecimalEncodedValueImpl(String name, int bits, double factor, boolean storeTwoDirections) {
        this(name, bits, 0.0, factor, false, storeTwoDirections, false);
    }

    public DecimalEncodedValueImpl(String name, int bits, double minStorableValue, double factor, boolean negateReverseDirection, boolean storeTwoDirections, boolean useMaximumAsInfinity) {
        super(name, bits, (int)Math.round(minStorableValue / factor), negateReverseDirection, storeTwoDirections);
        if (!negateReverseDirection && (double)this.minStorableValue * factor != minStorableValue) {
            throw new IllegalArgumentException("minStorableValue " + minStorableValue + " is not a multiple of the specified factor " + factor + " (" + (double)this.minStorableValue * factor + ")");
        }
        this.factor = factor;
        this.useMaximumAsInfinity = useMaximumAsInfinity;
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    DecimalEncodedValueImpl(@JsonProperty(value="name") String name, @JsonProperty(value="bits") int bits, @JsonProperty(value="min_storable_value") int minStorableValue, @JsonProperty(value="max_storable_value") int maxStorableValue, @JsonProperty(value="max_value") int maxValue, @JsonProperty(value="negate_reverse_direction") boolean negateReverseDirection, @JsonProperty(value="store_two_directions") boolean storeTwoDirections, @JsonProperty(value="fwd_data_index") int fwdDataIndex, @JsonProperty(value="bwd_data_index") int bwdDataIndex, @JsonProperty(value="fwd_shift") int fwdShift, @JsonProperty(value="bwd_shift") int bwdShift, @JsonProperty(value="fwd_mask") int fwdMask, @JsonProperty(value="bwd_mask") int bwdMask, @JsonProperty(value="factor") double factor, @JsonProperty(value="use_maximum_as_infinity") boolean useMaximumAsInfinity) {
        super(name, bits, minStorableValue, maxStorableValue, maxValue, negateReverseDirection, storeTwoDirections, fwdDataIndex, bwdDataIndex, fwdShift, bwdShift, fwdMask, bwdMask);
        this.factor = factor;
        this.useMaximumAsInfinity = useMaximumAsInfinity;
    }

    @Override
    public void setDecimal(boolean reverse, int edgeId, EdgeIntAccess edgeIntAccess, double value) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Call init before using EncodedValue " + this.getName());
        }
        if (this.useMaximumAsInfinity) {
            if (Double.isInfinite(value)) {
                super.setInt(reverse, edgeId, edgeIntAccess, this.maxStorableValue);
                return;
            }
            if (value >= (double)this.maxStorableValue * this.factor) {
                super.uncheckedSet(reverse, edgeId, edgeIntAccess, this.maxStorableValue - 1);
                return;
            }
        } else if (Double.isInfinite(value)) {
            throw new IllegalArgumentException("Value cannot be infinite if useMaximumAsInfinity is false");
        }
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("NaN value for " + this.getName() + " not allowed!");
        }
        if ((value /= this.factor) > (double)this.maxStorableValue) {
            throw new IllegalArgumentException(this.getName() + " value too large for encoding: " + value + ", maxValue:" + this.maxStorableValue + ", factor: " + this.factor);
        }
        if (value < (double)this.minStorableValue) {
            throw new IllegalArgumentException(this.getName() + " value too small for encoding " + value + ", minValue:" + this.minStorableValue + ", factor: " + this.factor);
        }
        super.uncheckedSet(reverse, edgeId, edgeIntAccess, (int)Math.round(value));
    }

    @Override
    public double getDecimal(boolean reverse, int edgeId, EdgeIntAccess edgeIntAccess) {
        int value = this.getInt(reverse, edgeId, edgeIntAccess);
        if (this.useMaximumAsInfinity && value == this.maxStorableValue) {
            return Double.POSITIVE_INFINITY;
        }
        return (double)value * this.factor;
    }

    @Override
    public double getNextStorableValue(double value) {
        if (!this.useMaximumAsInfinity && value > this.getMaxStorableDecimal()) {
            throw new IllegalArgumentException(this.getName() + ": There is no next storable value for " + value + ". max:" + this.getMaxStorableDecimal());
        }
        if (this.useMaximumAsInfinity && value > (double)(this.maxStorableValue - 1) * this.factor) {
            return Double.POSITIVE_INFINITY;
        }
        return this.factor * (double)((int)Math.ceil(value / this.factor));
    }

    @Override
    public double getSmallestNonZeroValue() {
        if (this.minStorableValue != 0 || this.negateReverseDirection) {
            throw new IllegalStateException("getting the smallest non-zero value is not possible if minValue!=0 or negateReverseDirection");
        }
        return this.factor;
    }

    @Override
    public double getMaxStorableDecimal() {
        if (this.useMaximumAsInfinity) {
            return Double.POSITIVE_INFINITY;
        }
        return (double)this.maxStorableValue * this.factor;
    }

    @Override
    public double getMinStorableDecimal() {
        return (double)this.minStorableValue * this.factor;
    }

    @Override
    public double getMaxOrMaxStorableDecimal() {
        int maxOrMaxStorable = this.getMaxOrMaxStorableInt();
        if (this.useMaximumAsInfinity && maxOrMaxStorable == this.maxStorableValue) {
            return Double.POSITIVE_INFINITY;
        }
        return (double)maxOrMaxStorable * this.factor;
    }
}

