/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.AverageSlope;
import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.ev.Crossing;
import com.graphhopper.routing.ev.Curvature;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueFactory;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.FerrySpeed;
import com.graphhopper.routing.ev.FootNetwork;
import com.graphhopper.routing.ev.Footway;
import com.graphhopper.routing.ev.GetOffBike;
import com.graphhopper.routing.ev.Hazmat;
import com.graphhopper.routing.ev.HazmatTunnel;
import com.graphhopper.routing.ev.HazmatWater;
import com.graphhopper.routing.ev.Hgv;
import com.graphhopper.routing.ev.HikeRating;
import com.graphhopper.routing.ev.HorseRating;
import com.graphhopper.routing.ev.Lanes;
import com.graphhopper.routing.ev.MaxAxleLoad;
import com.graphhopper.routing.ev.MaxHeight;
import com.graphhopper.routing.ev.MaxLength;
import com.graphhopper.routing.ev.MaxSlope;
import com.graphhopper.routing.ev.MaxSpeed;
import com.graphhopper.routing.ev.MaxSpeedEstimated;
import com.graphhopper.routing.ev.MaxWeight;
import com.graphhopper.routing.ev.MaxWeightExcept;
import com.graphhopper.routing.ev.MaxWidth;
import com.graphhopper.routing.ev.MtbRating;
import com.graphhopper.routing.ev.OSMWayID;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.RoadClassLink;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.ev.Roundabout;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.ev.State;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.ev.Surface;
import com.graphhopper.routing.ev.Toll;
import com.graphhopper.routing.ev.TrackType;
import com.graphhopper.util.PMap;

public class DefaultEncodedValueFactory
implements EncodedValueFactory {
    @Override
    public EncodedValue create(String name, PMap properties) {
        if ("roundabout".equals(name)) {
            return Roundabout.create();
        }
        if ("get_off_bike".equals(name)) {
            return GetOffBike.create();
        }
        if ("road_class".equals(name)) {
            return RoadClass.create();
        }
        if ("road_class_link".equals(name)) {
            return RoadClassLink.create();
        }
        if ("road_environment".equals(name)) {
            return RoadEnvironment.create();
        }
        if ("road_access".equals(name)) {
            return RoadAccess.create();
        }
        if ("max_speed".equals(name)) {
            return MaxSpeed.create();
        }
        if ("max_speed_estimated".equals(name)) {
            return MaxSpeedEstimated.create();
        }
        if ("max_weight".equals(name)) {
            return MaxWeight.create();
        }
        if ("max_weight_except".equals(name)) {
            return MaxWeightExcept.create();
        }
        if ("max_height".equals(name)) {
            return MaxHeight.create();
        }
        if ("max_width".equals(name)) {
            return MaxWidth.create();
        }
        if ("max_axle_load".equals(name)) {
            return MaxAxleLoad.create();
        }
        if ("max_length".equals(name)) {
            return MaxLength.create();
        }
        if ("hgv".equals(name)) {
            return Hgv.create();
        }
        if ("surface".equals(name)) {
            return Surface.create();
        }
        if ("smoothness".equals(name)) {
            return Smoothness.create();
        }
        if ("toll".equals(name)) {
            return Toll.create();
        }
        if ("track_type".equals(name)) {
            return TrackType.create();
        }
        if (BikeNetwork.KEY.equals(name) || FootNetwork.KEY.equals(name)) {
            return RouteNetwork.create(name);
        }
        if ("hazmat".equals(name)) {
            return Hazmat.create();
        }
        if ("hazmat_tunnel".equals(name)) {
            return HazmatTunnel.create();
        }
        if ("hazmat_water".equals(name)) {
            return HazmatWater.create();
        }
        if ("lanes".equals(name)) {
            return Lanes.create();
        }
        if ("footway".equals(name)) {
            return Footway.create();
        }
        if ("osm_way_id".equals(name)) {
            return OSMWayID.create();
        }
        if ("mtb_rating".equals(name)) {
            return MtbRating.create();
        }
        if ("hike_rating".equals(name)) {
            return HikeRating.create();
        }
        if ("horse_rating".equals(name)) {
            return HorseRating.create();
        }
        if ("country".equals(name)) {
            return Country.create();
        }
        if ("state".equals(name)) {
            return State.create();
        }
        if (name.endsWith(Subnetwork.key(""))) {
            return Subnetwork.create(name);
        }
        if ("max_slope".equals(name)) {
            return MaxSlope.create();
        }
        if ("average_slope".equals(name)) {
            return AverageSlope.create();
        }
        if ("curvature".equals(name)) {
            return Curvature.create();
        }
        if ("crossing".equals(name)) {
            return new EnumEncodedValue<Crossing>("crossing", Crossing.class);
        }
        if ("ferry_speed".equals(name)) {
            return FerrySpeed.create();
        }
        throw new IllegalArgumentException("DefaultEncodedValueFactory cannot find EncodedValue " + name);
    }
}

