/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.LMProfile;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.lm.LMConfig;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.lm.LandmarkSuggestion;
import com.graphhopper.routing.lm.PrepareLandmarks;
import com.graphhopper.routing.lm.SplitArea;
import com.graphhopper.routing.util.AreaIndex;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.JsonFeatureCollection;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LMPreparationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LMPreparationHandler.class);
    private int landmarkCount = 16;
    private final List<LMProfile> lmProfiles = new ArrayList<LMProfile>();
    private final Map<String, Double> maximumWeights = new HashMap<String, Double>();
    private int minNodes = -1;
    private final List<String> lmSuggestionsLocations = new ArrayList<String>(5);
    private int preparationThreads;
    private boolean logDetails = false;
    private AreaIndex<SplitArea> areaIndex;

    public LMPreparationHandler() {
        this.setPreparationThreads(1);
    }

    public void init(GraphHopperConfig ghConfig) {
        if (ghConfig.has("prepare.lm.weightings")) {
            throw new IllegalStateException("Use profiles_lm instead of prepare.lm.weightings, see #1922 and docs/core/profiles.md");
        }
        this.setPreparationThreads(ghConfig.getInt("prepare.lm.threads", this.getPreparationThreads()));
        this.setLMProfiles(ghConfig.getLMProfiles());
        this.landmarkCount = ghConfig.getInt("prepare.lm.landmarks", this.landmarkCount);
        this.logDetails = ghConfig.getBool("prepare.lm.log_details", false);
        this.minNodes = ghConfig.getInt("prepare.lm.min_network_size", -1);
        for (String loc : ghConfig.getString("prepare.lm.suggestions_location", "").split(",")) {
            if (loc.trim().isEmpty()) continue;
            this.lmSuggestionsLocations.add(loc.trim());
        }
        if (!this.isEnabled()) {
            return;
        }
        String splitAreaLocation = ghConfig.getString("prepare.lm.split_area_location", "");
        JsonFeatureCollection landmarkSplittingFeatureCollection = this.loadLandmarkSplittingFeatureCollection(splitAreaLocation);
        if (landmarkSplittingFeatureCollection != null && !landmarkSplittingFeatureCollection.getFeatures().isEmpty()) {
            List splitAreas = landmarkSplittingFeatureCollection.getFeatures().stream().map(SplitArea::fromJsonFeature).collect(Collectors.toList());
            this.areaIndex = new AreaIndex(splitAreas);
        }
    }

    public int getLandmarks() {
        return this.landmarkCount;
    }

    public final boolean isEnabled() {
        return !this.lmProfiles.isEmpty();
    }

    public int getPreparationThreads() {
        return this.preparationThreads;
    }

    public void setPreparationThreads(int preparationThreads) {
        this.preparationThreads = preparationThreads;
    }

    public LMPreparationHandler setLMProfiles(LMProfile ... lmProfiles) {
        return this.setLMProfiles(Arrays.asList(lmProfiles));
    }

    public LMPreparationHandler setLMProfiles(Collection<LMProfile> lmProfiles) {
        this.lmProfiles.clear();
        this.maximumWeights.clear();
        for (LMProfile profile : lmProfiles) {
            if (profile.usesOtherPreparation()) continue;
            this.maximumWeights.put(profile.getProfile(), profile.getMaximumLMWeight());
        }
        this.lmProfiles.addAll(lmProfiles);
        return this;
    }

    public List<LMProfile> getLMProfiles() {
        return this.lmProfiles;
    }

    public List<LandmarkStorage> load(List<LMConfig> lmConfigs, BaseGraph baseGraph, EncodedValueLookup encodedValueLookup) {
        List<LandmarkStorage> loaded = Collections.synchronizedList(new ArrayList());
        Stream<Runnable> loadingRunnables = lmConfigs.stream().map(lmConfig -> () -> {
            LandmarkStorage lms = new LandmarkStorage(baseGraph, encodedValueLookup, baseGraph.getDirectory(), (LMConfig)lmConfig, this.landmarkCount);
            if (lms.loadExisting()) {
                loaded.add(lms);
            } else {
                baseGraph.getDirectory().remove("landmarks_" + lmConfig.getName());
                baseGraph.getDirectory().remove("landmarks_subnetwork_" + lmConfig.getName());
            }
        });
        GHUtility.runConcurrently(loadingRunnables, this.preparationThreads);
        return loaded;
    }

    public List<PrepareLandmarks> prepare(List<LMConfig> lmConfigs, BaseGraph baseGraph, EncodingManager encodingManager, StorableProperties properties, LocationIndex locationIndex, boolean closeEarly) {
        List<PrepareLandmarks> preparations = this.createPreparations(lmConfigs, baseGraph, encodingManager, locationIndex);
        ArrayList<Runnable> prepareRunnables = new ArrayList<Runnable>();
        for (int i = 0; i < preparations.size(); ++i) {
            PrepareLandmarks prepare = preparations.get(i);
            int count = i + 1;
            String name = prepare.getLMConfig().getName();
            prepareRunnables.add(() -> {
                LOGGER.info(count + "/" + lmConfigs.size() + " calling LM prepare.doWork for " + prepare.getLMConfig().getWeighting() + " ... (" + Helper.getMemInfo() + ")");
                Thread.currentThread().setName(name);
                prepare.doWork();
                if (closeEarly) {
                    prepare.close();
                }
                LOGGER.info("LM {} finished {}", (Object)name, (Object)Helper.getMemInfo());
                properties.put("prepare.lm.date." + name, Helper.createFormatter().format(new Date()));
            });
        }
        GHUtility.runConcurrently(prepareRunnables.stream(), this.preparationThreads);
        LOGGER.info("Finished LM preparation, {}", (Object)Helper.getMemInfo());
        return preparations;
    }

    List<PrepareLandmarks> createPreparations(List<LMConfig> lmConfigs, BaseGraph graph, EncodedValueLookup encodedValueLookup, LocationIndex locationIndex) {
        LOGGER.info("Creating LM preparations, {}", (Object)Helper.getMemInfo());
        ArrayList<LandmarkSuggestion> lmSuggestions = new ArrayList<LandmarkSuggestion>(this.lmSuggestionsLocations.size());
        if (!this.lmSuggestionsLocations.isEmpty()) {
            try {
                for (String loc : this.lmSuggestionsLocations) {
                    lmSuggestions.add(LandmarkSuggestion.readLandmarks(loc, locationIndex));
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        ArrayList<PrepareLandmarks> preparations = new ArrayList<PrepareLandmarks>();
        for (LMConfig lmConfig : lmConfigs) {
            Double maximumWeight = this.maximumWeights.get(lmConfig.getName());
            if (maximumWeight == null) {
                throw new IllegalStateException("maximumWeight cannot be null. Default should be just negative. Couldn't find " + lmConfig.getName() + " in " + this.maximumWeights);
            }
            PrepareLandmarks prepareLandmarks = new PrepareLandmarks(graph.getDirectory(), graph, encodedValueLookup, lmConfig, this.landmarkCount).setLandmarkSuggestions(lmSuggestions).setMaximumWeight(maximumWeight).setLogDetails(this.logDetails);
            if (this.minNodes > 1) {
                prepareLandmarks.setMinimumNodes(this.minNodes);
            }
            if (this.areaIndex != null) {
                prepareLandmarks.setAreaIndex(this.areaIndex);
            }
            preparations.add(prepareLandmarks);
        }
        return preparations;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonFeatureCollection loadLandmarkSplittingFeatureCollection(String splitAreaLocation) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JtsModule());
        URL builtinSplittingFile = LandmarkStorage.class.getResource("map.geo.json");
        try (InputStreamReader reader = splitAreaLocation.isEmpty() ? new InputStreamReader(builtinSplittingFile.openStream(), Helper.UTF_CS) : new InputStreamReader((InputStream)new FileInputStream(splitAreaLocation), Helper.UTF_CS);){
            JsonFeatureCollection result = (JsonFeatureCollection)objectMapper.readValue((Reader)reader, JsonFeatureCollection.class);
            if (splitAreaLocation.isEmpty()) {
                LOGGER.info("Loaded built-in landmark splitting collection from {}", (Object)builtinSplittingFile);
            } else {
                LOGGER.info("Loaded landmark splitting collection from {}", (Object)splitAreaLocation);
            }
            JsonFeatureCollection jsonFeatureCollection = result;
            return jsonFeatureCollection;
        }
        catch (IOException e) {
            LOGGER.error("Problem while reading border map GeoJSON. Skipping this.", (Throwable)e);
            return null;
        }
    }
}

