/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.util.EdgeIteratorState;

public class AccessFilter
implements EdgeFilter {
    private final boolean bwd;
    private final boolean fwd;
    private final BooleanEncodedValue accessEnc;

    private AccessFilter(BooleanEncodedValue accessEnc, boolean fwd, boolean bwd) {
        this.accessEnc = accessEnc;
        this.fwd = fwd;
        this.bwd = bwd;
    }

    public static AccessFilter outEdges(BooleanEncodedValue accessEnc) {
        return new AccessFilter(accessEnc, true, false);
    }

    public static AccessFilter inEdges(BooleanEncodedValue accessEnc) {
        return new AccessFilter(accessEnc, false, true);
    }

    public static AccessFilter allEdges(BooleanEncodedValue accessEnc) {
        return new AccessFilter(accessEnc, true, true);
    }

    public BooleanEncodedValue getAccessEnc() {
        return this.accessEnc;
    }

    @Override
    public final boolean accept(EdgeIteratorState iter) {
        return this.fwd && iter.get(this.accessEnc) || this.bwd && iter.getReverse(this.accessEnc);
    }

    public String toString() {
        return this.accessEnc.toString() + ", bwd:" + this.bwd + ", fwd:" + this.fwd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessFilter that = (AccessFilter)o;
        if (this.bwd != that.bwd) {
            return false;
        }
        if (this.fwd != that.fwd) {
            return false;
        }
        return this.accessEnc.equals(that.accessEnc);
    }

    public int hashCode() {
        int result = this.bwd ? 1 : 0;
        result = 31 * result + (this.fwd ? 1 : 0);
        result = 31 * result + this.accessEnc.hashCode();
        return result;
    }
}

