/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.routing.util.DirectedEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.util.AngleCalc;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.GHPoint;

public class HeadingEdgeFilter
implements EdgeFilter {
    private final double heading;
    private final DirectedEdgeFilter directedEdgeFilter;
    private final GHPoint pointNearHeading;

    public HeadingEdgeFilter(DirectedEdgeFilter directedEdgeFilter, double heading, GHPoint pointNearHeading) {
        this.directedEdgeFilter = directedEdgeFilter;
        this.heading = heading;
        this.pointNearHeading = pointNearHeading;
    }

    @Override
    public boolean accept(EdgeIteratorState edgeState) {
        double tolerance = 30.0;
        double maxDistance = 20.0;
        double headingOfEdge = HeadingEdgeFilter.getHeadingOfGeometryNearPoint(edgeState, this.pointNearHeading, 20.0);
        if (Double.isNaN(headingOfEdge)) {
            return false;
        }
        return Math.abs(headingOfEdge - this.heading) < 30.0 && this.directedEdgeFilter.accept(edgeState, false) || Math.abs((headingOfEdge + 180.0) % 360.0 - this.heading) < 30.0 && this.directedEdgeFilter.accept(edgeState, true);
    }

    static double getHeadingOfGeometryNearPoint(EdgeIteratorState edgeState, GHPoint point, double maxDistance) {
        DistanceCalcEarth calcDist = DistanceCalcEarth.DIST_EARTH;
        double closestDistance = Double.POSITIVE_INFINITY;
        PointList points = edgeState.fetchWayGeometry(FetchMode.ALL);
        int closestPoint = -1;
        for (int i = 1; i < points.size(); ++i) {
            double toLon;
            double toLat;
            double fromLon;
            double distance;
            double fromLat = points.getLat(i - 1);
            double d = distance = calcDist.validEdgeDistance(point.lat, point.lon, fromLat, fromLon = points.getLon(i - 1), toLat = points.getLat(i), toLon = points.getLon(i)) ? calcDist.calcDenormalizedDist(calcDist.calcNormalizedEdgeDistance(point.lat, point.lon, fromLat, fromLon, toLat, toLon)) : calcDist.calcDist(fromLat, fromLon, point.lat, point.lon);
            if (i == points.size() - 1) {
                distance = Math.min(distance, calcDist.calcDist(toLat, toLon, point.lat, point.lon));
            }
            if (distance > maxDistance || !(distance < closestDistance)) continue;
            closestDistance = distance;
            closestPoint = i;
        }
        if (closestPoint < 0) {
            return Double.NaN;
        }
        double fromLat = points.getLat(closestPoint - 1);
        double fromLon = points.getLon(closestPoint - 1);
        double toLat = points.getLat(closestPoint);
        double toLon = points.getLon(closestPoint);
        return AngleCalc.ANGLE_CALC.calcAzimuth(fromLat, fromLon, toLat, toLon);
    }
}

