/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.osm.RestrictionTagParser;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.util.parsers.RelationTagParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class OSMParsers {
    private final List<String> ignoredHighways;
    private final List<TagParser> wayTagParsers;
    private final List<RelationTagParser> relationTagParsers;
    private final List<RestrictionTagParser> restrictionTagParsers;
    private final EncodedValue.InitializerConfig relConfig = new EncodedValue.InitializerConfig();

    public OSMParsers() {
        this(new ArrayList<String>(), new ArrayList<TagParser>(), new ArrayList<RelationTagParser>(), new ArrayList<RestrictionTagParser>());
    }

    public OSMParsers(List<String> ignoredHighways, List<TagParser> wayTagParsers, List<RelationTagParser> relationTagParsers, List<RestrictionTagParser> restrictionTagParsers) {
        this.ignoredHighways = ignoredHighways;
        this.wayTagParsers = wayTagParsers;
        this.relationTagParsers = relationTagParsers;
        this.restrictionTagParsers = restrictionTagParsers;
    }

    public OSMParsers addIgnoredHighway(String highway) {
        this.ignoredHighways.add(highway);
        return this;
    }

    public OSMParsers addWayTagParser(TagParser tagParser) {
        this.wayTagParsers.add(tagParser);
        return this;
    }

    public OSMParsers addRelationTagParser(Function<EncodedValue.InitializerConfig, RelationTagParser> createRelationTagParser) {
        this.relationTagParsers.add(createRelationTagParser.apply(this.relConfig));
        return this;
    }

    public OSMParsers addRestrictionTagParser(RestrictionTagParser restrictionTagParser) {
        this.restrictionTagParsers.add(restrictionTagParser);
        return this;
    }

    public boolean acceptWay(ReaderWay way) {
        String highway = way.getTag("highway");
        if (highway != null) {
            return !this.ignoredHighways.contains(highway);
        }
        if (way.getTag("route") != null) {
            return true;
        }
        if ("pier".equals(way.getTag("man_made"))) {
            return true;
        }
        return "platform".equals(way.getTag("railway"));
    }

    public IntsRef handleRelationTags(ReaderRelation relation, IntsRef relFlags) {
        for (RelationTagParser relParser : this.relationTagParsers) {
            relParser.handleRelationTags(relFlags, relation);
        }
        return relFlags;
    }

    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, IntsRef relationFlags) {
        for (RelationTagParser relParser : this.relationTagParsers) {
            relParser.handleWayTags(edgeId, edgeIntAccess, way, relationFlags);
        }
        for (TagParser parser : this.wayTagParsers) {
            parser.handleWayTags(edgeId, edgeIntAccess, way, relationFlags);
        }
    }

    public IntsRef createRelationFlags() {
        int requiredInts = this.relConfig.getRequiredInts();
        if (requiredInts > 2) {
            throw new IllegalStateException("More than two ints are needed for relation flags, but OSMReader does not allow this");
        }
        return new IntsRef(2);
    }

    public List<String> getIgnoredHighways() {
        return this.ignoredHighways;
    }

    public List<TagParser> getWayTagParsers() {
        return this.wayTagParsers;
    }

    public List<RelationTagParser> getRelationTagParsers() {
        return this.relationTagParsers;
    }

    public List<RestrictionTagParser> getRestrictionTagParsers() {
        return this.restrictionTagParsers;
    }
}

