/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.helpers.OSMValueExtractor;
import com.graphhopper.storage.IntsRef;

public abstract class AbstractAverageSpeedParser
implements TagParser {
    protected final DecimalEncodedValue avgSpeedEnc;
    protected final DecimalEncodedValue ferrySpeedEnc;

    protected AbstractAverageSpeedParser(DecimalEncodedValue speedEnc, DecimalEncodedValue ferrySpeedEnc) {
        this.avgSpeedEnc = speedEnc;
        this.ferrySpeedEnc = ferrySpeedEnc;
    }

    public static double getMaxSpeed(ReaderWay way, boolean bwd) {
        double maxSpeed = OSMValueExtractor.stringToKmh(way.getTag("maxspeed"));
        double directedMaxSpeed = OSMValueExtractor.stringToKmh(way.getTag(bwd ? "maxspeed:backward" : "maxspeed:forward"));
        return AbstractAverageSpeedParser.isValidSpeed(directedMaxSpeed) ? directedMaxSpeed : maxSpeed;
    }

    protected static boolean isValidSpeed(double speed) {
        return !Double.isNaN(speed);
    }

    public final DecimalEncodedValue getAverageSpeedEnc() {
        return this.avgSpeedEnc;
    }

    protected void setSpeed(boolean reverse, int edgeId, EdgeIntAccess edgeIntAccess, double speed) {
        if (speed < this.avgSpeedEnc.getSmallestNonZeroValue() / 2.0) {
            throw new IllegalArgumentException("Speed was " + speed + " but cannot be lower than " + this.avgSpeedEnc.getSmallestNonZeroValue() / 2.0);
        }
        this.avgSpeedEnc.setDecimal(reverse, edgeId, edgeIntAccess, speed);
    }

    public final String getName() {
        return this.avgSpeedEnc.getName();
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, IntsRef relationFlags) {
        this.handleWayTags(edgeId, edgeIntAccess, way);
    }

    public abstract void handleWayTags(int var1, EdgeIntAccess var2, ReaderWay var3);

    public String toString() {
        return this.getName();
    }
}

