/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.FootNetwork;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.util.FerrySpeedCalculator;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.parsers.AbstractAccessParser;
import com.graphhopper.routing.util.parsers.AbstractAverageSpeedParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.PMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class FootPriorityParser
implements TagParser {
    final Set<String> intendedValues = new HashSet<String>(AbstractAccessParser.INTENDED);
    final Set<String> safeHighwayTags = new HashSet<String>();
    final Set<String> avoidHighwayTags = new HashSet<String>();
    protected HashSet<String> sidewalkValues = new HashSet(5);
    protected HashSet<String> sidewalksNoValues = new HashSet(5);
    protected final DecimalEncodedValue priorityWayEncoder;
    protected EnumEncodedValue<RouteNetwork> footRouteEnc;
    protected Map<RouteNetwork, Integer> routeMap = new HashMap<RouteNetwork, Integer>();

    public FootPriorityParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getDecimalEncodedValue(VehiclePriority.key(properties.getString("name", "foot"))), lookup.getEnumEncodedValue(FootNetwork.KEY, RouteNetwork.class));
    }

    protected FootPriorityParser(DecimalEncodedValue priorityEnc, EnumEncodedValue<RouteNetwork> footRouteEnc) {
        this.footRouteEnc = footRouteEnc;
        this.priorityWayEncoder = priorityEnc;
        this.sidewalksNoValues.add("no");
        this.sidewalksNoValues.add("none");
        this.sidewalksNoValues.add("separate");
        this.sidewalkValues.add("yes");
        this.sidewalkValues.add("both");
        this.sidewalkValues.add("left");
        this.sidewalkValues.add("right");
        this.safeHighwayTags.add("footway");
        this.safeHighwayTags.add("path");
        this.safeHighwayTags.add("steps");
        this.safeHighwayTags.add("pedestrian");
        this.safeHighwayTags.add("living_street");
        this.safeHighwayTags.add("track");
        this.safeHighwayTags.add("residential");
        this.safeHighwayTags.add("service");
        this.safeHighwayTags.add("platform");
        this.avoidHighwayTags.add("trunk");
        this.avoidHighwayTags.add("trunk_link");
        this.avoidHighwayTags.add("primary");
        this.avoidHighwayTags.add("primary_link");
        this.avoidHighwayTags.add("secondary");
        this.avoidHighwayTags.add("secondary_link");
        this.avoidHighwayTags.add("tertiary");
        this.avoidHighwayTags.add("tertiary_link");
        this.routeMap.put(RouteNetwork.INTERNATIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.NATIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.REGIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.LOCAL, PriorityCode.UNCHANGED.getValue());
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, IntsRef relationFlags) {
        String highwayValue = way.getTag("highway");
        Integer priorityFromRelation = this.routeMap.get((Object)this.footRouteEnc.getEnum(false, edgeId, edgeIntAccess));
        if (highwayValue == null) {
            if (FerrySpeedCalculator.isFerry(way)) {
                this.priorityWayEncoder.setDecimal(false, edgeId, edgeIntAccess, PriorityCode.getValue(this.handlePriority(way, priorityFromRelation)));
            }
        } else {
            this.priorityWayEncoder.setDecimal(false, edgeId, edgeIntAccess, PriorityCode.getValue(this.handlePriority(way, priorityFromRelation)));
        }
    }

    public int handlePriority(ReaderWay way, Integer priorityFromRelation) {
        TreeMap<Double, Integer> weightToPrioMap = new TreeMap<Double, Integer>();
        if (priorityFromRelation == null) {
            weightToPrioMap.put(0.0, PriorityCode.UNCHANGED.getValue());
        } else {
            weightToPrioMap.put(110.0, priorityFromRelation);
        }
        this.collect(way, weightToPrioMap);
        return weightToPrioMap.lastEntry().getValue();
    }

    void collect(ReaderWay way, TreeMap<Double, Integer> weightToPrioMap) {
        String highway = way.getTag("highway");
        if (way.hasTag("foot", (Object)"designated")) {
            weightToPrioMap.put(100.0, PriorityCode.PREFER.getValue());
        }
        double maxSpeed = Math.max(AbstractAverageSpeedParser.getMaxSpeed(way, false), AbstractAverageSpeedParser.getMaxSpeed(way, true));
        if (this.safeHighwayTags.contains(highway) || AbstractAverageSpeedParser.isValidSpeed(maxSpeed) && maxSpeed <= 20.0) {
            weightToPrioMap.put(40.0, PriorityCode.PREFER.getValue());
            if (way.hasTag("tunnel", this.intendedValues)) {
                if (way.hasTag("sidewalk", this.sidewalksNoValues)) {
                    weightToPrioMap.put(40.0, PriorityCode.AVOID.getValue());
                } else {
                    weightToPrioMap.put(40.0, PriorityCode.UNCHANGED.getValue());
                }
            }
        } else if (AbstractAverageSpeedParser.isValidSpeed(maxSpeed) && maxSpeed > 50.0 || this.avoidHighwayTags.contains(highway)) {
            if (way.hasTag("sidewalk", this.sidewalksNoValues)) {
                weightToPrioMap.put(40.0, PriorityCode.VERY_BAD.getValue());
            } else if (!way.hasTag("sidewalk", this.sidewalkValues)) {
                weightToPrioMap.put(40.0, PriorityCode.AVOID.getValue());
            } else {
                weightToPrioMap.put(40.0, PriorityCode.SLIGHT_AVOID.getValue());
            }
        } else if (way.hasTag("sidewalk", this.sidewalksNoValues)) {
            weightToPrioMap.put(40.0, PriorityCode.AVOID.getValue());
        }
        if (way.hasTag("bicycle", (Object)"official") || way.hasTag("bicycle", (Object)"designated")) {
            weightToPrioMap.put(44.0, PriorityCode.SLIGHT_AVOID.getValue());
        }
    }
}

