/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.parsers.BikeCommonAverageSpeedParser;
import com.graphhopper.util.PMap;

public class MountainBikeAverageSpeedParser
extends BikeCommonAverageSpeedParser {
    public MountainBikeAverageSpeedParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getDecimalEncodedValue(VehicleSpeed.key(properties.getString("name", "mtb"))), lookup.getEnumEncodedValue("smoothness", Smoothness.class), lookup.getDecimalEncodedValue("ferry_speed"));
    }

    protected MountainBikeAverageSpeedParser(DecimalEncodedValue speedEnc, EnumEncodedValue<Smoothness> smoothnessEnc, DecimalEncodedValue ferrySpeedEnc) {
        super(speedEnc, smoothnessEnc, ferrySpeedEnc);
        this.setTrackTypeSpeed("grade1", 18);
        this.setTrackTypeSpeed("grade2", 16);
        this.setTrackTypeSpeed("grade3", 12);
        this.setTrackTypeSpeed("grade4", 8);
        this.setTrackTypeSpeed("grade5", 6);
        this.setSurfaceSpeed("concrete", 14);
        this.setSurfaceSpeed("concrete:lanes", 16);
        this.setSurfaceSpeed("concrete:plates", 16);
        this.setSurfaceSpeed("dirt", 14);
        this.setSurfaceSpeed("earth", 14);
        this.setSurfaceSpeed("fine_gravel", 18);
        this.setSurfaceSpeed("grass", 14);
        this.setSurfaceSpeed("grass_paver", 14);
        this.setSurfaceSpeed("gravel", 16);
        this.setSurfaceSpeed("ground", 16);
        this.setSurfaceSpeed("ice", 2);
        this.setSurfaceSpeed("metal", 10);
        this.setSurfaceSpeed("mud", 12);
        this.setSurfaceSpeed("salt", 12);
        this.setSurfaceSpeed("sand", 10);
        this.setSurfaceSpeed("wood", 10);
        this.setHighwaySpeed("path", 18);
        this.setHighwaySpeed("footway", 4);
        this.setHighwaySpeed("track", 18);
        this.setHighwaySpeed("residential", 16);
    }
}

