/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.helpers.OSMValueExtractor;
import com.graphhopper.storage.IntsRef;

public class OSMMaxSpeedParser
implements TagParser {
    private final DecimalEncodedValue carMaxSpeedEnc;

    public OSMMaxSpeedParser(DecimalEncodedValue carMaxSpeedEnc) {
        if (!carMaxSpeedEnc.isStoreTwoDirections()) {
            throw new IllegalArgumentException("EncodedValue for maxSpeed must be able to store two directions");
        }
        this.carMaxSpeedEnc = carMaxSpeedEnc;
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, IntsRef relationFlags) {
        this.carMaxSpeedEnc.setDecimal(false, edgeId, edgeIntAccess, this.getMaxSpeed(way, false));
        this.carMaxSpeedEnc.setDecimal(true, edgeId, edgeIntAccess, this.getMaxSpeed(way, true));
    }

    private double getMaxSpeed(ReaderWay way, boolean reverse) {
        double maxSpeed = OSMValueExtractor.stringToKmh(way.getTag("maxspeed"));
        double directedMaxSpeed = OSMValueExtractor.stringToKmh(way.getTag(reverse ? "maxspeed:backward" : "maxspeed:forward"));
        return this.isValidSpeed(directedMaxSpeed) ? Math.min(directedMaxSpeed, 150.0) : (this.isValidSpeed(maxSpeed) ? Math.min(maxSpeed, 150.0) : Double.POSITIVE_INFINITY);
    }

    private boolean isValidSpeed(double speed) {
        return !Double.isNaN(speed);
    }
}

