/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.util.FerrySpeedCalculator;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OSMRoadEnvironmentParser
implements TagParser {
    private final EnumEncodedValue<RoadEnvironment> roadEnvEnc;

    public OSMRoadEnvironmentParser(EnumEncodedValue<RoadEnvironment> roadEnvEnc) {
        this.roadEnvEnc = roadEnvEnc;
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay readerWay, IntsRef relationFlags) {
        RoadEnvironment roadEnvironment = RoadEnvironment.OTHER;
        if (FerrySpeedCalculator.isFerry(readerWay)) {
            roadEnvironment = RoadEnvironment.FERRY;
        } else if (readerWay.hasTag("bridge", new String[0]) && !readerWay.hasTag("bridge", (Object)"no")) {
            roadEnvironment = RoadEnvironment.BRIDGE;
        } else if (readerWay.hasTag("tunnel", new String[0]) && !readerWay.hasTag("tunnel", (Object)"no")) {
            roadEnvironment = RoadEnvironment.TUNNEL;
        } else if (readerWay.hasTag("ford", new String[0]) || readerWay.hasTag("highway", (Object)"ford")) {
            roadEnvironment = RoadEnvironment.FORD;
        } else {
            List nodeTags = readerWay.getTag("node_tags", Collections.emptyList());
            if (readerWay.hasTag("gh:barrier_edge", new String[0]) && ((Map)nodeTags.get(0)).containsKey("ford")) {
                roadEnvironment = RoadEnvironment.FORD;
            } else if (readerWay.hasTag("highway", new String[0])) {
                roadEnvironment = RoadEnvironment.ROAD;
            }
        }
        if (roadEnvironment != RoadEnvironment.OTHER) {
            this.roadEnvEnc.setEnum(false, edgeId, edgeIntAccess, roadEnvironment);
        }
    }
}

