/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.parsers.BikeCommonAverageSpeedParser;
import com.graphhopper.util.PMap;

public class RacingBikeAverageSpeedParser
extends BikeCommonAverageSpeedParser {
    public RacingBikeAverageSpeedParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getDecimalEncodedValue(VehicleSpeed.key(properties.getString("name", "racingbike"))), lookup.getEnumEncodedValue("smoothness", Smoothness.class), lookup.getDecimalEncodedValue("ferry_speed"));
    }

    protected RacingBikeAverageSpeedParser(DecimalEncodedValue speedEnc, EnumEncodedValue<Smoothness> smoothnessEnc, DecimalEncodedValue ferrySpeedEnc) {
        super(speedEnc, smoothnessEnc, ferrySpeedEnc);
        this.setTrackTypeSpeed("grade1", 20);
        this.setTrackTypeSpeed("grade2", 10);
        this.setTrackTypeSpeed("grade3", 4);
        this.setTrackTypeSpeed("grade4", 4);
        this.setTrackTypeSpeed("grade5", 4);
        this.setSurfaceSpeed("paved", 20);
        this.setSurfaceSpeed("asphalt", 20);
        this.setSurfaceSpeed("concrete", 20);
        this.setSurfaceSpeed("concrete:lanes", 16);
        this.setSurfaceSpeed("concrete:plates", 16);
        this.setSurfaceSpeed("unpaved", 2);
        this.setSurfaceSpeed("compacted", 2);
        this.setSurfaceSpeed("dirt", 2);
        this.setSurfaceSpeed("earth", 2);
        this.setSurfaceSpeed("fine_gravel", 4);
        this.setSurfaceSpeed("grass", 2);
        this.setSurfaceSpeed("grass_paver", 2);
        this.setSurfaceSpeed("gravel", 2);
        this.setSurfaceSpeed("ground", 2);
        this.setSurfaceSpeed("ice", 2);
        this.setSurfaceSpeed("metal", 2);
        this.setSurfaceSpeed("mud", 2);
        this.setSurfaceSpeed("pebblestone", 4);
        this.setSurfaceSpeed("salt", 2);
        this.setSurfaceSpeed("sand", 2);
        this.setSurfaceSpeed("wood", 2);
        this.setHighwaySpeed("path", 8);
        this.setHighwaySpeed("footway", 4);
        this.setHighwaySpeed("track", 2);
        this.setHighwaySpeed("trunk", 20);
        this.setHighwaySpeed("trunk_link", 20);
        this.setHighwaySpeed("primary", 20);
        this.setHighwaySpeed("primary_link", 20);
        this.setHighwaySpeed("secondary", 20);
        this.setHighwaySpeed("secondary_link", 20);
        this.setHighwaySpeed("tertiary", 20);
        this.setHighwaySpeed("tertiary_link", 20);
        this.addPushingSection("path");
        this.setSmoothnessSpeedFactor(Smoothness.EXCELLENT, 1.2);
        this.setSmoothnessSpeedFactor(Smoothness.VERY_BAD, 0.1);
        this.setSmoothnessSpeedFactor(Smoothness.HORRIBLE, 0.1);
        this.setSmoothnessSpeedFactor(Smoothness.VERY_HORRIBLE, 0.1);
    }
}

