/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.EdgeIterator;

public class DefaultTurnCostProvider
implements TurnCostProvider {
    private final BooleanEncodedValue turnRestrictionEnc;
    private final TurnCostStorage turnCostStorage;
    private final int uTurnCostsInt;
    private final double uTurnCosts;

    public DefaultTurnCostProvider(BooleanEncodedValue turnRestrictionEnc, TurnCostStorage turnCostStorage) {
        this(turnRestrictionEnc, turnCostStorage, -1);
    }

    public DefaultTurnCostProvider(BooleanEncodedValue turnRestrictionEnc, TurnCostStorage turnCostStorage, int uTurnCosts) {
        if (uTurnCosts < 0 && uTurnCosts != -1) {
            throw new IllegalArgumentException("u-turn costs must be positive, or equal to -1 (=infinite costs)");
        }
        this.uTurnCostsInt = uTurnCosts;
        double d = this.uTurnCosts = uTurnCosts < 0 ? Double.POSITIVE_INFINITY : (double)uTurnCosts;
        if (turnCostStorage == null) {
            throw new IllegalArgumentException("No storage set to calculate turn weight");
        }
        this.turnRestrictionEnc = turnRestrictionEnc;
        this.turnCostStorage = turnCostStorage;
    }

    public BooleanEncodedValue getTurnRestrictionEnc() {
        return this.turnRestrictionEnc;
    }

    @Override
    public double calcTurnWeight(int edgeFrom, int nodeVia, int edgeTo) {
        if (!EdgeIterator.Edge.isValid(edgeFrom) || !EdgeIterator.Edge.isValid(edgeTo)) {
            return 0.0;
        }
        double tCost = 0.0;
        if (edgeFrom == edgeTo) {
            tCost = this.uTurnCosts;
        } else if (this.turnRestrictionEnc != null) {
            tCost = this.turnCostStorage.get(this.turnRestrictionEnc, edgeFrom, nodeVia, edgeTo) ? Double.POSITIVE_INFINITY : 0.0;
        }
        return tCost;
    }

    @Override
    public long calcTurnMillis(int inEdge, int viaNode, int outEdge) {
        return (long)(1000.0 * this.calcTurnWeight(inEdge, viaNode, outEdge));
    }

    public String toString() {
        return "default_tcp_" + this.uTurnCostsInt;
    }
}

