/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.EdgeIteratorState;

public class ShortestWeighting
implements Weighting {
    final BooleanEncodedValue accessEnc;
    final DecimalEncodedValue speedEnc;
    final TurnCostProvider tcProvider;

    public ShortestWeighting(BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc) {
        this(accessEnc, speedEnc, TurnCostProvider.NO_TURN_COST_PROVIDER);
    }

    public ShortestWeighting(BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, TurnCostProvider tcProvider) {
        this.accessEnc = accessEnc;
        this.speedEnc = speedEnc;
        this.tcProvider = tcProvider;
    }

    @Override
    public double getMinWeight(double distance) {
        return distance;
    }

    @Override
    public double calcEdgeWeight(EdgeIteratorState edgeState, boolean reverse) {
        if (reverse ? !edgeState.getReverse(this.accessEnc) : !edgeState.get(this.accessEnc)) {
            return Double.POSITIVE_INFINITY;
        }
        return edgeState.getDistance();
    }

    @Override
    public long calcEdgeMillis(EdgeIteratorState edgeState, boolean reverse) {
        double speed = reverse ? edgeState.getReverse(this.speedEnc) : edgeState.get(this.speedEnc);
        return Math.round(edgeState.getDistance() / speed * 3.6 * 1000.0);
    }

    @Override
    public double calcTurnWeight(int inEdge, int viaNode, int outEdge) {
        return this.tcProvider.calcTurnWeight(inEdge, viaNode, outEdge);
    }

    @Override
    public long calcTurnMillis(int inEdge, int viaNode, int outEdge) {
        return this.tcProvider.calcTurnMillis(inEdge, viaNode, outEdge);
    }

    @Override
    public boolean hasTurnCosts() {
        return this.tcProvider != TurnCostProvider.NO_TURN_COST_PROVIDER;
    }

    @Override
    public String getName() {
        return "shortest";
    }
}

