/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.RoutingCHEdgeIteratorState;
import com.graphhopper.util.EdgeIteratorState;

public class RoutingCHEdgeIteratorStateImpl
implements RoutingCHEdgeIteratorState {
    final CHStorage store;
    final BaseGraph baseGraph;
    private final Weighting weighting;
    int edgeId = -1;
    int baseNode;
    int adjNode;
    final BaseGraph.EdgeIteratorStateImpl baseEdgeState;
    long shortcutPointer = -1L;

    public RoutingCHEdgeIteratorStateImpl(CHStorage store, BaseGraph baseGraph, BaseGraph.EdgeIteratorStateImpl baseEdgeState, Weighting weighting) {
        this.store = store;
        this.baseGraph = baseGraph;
        this.baseEdgeState = baseEdgeState;
        this.weighting = weighting;
    }

    boolean init(int edge, int expectedAdjNode) {
        if (edge < 0 || edge >= this.baseGraph.getEdges() + this.store.getShortcuts()) {
            throw new IllegalArgumentException("edge must be in bounds: [0," + (this.baseGraph.getEdges() + this.store.getShortcuts()) + "[");
        }
        this.edgeId = edge;
        if (this.isShortcut()) {
            this.shortcutPointer = this.store.toShortcutPointer(edge - this.baseGraph.getEdges());
            this.baseNode = this.store.getNodeA(this.shortcutPointer);
            this.adjNode = this.store.getNodeB(this.shortcutPointer);
            if (expectedAdjNode == this.adjNode || expectedAdjNode == Integer.MIN_VALUE) {
                return true;
            }
            if (expectedAdjNode == this.baseNode) {
                this.baseNode = this.adjNode;
                this.adjNode = expectedAdjNode;
                return true;
            }
            return false;
        }
        return this.baseEdgeState.init(edge, expectedAdjNode);
    }

    @Override
    public int getEdge() {
        return this.edgeId;
    }

    @Override
    public int getOrigEdge() {
        return this.isShortcut() ? -1 : this.edgeState().getEdge();
    }

    @Override
    public int getOrigEdgeKeyFirst() {
        if (!this.isShortcut() || !this.store.isEdgeBased()) {
            return this.edgeState().getEdgeKey();
        }
        return this.store.getOrigEdgeKeyFirst(this.shortcutPointer);
    }

    @Override
    public int getOrigEdgeKeyLast() {
        if (!this.isShortcut() || !this.store.isEdgeBased()) {
            return this.edgeState().getEdgeKey();
        }
        return this.store.getOrigEdgeKeyLast(this.shortcutPointer);
    }

    @Override
    public int getBaseNode() {
        return this.isShortcut() ? this.baseNode : this.edgeState().getBaseNode();
    }

    @Override
    public int getAdjNode() {
        return this.isShortcut() ? this.adjNode : this.edgeState().getAdjNode();
    }

    @Override
    public boolean isShortcut() {
        return this.edgeId >= this.baseGraph.getEdges();
    }

    @Override
    public int getSkippedEdge1() {
        this.checkShortcut(true, "getSkippedEdge1");
        return this.store.getSkippedEdge1(this.shortcutPointer);
    }

    @Override
    public int getSkippedEdge2() {
        this.checkShortcut(true, "getSkippedEdge2");
        return this.store.getSkippedEdge2(this.shortcutPointer);
    }

    @Override
    public double getWeight(boolean reverse) {
        if (this.isShortcut()) {
            return this.store.getWeight(this.shortcutPointer);
        }
        return this.getOrigEdgeWeight(reverse);
    }

    double getOrigEdgeWeight(boolean reverse) {
        return this.weighting.calcEdgeWeight(this.getBaseGraphEdgeState(), reverse);
    }

    private EdgeIteratorState getBaseGraphEdgeState() {
        this.checkShortcut(false, "getBaseGraphEdgeState");
        return this.edgeState();
    }

    EdgeIteratorState edgeState() {
        return this.baseEdgeState;
    }

    void checkShortcut(boolean shouldBeShortcut, String methodName) {
        if (this.isShortcut()) {
            if (!shouldBeShortcut) {
                throw new IllegalStateException("Cannot call " + methodName + " on shortcut " + this.getEdge());
            }
        } else if (shouldBeShortcut) {
            throw new IllegalStateException("Method " + methodName + " only for shortcuts " + this.getEdge());
        }
    }
}

